/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.Throwables;
import io.airlift.units.Duration;
import io.prestosql.cli.OutputPrinter;
import io.prestosql.client.StatementClient;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class OutputHandler
implements Closeable {
    private static final int MAX_QUEUED_ROWS = 50000;
    private static final int MAX_BUFFERED_ROWS = 10000;
    private static final Duration MAX_BUFFER_TIME = new Duration(3.0, TimeUnit.SECONDS);
    private static final List<?> END_TOKEN = new ArrayList(0);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final OutputPrinter printer;

    public OutputHandler(OutputPrinter printer) {
        this.printer = Objects.requireNonNull(printer, "printer is null");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.printer.finish();
        }
    }

    public void processRows(StatementClient client) throws IOException {
        ArrayBlockingQueue rowQueue = new ArrayBlockingQueue(50000);
        CompletionStage readerFuture = CompletableFuture.runAsync(() -> {
            while (client.isRunning()) {
                Iterable data = client.currentData().getData();
                if (data != null) {
                    for (List row : data) {
                        OutputHandler.putOrThrow(rowQueue, row);
                    }
                }
                client.advance();
            }
        }).whenComplete((result, ex) -> OutputHandler.putOrThrow(rowQueue, END_TOKEN));
        ArrayList<List> rowBuffer = new ArrayList<List>(10000);
        long bufferStart = System.nanoTime();
        try {
            boolean atEnd;
            while (!((CompletableFuture)readerFuture).isDone() && !(atEnd = OutputHandler.drainDetectingEnd(rowQueue, rowBuffer, 10000, END_TOKEN))) {
                List row;
                if (rowBuffer.size() >= 10000 || Duration.nanosSince((long)bufferStart).compareTo(MAX_BUFFER_TIME) >= 0) {
                    this.printer.printRows(Collections.unmodifiableList(rowBuffer), false);
                    rowBuffer.clear();
                    bufferStart = System.nanoTime();
                }
                if ((row = (List)rowQueue.poll(MAX_BUFFER_TIME.toMillis(), TimeUnit.MILLISECONDS)) == END_TOKEN) break;
                if (row == null) continue;
                rowBuffer.add(row);
            }
            if (!rowQueue.isEmpty()) {
                OutputHandler.drainDetectingEnd(rowQueue, rowBuffer, Integer.MAX_VALUE, END_TOKEN);
            }
            this.printer.printRows(Collections.unmodifiableList(rowBuffer), true);
            ((CompletableFuture)readerFuture).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private static <E> boolean drainDetectingEnd(BlockingQueue<E> blockingQueue, List<E> buffer, int maxBufferSize, E endToken) {
        int drained = blockingQueue.drainTo(buffer, maxBufferSize - buffer.size());
        if (drained > 0 && buffer.get(buffer.size() - 1) == endToken) {
            buffer.remove(buffer.size() - 1);
            return true;
        }
        return false;
    }

    private static <E> void putOrThrow(BlockingQueue<E> blockingQueue, E element) {
        try {
            blockingQueue.put(element);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

