/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.FlatLedgerManager;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.ZkLedgerAuditorManager;
import org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

@Deprecated
public class FlatLedgerManagerFactory
extends AbstractZkLedgerManagerFactory {
    public static final String NAME = "flat";
    public static final int CUR_VERSION = 1;
    AbstractConfiguration conf;

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager layoutManager, int factoryVersion) throws IOException {
        Preconditions.checkArgument((layoutManager == null || layoutManager instanceof ZkLayoutManager ? 1 : 0) != 0);
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.zk = layoutManager == null ? null : ((ZkLayoutManager)layoutManager).getZk();
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        String ledgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf);
        return new ZkLedgerIdGenerator(this.zk, ledgersRootPath, null, zkAcls);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new FlatLedgerManager(this.conf, this.zk);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        return new ZkLedgerUnderreplicationManager(this.conf, this.zk);
    }

    @Override
    public LedgerAuditorManager newLedgerAuditorManager() {
        ServerConfiguration serverConfiguration = new ServerConfiguration(this.conf);
        return new ZkLedgerAuditorManager(this.zk, serverConfiguration, (StatsLogger)NullStatsLogger.INSTANCE);
    }
}

