/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.exchange;

import com.google.common.base.Preconditions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;

public class PageChannelSelector
implements Function<Page, Page> {
    private final int[] channels;

    public PageChannelSelector(int ... channels) {
        Preconditions.checkArgument((boolean)IntStream.of(channels).allMatch(channel -> channel >= 0), (Object)"channels must be positive");
        this.channels = (int[])Objects.requireNonNull(channels, "channels is null").clone();
    }

    @Override
    public Page apply(Page page) {
        Objects.requireNonNull(page, "page is null");
        Block[] blocks = new Block[this.channels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            int channel = this.channels[i];
            blocks[i] = page.getBlock(channel);
        }
        return new Page(page.getPositionCount(), blocks);
    }
}

