/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.spnego;

import io.airlift.http.client.spnego.ForwardingResponseListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;

public class SpnegoAuthenticationProtocolHandler
extends WWWAuthenticationProtocolHandler {
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();

    public SpnegoAuthenticationProtocolHandler(HttpClient client) {
        super(client);
    }

    public String getName() {
        return "spnego";
    }

    public Response.Listener getResponseListener() {
        return new ForwardingResponseListener(super.getResponseListener()){

            @Override
            public void onComplete(Result result) {
                HttpHeader header = SpnegoAuthenticationProtocolHandler.this.getAuthenticateHeader();
                HttpFields headers = result.getResponse().getHeaders();
                if (headers.getValuesList(header).stream().anyMatch(NEGOTIATE::equalsIgnoreCase)) {
                    headers.put(header, NEGOTIATE + " realm=\"dummy\"");
                }
                super.onComplete(result);
            }
        };
    }
}

