/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class LocalDynamicFilter {
    private static final Logger log = Logger.get(LocalDynamicFilter.class);
    private final Multimap<String, Symbol> probeSymbols;
    private final Map<String, Integer> buildChannels;
    private final TypeProvider types;
    private final SettableFuture<Map<Symbol, Domain>> resultFuture;
    private TupleDomain<String> result;
    private int partitionsLeft;

    public LocalDynamicFilter(Multimap<String, Symbol> probeSymbols, Map<String, Integer> buildChannels, TypeProvider types, int partitionCount) {
        this.probeSymbols = Objects.requireNonNull(probeSymbols, "probeSymbols is null");
        this.buildChannels = Objects.requireNonNull(buildChannels, "buildChannels is null");
        Verify.verify((boolean)probeSymbols.keySet().equals(buildChannels.keySet()), (String)"probeSymbols and buildChannels must have same keys", (Object[])new Object[0]);
        this.types = Objects.requireNonNull(types, "types is null");
        this.resultFuture = SettableFuture.create();
        this.result = TupleDomain.none();
        this.partitionsLeft = partitionCount;
    }

    private synchronized void addPartition(TupleDomain<String> tupleDomain) {
        --this.partitionsLeft;
        Verify.verify((this.partitionsLeft >= 0 ? 1 : 0) != 0);
        this.result = TupleDomain.columnWiseUnion(this.result, tupleDomain, (TupleDomain[])new TupleDomain[0]);
        if (this.partitionsLeft == 0) {
            Verify.verify((boolean)this.resultFuture.set(this.convertTupleDomain(this.result)), (String)"dynamic filter result is provided more than once", (Object[])new Object[0]);
        }
    }

    private Map<Symbol, Domain> convertTupleDomain(TupleDomain<String> result) {
        if (result.isNone()) {
            return (Map)this.buildChannels.keySet().stream().flatMap(filterId -> this.probeSymbols.get(filterId).stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), probeSymbol -> Domain.none((Type)this.types.get((Symbol)probeSymbol))));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)result.getDomains().get()).entrySet()) {
            Domain domain = (Domain)entry.getValue();
            for (Symbol probeSymbol2 : this.probeSymbols.get(entry.getKey())) {
                builder.put((Object)probeSymbol2, (Object)domain);
            }
        }
        return builder.build();
    }

    public static Optional<LocalDynamicFilter> create(JoinNode planNode, TypeProvider types, int partitionCount) {
        Set<String> joinDynamicFilters = planNode.getDynamicFilters().keySet();
        List filterNodes = PlanNodeSearcher.searchFrom(planNode.getLeft()).where(LocalDynamicFilter::isFilterAboveTableScan).findAll();
        ImmutableMultimap.Builder probeSymbolsBuilder = ImmutableMultimap.builder();
        for (FilterNode filterNode : filterNodes) {
            DynamicFilters.ExtractResult extractResult = DynamicFilters.extractDynamicFilters(filterNode.getPredicate());
            for (DynamicFilters.Descriptor descriptor : extractResult.getDynamicConjuncts()) {
                if (!(descriptor.getInput() instanceof SymbolReference) || !joinDynamicFilters.contains(descriptor.getId())) continue;
                Symbol probeSymbol = Symbol.from(descriptor.getInput());
                log.debug("Adding dynamic filter %s: %s", new Object[]{descriptor, probeSymbol});
                probeSymbolsBuilder.put((Object)descriptor.getId(), (Object)probeSymbol);
            }
        }
        ImmutableMultimap probeSymbols = probeSymbolsBuilder.build();
        PlanNode buildNode = planNode.getRight();
        Map buildChannels = (Map)planNode.getDynamicFilters().entrySet().stream().filter(arg_0 -> LocalDynamicFilter.lambda$create$2((Multimap)probeSymbols, arg_0)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Symbol buildSymbol = (Symbol)entry.getValue();
            int buildChannelIndex = buildNode.getOutputSymbols().indexOf(buildSymbol);
            Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
            return buildChannelIndex;
        }));
        if (buildChannels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new LocalDynamicFilter((Multimap<String, Symbol>)probeSymbols, buildChannels, types, partitionCount));
    }

    private static boolean isFilterAboveTableScan(PlanNode node) {
        return node instanceof FilterNode && ((FilterNode)node).getSource() instanceof TableScanNode;
    }

    public Map<String, Integer> getBuildChannels() {
        return this.buildChannels;
    }

    public ListenableFuture<Map<Symbol, Domain>> getResultFuture() {
        return this.resultFuture;
    }

    public Consumer<TupleDomain<String>> getTupleDomainConsumer() {
        return this::addPartition;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("probeSymbols", this.probeSymbols).add("buildChannels", this.buildChannels).add("result", this.result).add("partitionsLeft", this.partitionsLeft).toString();
    }

    private static /* synthetic */ boolean lambda$create$2(Multimap probeSymbols, Map.Entry entry) {
        return probeSymbols.containsKey(entry.getKey());
    }
}

