/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.minmaxby;

import io.prestosql.operator.aggregation.BlockComparator;
import io.prestosql.operator.aggregation.TypedKeyValueHeap;
import io.prestosql.operator.aggregation.minmaxby.MinMaxByNState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;

public class MinMaxByNStateSerializer
implements AccumulatorStateSerializer<MinMaxByNState> {
    private final BlockComparator blockComparator;
    private final Type keyType;
    private final Type valueType;
    private final Type serializedType;

    public MinMaxByNStateSerializer(BlockComparator blockComparator, Type keyType, Type valueType) {
        this.blockComparator = blockComparator;
        this.keyType = keyType;
        this.valueType = valueType;
        this.serializedType = TypedKeyValueHeap.getSerializedType(keyType, valueType);
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(MinMaxByNState state, BlockBuilder out) {
        TypedKeyValueHeap heap = state.getTypedKeyValueHeap();
        if (heap == null) {
            out.appendNull();
            return;
        }
        heap.serialize(out);
    }

    public void deserialize(Block block, int index, MinMaxByNState state) {
        Block currentBlock = (Block)this.serializedType.getObject(block, index);
        state.setTypedKeyValueHeap(TypedKeyValueHeap.deserialize(currentBlock, this.keyType, this.valueType, this.blockComparator));
    }
}

