/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.histogram;

import io.prestosql.operator.aggregation.histogram.GroupedHistogramState;
import io.prestosql.operator.aggregation.histogram.HistogramGroupImplementation;
import io.prestosql.operator.aggregation.histogram.HistogramState;
import io.prestosql.operator.aggregation.histogram.LegacyHistogramGroupState;
import io.prestosql.operator.aggregation.histogram.SingleHistogramState;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.type.Type;

public class HistogramStateFactory
implements AccumulatorStateFactory<HistogramState> {
    private final Type keyType;
    private final int expectedEntriesCount;
    private final HistogramGroupImplementation mode;

    public HistogramStateFactory(Type keyType, int expectedEntriesCount, HistogramGroupImplementation mode) {
        this.keyType = keyType;
        this.expectedEntriesCount = expectedEntriesCount;
        this.mode = mode;
    }

    public HistogramState createSingleState() {
        return new SingleHistogramState(this.keyType, this.expectedEntriesCount);
    }

    public Class<? extends HistogramState> getSingleStateClass() {
        return SingleHistogramState.class;
    }

    public HistogramState createGroupedState() {
        if (this.mode == HistogramGroupImplementation.NEW) {
            return new GroupedHistogramState(this.keyType, this.expectedEntriesCount);
        }
        if (this.mode == HistogramGroupImplementation.LEGACY) {
            return new LegacyHistogramGroupState(this.keyType, this.expectedEntriesCount);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("expected group enum type %s", new Object[]{this.mode}));
    }

    public Class<? extends HistogramState> getGroupedStateClass() {
        if (this.mode == HistogramGroupImplementation.NEW) {
            return GroupedHistogramState.class;
        }
        if (this.mode == HistogramGroupImplementation.LEGACY) {
            return LegacyHistogramGroupState.class;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("expected group enum type %s", new Object[]{this.mode}));
    }
}

