/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Signature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FunctionMetadata {
    private final FunctionId functionId;
    private final Signature signature;
    private final boolean nullable;
    private final List<FunctionArgumentDefinition> argumentDefinitions;
    private final boolean hidden;
    private final boolean deterministic;
    private final String description;
    private final FunctionKind kind;
    private final boolean deprecated;

    public FunctionMetadata(Signature signature, boolean nullable, List<FunctionArgumentDefinition> argumentDefinitions, boolean hidden, boolean deterministic, String description, FunctionKind kind) {
        this(FunctionId.toFunctionId(signature), signature, nullable, argumentDefinitions, hidden, deterministic, description, kind, false);
    }

    public FunctionMetadata(Signature signature, boolean nullable, List<FunctionArgumentDefinition> argumentDefinitions, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this(FunctionId.toFunctionId(signature), signature, nullable, argumentDefinitions, hidden, deterministic, description, kind, deprecated);
    }

    public FunctionMetadata(FunctionId functionId, Signature signature, boolean nullable, List<FunctionArgumentDefinition> argumentDefinitions, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.nullable = nullable;
        this.argumentDefinitions = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentDefinitions, "argumentDefinitions is null"));
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.description = Objects.requireNonNull(description, "description is null");
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.deprecated = deprecated;
    }

    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<FunctionArgumentDefinition> getArgumentDefinitions() {
        return this.argumentDefinitions;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getDescription() {
        return this.description;
    }

    public FunctionKind getKind() {
        return this.kind;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return this.signature.toString();
    }
}

