/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.SubExpressionExtractor;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import io.prestosql.sql.tree.Expression;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DynamicFiltersChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        plan.accept(new PlanVisitor<Set<String>, Void>(){

            @Override
            protected Set<String> visitPlan(PlanNode node, Void context) {
                HashSet<String> consumed = new HashSet<String>();
                for (PlanNode source : node.getSources()) {
                    consumed.addAll((Collection<String>)source.accept(this, context));
                }
                return consumed;
            }

            @Override
            public Set<String> visitOutput(OutputNode node, Void context) {
                Set<String> unmatched = this.visitPlan((PlanNode)node, context);
                Verify.verify((boolean)unmatched.isEmpty(), (String)"All consumed dynamic filters could not be matched with a join.", (Object[])new Object[0]);
                return unmatched;
            }

            @Override
            public Set<String> visitJoin(JoinNode node, Void context) {
                Set<String> currentJoinDynamicFilters = node.getDynamicFilters().keySet();
                Set<String> consumedProbeSide = node.getLeft().accept(this, context);
                Sets.SetView unconsumedByProbeSide = Sets.difference(currentJoinDynamicFilters, consumedProbeSide);
                Verify.verify((boolean)unconsumedByProbeSide.isEmpty(), (String)"Dynamic filters %s present in join were not fully consumed by it's probe side.", (Object)unconsumedByProbeSide);
                Set<String> consumedBuildSide = node.getRight().accept(this, context);
                Sets.SetView unconsumedByBuildSide = Sets.intersection(currentJoinDynamicFilters, consumedBuildSide);
                Verify.verify((boolean)unconsumedByBuildSide.isEmpty(), (String)"Dynamic filters %s present in join were consumed by it's build side.", (Object)unconsumedByBuildSide);
                List nonPushedDownFilters = node.getFilter().map(DynamicFilters::extractDynamicFilters).map(DynamicFilters.ExtractResult::getDynamicConjuncts).orElse((List)ImmutableList.of());
                Verify.verify((boolean)nonPushedDownFilters.isEmpty(), (String)"Dynamic filters %s present in join filter predicate were not pushed down.", (Object)nonPushedDownFilters);
                HashSet<String> unmatched = new HashSet<String>(consumedBuildSide);
                unmatched.addAll(consumedProbeSide);
                unmatched.removeAll(currentJoinDynamicFilters);
                return ImmutableSet.copyOf(unmatched);
            }

            @Override
            public Set<String> visitFilter(FilterNode node, Void context) {
                ImmutableSet.Builder consumed = ImmutableSet.builder();
                DynamicFiltersChecker.extractDynamicPredicates(node.getPredicate()).stream().map(DynamicFilters.Descriptor::getId).forEach(arg_0 -> ((ImmutableSet.Builder)consumed).add(arg_0));
                consumed.addAll((Iterable)node.getSource().accept(this, context));
                return consumed.build();
            }
        }, null);
    }

    private static List<DynamicFilters.Descriptor> extractDynamicPredicates(Expression expression) {
        return (List)SubExpressionExtractor.extract(expression).stream().map(DynamicFilters::getDescriptor).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }
}

