/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SimpleStatsRule;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.matching.Pattern;
import io.prestosql.spi.type.BigintType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.RowNumberNode;
import java.util.Optional;

public class RowNumberStatsRule
extends SimpleStatsRule<RowNumberNode> {
    private static final Pattern<RowNumberNode> PATTERN = Patterns.rowNumber();

    public RowNumberStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<RowNumberNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> doCalculate(RowNumberNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(node.getSource());
        if (sourceStats.isOutputRowCountUnknown()) {
            return Optional.empty();
        }
        double sourceRowsCount = sourceStats.getOutputRowCount();
        double partitionCount = 1.0;
        for (Symbol groupBySymbol : node.getPartitionBy()) {
            SymbolStatsEstimate symbolStatistics = sourceStats.getSymbolStatistics(groupBySymbol);
            boolean nullRow = symbolStatistics.getNullsFraction() != 0.0;
            partitionCount *= symbolStatistics.getDistinctValuesCount() + (double)nullRow;
        }
        if (Double.isNaN(partitionCount = Math.min(sourceRowsCount, partitionCount))) {
            return Optional.empty();
        }
        double rowsPerPartition = sourceRowsCount / partitionCount;
        if (node.getMaxRowCountPerPartition().isPresent()) {
            rowsPerPartition = Math.min(rowsPerPartition, (double)node.getMaxRowCountPerPartition().get().intValue());
        }
        double outputRowsCount = sourceRowsCount;
        if (node.getMaxRowCountPerPartition().isPresent()) {
            outputRowsCount = partitionCount * rowsPerPartition;
        }
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats).setOutputRowCount(outputRowsCount).addSymbolStatistics(node.getRowNumberSymbol(), SymbolStatsEstimate.builder().setLowValue(1.0).setDistinctValuesCount(rowsPerPartition).setNullsFraction(0.0).setAverageRowSize(BigintType.BIGINT.getFixedSize()).build()).build());
    }
}

