/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class BinaryLiteral
extends Literal {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \\r\\n\\t]");
    private static final Pattern NOT_HEX_DIGIT_PATTERN = Pattern.compile(".*[^A-F0-9].*");
    private final Slice value;

    public BinaryLiteral(String value) {
        this(Optional.empty(), value);
    }

    public BinaryLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        String hexString = WHITESPACE_PATTERN.matcher(value).replaceAll("").toUpperCase();
        if (NOT_HEX_DIGIT_PATTERN.matcher(hexString).matches()) {
            throw new ParsingException("Binary literal can only contain hexadecimal digits", location.get());
        }
        if (hexString.length() % 2 != 0) {
            throw new ParsingException("Binary literal must contain an even number of digits", location.get());
        }
        this.value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)hexString));
    }

    public BinaryLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    public String toHexString() {
        return BaseEncoding.base16().encode(this.value.getBytes());
    }

    public Slice getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLiteral that = (BinaryLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

