/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.PolymorphicScalarFunctionBuilder;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class PolymorphicScalarFunction
extends SqlScalarFunction {
    private final List<PolymorphicScalarFunctionChoice> choices;

    PolymorphicScalarFunction(FunctionMetadata functionMetadata, List<PolymorphicScalarFunctionChoice> choices) {
        super(functionMetadata);
        this.choices = Objects.requireNonNull(choices, "choices is null");
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        ImmutableList.Builder implementationChoices = ImmutableList.builder();
        for (PolymorphicScalarFunctionChoice choice : this.choices) {
            implementationChoices.add((Object)this.getScalarFunctionImplementationChoice(boundVariables, metadata, choice));
        }
        return new ScalarFunctionImplementation((List<ScalarFunctionImplementation.ScalarImplementationChoice>)implementationChoices.build());
    }

    private ScalarFunctionImplementation.ScalarImplementationChoice getScalarFunctionImplementationChoice(BoundVariables boundVariables, Metadata metadata, PolymorphicScalarFunctionChoice choice) {
        Signature signature = this.getFunctionMetadata().getSignature();
        List<TypeSignature> resolvedParameterTypeSignatures = SignatureBinder.applyBoundVariables(signature.getArgumentTypes(), boundVariables);
        List resolvedParameterTypes = (List)resolvedParameterTypeSignatures.stream().map(metadata::getType).collect(ImmutableList.toImmutableList());
        TypeSignature resolvedReturnTypeSignature = SignatureBinder.applyBoundVariables(signature.getReturnType(), boundVariables);
        Type resolvedReturnType = metadata.getType(resolvedReturnTypeSignature);
        PolymorphicScalarFunctionBuilder.SpecializeContext context = new PolymorphicScalarFunctionBuilder.SpecializeContext(boundVariables, resolvedParameterTypes, resolvedReturnType);
        Optional<Object> matchingMethod = Optional.empty();
        Optional<Object> matchingMethodsGroup = Optional.empty();
        for (PolymorphicScalarFunctionBuilder.MethodsGroup candidateMethodsGroup : choice.getMethodsGroups()) {
            for (PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes candidateMethod : candidateMethodsGroup.getMethods()) {
                if (!PolymorphicScalarFunction.matchesParameterAndReturnTypes(candidateMethod, resolvedParameterTypes, resolvedReturnType, choice.getArgumentProperties(), choice.isNullableResult())) continue;
                if (matchingMethod.isPresent()) {
                    throw new IllegalStateException("two matching methods (" + ((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod().getName() + " and " + candidateMethod.getMethod().getName() + ") for parameter types " + resolvedParameterTypeSignatures);
                }
                matchingMethod = Optional.of(candidateMethod);
                matchingMethodsGroup = Optional.of(candidateMethodsGroup);
            }
        }
        Preconditions.checkState((boolean)matchingMethod.isPresent(), (String)"no matching method for parameter types %s", (Object)resolvedParameterTypes);
        List<Object> extraParameters = PolymorphicScalarFunction.computeExtraParameters((PolymorphicScalarFunctionBuilder.MethodsGroup)matchingMethodsGroup.get(), context);
        MethodHandle methodHandle = this.applyExtraParameters(((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod(), extraParameters, choice.getArgumentProperties());
        return new ScalarFunctionImplementation.ScalarImplementationChoice(choice.isNullableResult(), choice.getArgumentProperties(), methodHandle, Optional.empty());
    }

    private static boolean matchesParameterAndReturnTypes(PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes methodAndNativeContainerTypes, List<Type> resolvedTypes, Type returnType, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties, boolean nullableResult) {
        Method method = methodAndNativeContainerTypes.getMethod();
        Preconditions.checkState((method.getParameterCount() >= resolvedTypes.size() ? 1 : 0) != 0, (String)"method %s has not enough arguments: %s (should have at least %s)", (Object)method.getName(), (Object)method.getParameterCount(), (Object)resolvedTypes.size());
        Class<?>[] methodParameterJavaTypes = method.getParameterTypes();
        int methodParameterIndex = 0;
        for (int i = 0; i < resolvedTypes.size(); ++i) {
            Class<?> actualType;
            ScalarFunctionImplementation.NullConvention nullConvention = argumentProperties.get(i).getNullConvention();
            Class<?> expectedType = null;
            switch (nullConvention) {
                case RETURN_NULL_ON_NULL: 
                case USE_NULL_FLAG: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), false);
                    break;
                }
                case USE_BOXED_TYPE: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), true);
                    break;
                }
                case BLOCK_AND_POSITION: {
                    Optional<Class<?>> explicitNativeContainerTypes = methodAndNativeContainerTypes.getExplicitNativeContainerTypes().get(i);
                    if (explicitNativeContainerTypes.isPresent()) {
                        expectedType = explicitNativeContainerTypes.get();
                    }
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown NullConvention");
                }
            }
            if (!actualType.equals(expectedType)) {
                return false;
            }
            methodParameterIndex += nullConvention.getParameterCount();
        }
        return method.getReturnType().equals(PolymorphicScalarFunction.getNullAwareContainerType(returnType.getJavaType(), nullableResult));
    }

    private static List<Object> computeExtraParameters(PolymorphicScalarFunctionBuilder.MethodsGroup methodsGroup, PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        return methodsGroup.getExtraParametersFunction().map(function -> (List)function.apply(context)).orElse(Collections.emptyList());
    }

    private static int getNullFlagsCount(List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        return (int)argumentProperties.stream().filter(argumentProperty -> argumentProperty.getNullConvention() == ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG).count();
    }

    private static int getBlockPositionCount(List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        return (int)argumentProperties.stream().filter(argumentProperty -> argumentProperty.getNullConvention() == ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION).count();
    }

    private MethodHandle applyExtraParameters(Method matchingMethod, List<Object> extraParameters, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties) {
        Signature signature = this.getFunctionMetadata().getSignature();
        int expectedArgumentsCount = signature.getArgumentTypes().size() + PolymorphicScalarFunction.getNullFlagsCount(argumentProperties) + PolymorphicScalarFunction.getBlockPositionCount(argumentProperties) + extraParameters.size();
        int matchingMethodArgumentCount = matchingMethod.getParameterCount();
        Preconditions.checkState((matchingMethodArgumentCount == expectedArgumentsCount ? 1 : 0) != 0, (String)"method %s has invalid number of arguments: %s (should have %s)", (Object)matchingMethod.getName(), (Object)matchingMethodArgumentCount, (Object)expectedArgumentsCount);
        MethodHandle matchingMethodHandle = Reflection.methodHandle(matchingMethod);
        matchingMethodHandle = MethodHandles.insertArguments(matchingMethodHandle, matchingMethodArgumentCount - extraParameters.size(), extraParameters.toArray());
        return matchingMethodHandle;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    static final class PolymorphicScalarFunctionChoice {
        private final boolean nullableResult;
        private final List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties;
        private final List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups;

        PolymorphicScalarFunctionChoice(boolean nullableResult, List<ScalarFunctionImplementation.ArgumentProperty> argumentProperties, List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups) {
            this.nullableResult = nullableResult;
            this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
            this.methodsGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(methodsGroups, "methodsWithExtraParametersFunctions is null"));
        }

        boolean isNullableResult() {
            return this.nullableResult;
        }

        List<PolymorphicScalarFunctionBuilder.MethodsGroup> getMethodsGroups() {
            return this.methodsGroups;
        }

        List<ScalarFunctionImplementation.ArgumentProperty> getArgumentProperties() {
            return this.argumentProperties;
        }
    }
}

