/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.ConstraintDeclarationException;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ParameterNameProvider;
import javax.validation.Valid;
import javax.validation.groups.ConvertGroup;
import javax.validation.groups.Default;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.metadata.Scope;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.descriptor.BeanD;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.ComposedD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.ConstructorD;
import org.apache.bval.jsr.descriptor.ContainerElementTypeD;
import org.apache.bval.jsr.descriptor.CrossParameterD;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.descriptor.ExecutableD;
import org.apache.bval.jsr.descriptor.MethodD;
import org.apache.bval.jsr.descriptor.ParameterD;
import org.apache.bval.jsr.descriptor.PropertyD;
import org.apache.bval.jsr.descriptor.ReturnValueD;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.EmptyBuilder;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.AnnotationProxyBuilder;
import org.apache.bval.jsr.util.AnnotationsManager;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
class MetadataReader {
    private static final Predicate<Class<?>> JDK;
    private final ApacheValidatorFactory validatorFactory;
    private final Class<?> beanClass;

    MetadataReader(ApacheValidatorFactory validatorFactory, Class<?> beanClass) {
        this.validatorFactory = Validate.notNull(validatorFactory, "validatorFactory", new Object[0]);
        this.beanClass = Validate.notNull(beanClass, "beanClass", new Object[0]);
    }

    <T> ForBean<T> forBean(MetadataBuilder.ForBean<T> builder) {
        return new ForBean<T>(new Meta.ForClass(this.beanClass), builder);
    }

    private static void __privileged_clinit0() {
        JDK = t -> t.getName().startsWith("java.");
    }

    static {
        MetadataReader.__privileged_clinit0();
    }

    class ForConstructor<T>
    extends ForExecutable<Constructor<? extends T>, ForConstructor<T>> {
        ForConstructor(Meta<Constructor<? extends T>> meta, MetadataBuilder.ForExecutable<Constructor<? extends T>> builder) {
            super(meta, builder);
        }

        @Override
        List<String> getParameterNames(ParameterNameProvider parameterNameProvider, Constructor<? extends T> host) {
            return parameterNameProvider.getParameterNames(host);
        }
    }

    class ForMethod
    extends ForExecutable<Method, ForMethod> {
        ForMethod(Meta<Method> meta, MetadataBuilder.ForExecutable<Method> builder) {
            super(meta, builder);
        }

        @Override
        List<String> getParameterNames(ParameterNameProvider parameterNameProvider, Method host) {
            return parameterNameProvider.getParameterNames(host);
        }
    }

    abstract class ForExecutable<E extends Executable, SELF extends ForExecutable<E, SELF>>
    extends ForElement<E, MetadataBuilder.ForElement<E>> {
        private final MetadataBuilder.ForExecutable<E> executableBuilder;

        ForExecutable(Meta<E> meta, MetadataBuilder.ForExecutable<E> executableBuilder) {
            super(MetadataReader.this, meta, EmptyBuilder.instance().forElement());
            this.executableBuilder = Validate.notNull(executableBuilder, "executableBuilder", new Object[0]);
        }

        <X extends ExecutableD<E, SELF, X>> List<ParameterD<X>> getParameterDescriptors(X parent) {
            Parameter[] parameters = ((Executable)this.meta.getHost()).getParameters();
            List<String> parameterNames = this.getParameterNames(MetadataReader.this.validatorFactory.getParameterNameProvider(), (Executable)this.meta.getHost());
            List<MetadataBuilder.ForContainer<Parameter>> builders = this.executableBuilder.getParameters(this.meta);
            return IntStream.range(0, parameters.length).mapToObj(i -> {
                Meta.ForParameter param = new Meta.ForParameter(parameters[i], (String)parameterNames.get(i));
                MetadataBuilder.ForContainer parameterBuilder = builders.size() > i ? (MetadataBuilder.ForContainer)builders.get(i) : EmptyBuilder.instance().forContainer();
                return new ParameterD<ExecutableD>(param, i, new ForContainer<Parameter>(param, parameterBuilder), parent);
            }).collect(ToUnmodifiable.list());
        }

        <X extends ExecutableD<E, SELF, X>> CrossParameterD<X, E> getCrossParameterDescriptor(X parent) {
            Meta.ForCrossParameter cp = new Meta.ForCrossParameter(this.meta);
            return new CrossParameterD(new ForElement(MetadataReader.this, cp, this.executableBuilder.getCrossParameter(cp)), parent);
        }

        <X extends ExecutableD<E, SELF, X>> ReturnValueD<X, E> getReturnValueDescriptor(X parent) {
            return new ReturnValueD<X, E>(new ForContainer<E>(this.meta, this.executableBuilder.getReturnValue(this.meta)), parent);
        }

        abstract List<String> getParameterNames(ParameterNameProvider var1, E var2);
    }

    class ForContainer<E extends AnnotatedElement>
    extends ForElement<E, MetadataBuilder.ForContainer<E>> {
        ForContainer(Meta<E> meta, MetadataBuilder.ForContainer<E> builder) {
            super(MetadataReader.this, meta, builder);
        }

        boolean isCascaded() {
            return ((MetadataBuilder.ForContainer)this.builder).isCascade(this.meta);
        }

        Set<GroupConversion> getGroupConversions() {
            Set<GroupConversion> groupConversions = ((MetadataBuilder.ForContainer)this.builder).getGroupConversions(this.meta);
            if (!groupConversions.isEmpty()) {
                if (!this.isCascaded()) {
                    Exceptions.raise(ConstraintDeclarationException::new, "@%s declared without @%s on %s", ConvertGroup.class.getSimpleName(), Valid.class.getSimpleName(), this.meta.describeHost());
                }
                if (groupConversions.stream().map(GroupConversion::getFrom).distinct().count() < (long)groupConversions.size()) {
                    Exceptions.raise(ConstraintDeclarationException::new, "%s has duplicate 'from' group conversions", this.meta.describeHost());
                }
                groupConversions.stream().map(GroupConversion::getFrom).forEach(from -> Exceptions.raiseIf(from.isAnnotationPresent(GroupSequence.class), ConstraintDeclarationException::new, "Invalid group conversion declared on %s from group sequence %s", f -> f.args(this.meta.describeHost(), from)));
            }
            return groupConversions;
        }

        Set<ContainerElementTypeD> getContainerElementTypes(CascadableContainerD<?, ?> parent) {
            Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> containerElementTypes = ((MetadataBuilder.ForContainer)this.builder).getContainerElementTypes(this.meta);
            if (containerElementTypes.isEmpty()) {
                return Collections.emptySet();
            }
            TreeSet<ContainerElementTypeD> result = new TreeSet<ContainerElementTypeD>(Comparator.comparing(ContainerElementTypeD::getKey));
            containerElementTypes.forEach((k, builder) -> result.add(new ContainerElementTypeD((ContainerElementKey)k, new ForContainer<AnnotatedType>(new Meta.ForContainerElement(this.meta, (ContainerElementKey)k), (MetadataBuilder.ForContainer<AnnotatedType>)builder), parent)));
            return Collections.unmodifiableSet(result);
        }
    }

    class ForBean<T>
    extends ForElement<Class<T>, MetadataBuilder.ForClass<T>> {
        private final MetadataBuilder.ForBean<T> beanBuilder;

        ForBean(Meta<Class<T>> meta, MetadataBuilder.ForBean<T> builder) {
            super(MetadataReader.this, meta, Validate.notNull(builder, "builder", new Object[0]).getClass(meta));
            this.beanBuilder = builder;
        }

        Map<String, PropertyDescriptor> getProperties(BeanD<T> parent) {
            LinkedHashMap properties = new LinkedHashMap();
            Function<String, List> descriptorList = k -> new ArrayList();
            this.beanBuilder.getFields(this.meta).forEach((f, builder) -> {
                Field fld = Reflection.find((Class)this.meta.getHost(), t -> Reflection.getDeclaredField(t, f));
                ((List)properties.computeIfAbsent(f, descriptorList)).add(new PropertyD.ForField(new ForContainer<Field>(new Meta.ForField(fld), (MetadataBuilder.ForContainer<Field>)builder), (BeanD<?>)parent));
            });
            this.beanBuilder.getGetters(this.meta).forEach((g, builder) -> {
                Method getter = Methods.getter((Class)this.meta.getHost(), g);
                if (getter == null) {
                    Exceptions.raise(IllegalStateException::new, "Getter method for property %s not found", g);
                }
                ((List)properties.computeIfAbsent(g, descriptorList)).add(new PropertyD.ForMethod(new ForContainer<Method>(new Meta.ForMethod(getter), (MetadataBuilder.ForContainer<Method>)builder), (BeanD<?>)parent));
            });
            return properties.entrySet().stream().collect(ToUnmodifiable.map(Map.Entry::getKey, e -> {
                List delegates = (List)e.getValue();
                if (delegates.size() == 1) {
                    return (PropertyDescriptor)delegates.get(0);
                }
                Set constrained = delegates.stream().filter(DescriptorManager::isConstrained).collect(Collectors.toSet());
                if (constrained.isEmpty()) {
                    return (PropertyDescriptor)delegates.get(0);
                }
                if (constrained.size() == 1) {
                    return (PropertyDescriptor)constrained.iterator().next();
                }
                return new ComposedD.ForProperty(delegates);
            }));
        }

        Map<Signature, MethodD> getMethods(BeanD<T> parent) {
            Map<Signature, MetadataBuilder.ForExecutable<Method>> methodBuilders = this.beanBuilder.getMethods(this.meta);
            if (methodBuilders.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap result = new LinkedHashMap();
            methodBuilders.forEach((sig, builder) -> {
                Method m = Reflection.find((Class)this.meta.getHost(), t -> Reflection.getDeclaredMethod(t, sig.getName(), sig.getParameterTypes()));
                MethodD descriptor = new MethodD(new ForMethod(new Meta.ForMethod(m), (MetadataBuilder.ForExecutable<Method>)builder), parent);
                if (DescriptorManager.isConstrained(descriptor)) {
                    result.put(sig, descriptor);
                }
            });
            return Collections.unmodifiableMap(result);
        }

        Map<Signature, ConstructorD<T>> getConstructors(BeanD<T> parent) {
            Map<Signature, MetadataBuilder.ForExecutable<Constructor<T>>> ctorBuilders = this.beanBuilder.getConstructors(this.meta);
            if (ctorBuilders.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap result = new LinkedHashMap();
            ctorBuilders.forEach((sig, builder) -> {
                Constructor c = Reflection.getDeclaredConstructor((Class)this.meta.getHost(), sig.getParameterTypes());
                Meta.ForConstructor metaCtor = new Meta.ForConstructor(c);
                ConstructorD descriptor = new ConstructorD(new ForConstructor(metaCtor, builder), parent);
                if (DescriptorManager.isConstrained(descriptor)) {
                    result.put(sig, descriptor);
                }
            });
            return Collections.unmodifiableMap(result);
        }

        GroupStrategy getGroupStrategy() {
            Class host = (Class)this.meta.getHost();
            if (host.isInterface()) {
                return MetadataReader.this.validatorFactory.getGroupsComputer().computeGroups(host).asStrategy();
            }
            GroupStrategy parentStrategy = Optional.ofNullable(host.getSuperclass()).filter(JDK.negate()).map(MetadataReader.this.validatorFactory.getDescriptorManager()::getBeanDescriptor).map(BeanD.class::cast).map(BeanD::getGroupStrategy).orElse(null);
            List<Class<?>> groupSequence = ((MetadataBuilder.ForClass)this.builder).getGroupSequence(this.meta);
            Set<Group> parentGroups = parentStrategy == null ? null : parentStrategy.getGroups();
            Group localGroup = Group.of(host);
            if (groupSequence == null) {
                HashSet<Group> groups = new HashSet<Group>();
                groups.add(localGroup);
                for (Class<?> t : Reflection.hierarchy(host, Reflection.Interfaces.INCLUDE)) {
                    if (JDK.test(t) || !t.isInterface() || AnnotationsManager.isAnnotationDirectlyPresent(t, GroupSequence.class)) continue;
                    Group g = Group.of(t);
                    if (parentGroups != null && parentGroups.contains(g)) continue;
                    groups.add(g);
                }
                GroupStrategy strategy = GroupStrategy.simple(groups);
                return parentStrategy == null ? strategy : GroupStrategy.composite(strategy, parentStrategy);
            }
            if (groupSequence.contains(Default.class)) {
                Exceptions.raise(GroupDefinitionException::new, "@%s for %s must not contain %s", GroupSequence.class.getSimpleName(), host, Default.class.getName());
            }
            if (!groupSequence.contains(host)) {
                Exceptions.raise(GroupDefinitionException::new, "@%s for %s must contain %<s", GroupSequence.class.getSimpleName(), host);
            }
            Group.Sequence result = Group.sequence(groupSequence.stream().map(Group::of).collect(Collectors.toList()));
            ArrayDeque<Group> expanded = new ArrayDeque<Group>();
            for (Class<?> t : Reflection.hierarchy(host, Reflection.Interfaces.INCLUDE)) {
                if (JDK.test(t) || t.isInterface() && AnnotationsManager.isAnnotationDirectlyPresent(t, GroupSequence.class)) continue;
                expanded.push(Group.of(t));
            }
            if (expanded.size() == 1) {
                return result;
            }
            return result.redefining(Collections.singletonMap(localGroup, GroupStrategy.simple(expanded)));
        }
    }

    static class ForElement<E extends AnnotatedElement, B extends MetadataBuilder.ForElement<E>> {
        final Meta<E> meta;
        protected final B builder;
        final /* synthetic */ MetadataReader this$0;

        ForElement(Meta<E> meta, B builder) {
            this.this$0 = this$0;
            this.meta = Validate.notNull(meta, "meta", new Object[0]);
            this.builder = (MetadataBuilder.ForElement)Validate.notNull(builder, "builder", new Object[0]);
        }

        Set<ConstraintD<?>> getConstraints() {
            return this.builder.getConstraintDeclarationMap(this.meta).entrySet().stream().filter(e -> ((Annotation[])e.getValue()).length > 0).flatMap(e -> {
                Meta m = (Meta)e.getKey();
                Class<?> declaredBy = m.getDeclaringClass();
                Scope scope = declaredBy.equals(this.this$0.beanClass) ? Scope.LOCAL_ELEMENT : Scope.HIERARCHY;
                return Stream.of((Object[])e.getValue()).peek(c -> this.this$0.validatorFactory.getAnnotationsManager().validateConstraintDefinition(c.annotationType())).map(c -> this.rewriteConstraint(c, declaredBy)).map(c -> new ConstraintD<Annotation>((Annotation)c, scope, m, this.this$0.validatorFactory));
            }).collect(ToUnmodifiable.set());
        }

        ApacheValidatorFactory getValidatorFactory() {
            return this.this$0.validatorFactory;
        }

        private <A extends Annotation> A rewriteConstraint(A constraint, Class<?> declaredBy) {
            boolean mustRewrite = false;
            Object[] groups = (Class[])ConstraintAnnotationAttributes.GROUPS.analyze(constraint.annotationType()).read(constraint);
            if (groups.length == 0) {
                mustRewrite = true;
                groups = GroupsComputer.DEFAULT_GROUP;
            }
            if (!declaredBy.equals(this.this$0.beanClass) && !this.this$0.beanClass.isInterface() && ObjectUtils.arrayContains(groups, Default.class) && !ObjectUtils.arrayContains(groups, declaredBy)) {
                mustRewrite = true;
                groups = ObjectUtils.arrayAdd(groups, declaredBy);
            }
            if (mustRewrite) {
                AnnotationProxyBuilder<A> builder = this.this$0.validatorFactory.getAnnotationsManager().buildProxyFor(constraint);
                builder.setGroups((Class<?>[])groups);
                return builder.createAnnotation();
            }
            return constraint;
        }
    }
}

