/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.DoubleRegressionAggregation;
import io.prestosql.operator.aggregation.state.RegressionState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;

@AggregationFunction
public final class RealRegressionAggregation {
    private RealRegressionAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState RegressionState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleRegressionAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState RegressionState state, @AggregationState RegressionState otherState) {
        DoubleRegressionAggregation.combine(state, otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="real")
    public static void regrSlope(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSlope(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="real")
    public static void regrIntercept(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionIntercept(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }
}

