/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Objects;

public class SystemTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final TupleDomain<ColumnHandle> constraint;

    @JsonCreator
    public SystemTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    public static SystemTableHandle fromSchemaTableName(SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        return new SystemTableHandle(tableName.getSchemaName(), tableName.getTableName(), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public String toString() {
        return this.schemaName + "." + this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTableHandle other = (SystemTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }
}

