/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.DynamicClassLoader;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public final class Bootstrap {
    public static final Method BOOTSTRAP_METHOD;

    private Bootstrap() {
    }

    public static CallSite bootstrap(MethodHandles.Lookup callerLookup, String name, MethodType type, long bindingId) {
        ClassLoader classLoader = callerLookup.lookupClass().getClassLoader();
        Preconditions.checkArgument((boolean)(classLoader instanceof DynamicClassLoader), (String)"Expected %s's classloader to be of type %s", (Object)callerLookup.lookupClass().getName(), (Object)DynamicClassLoader.class.getName());
        DynamicClassLoader dynamicClassLoader = (DynamicClassLoader)classLoader;
        MethodHandle target = (MethodHandle)dynamicClassLoader.getCallSiteBindings().get(bindingId);
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (String)"Binding %s for function %s%s not found", (Object)bindingId, (Object)name, type.parameterList());
        return new ConstantCallSite(target);
    }

    static {
        try {
            BOOTSTRAP_METHOD = Bootstrap.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

