/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface ConnectorSplitSource
extends Closeable {
    public CompletableFuture<ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle var1, int var2);

    @Override
    public void close();

    public boolean isFinished();

    default public Optional<Integer> getMinScheduleSplitBatchSize() {
        return Optional.empty();
    }

    public static class ConnectorSplitBatch {
        private final List<ConnectorSplit> splits;
        private final boolean noMoreSplits;

        public ConnectorSplitBatch(List<ConnectorSplit> splits, boolean noMoreSplits) {
            this.splits = Objects.requireNonNull(splits, "splits is null");
            this.noMoreSplits = noMoreSplits;
        }

        public List<ConnectorSplit> getSplits() {
            return this.splits;
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits;
        }
    }
}

