/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.JsonExtract;
import java.util.Objects;

public class JsonPath {
    private final String pattern;
    private final JsonExtract.JsonExtractor<Slice> scalarExtractor;
    private final JsonExtract.JsonExtractor<Slice> objectExtractor;
    private final JsonExtract.JsonExtractor<Long> sizeExtractor;

    public JsonPath(String pattern) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.scalarExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.ScalarValueJsonExtractor());
        this.objectExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.JsonValueJsonExtractor());
        this.sizeExtractor = JsonExtract.generateExtractor(pattern, new JsonExtract.JsonSizeExtractor());
    }

    public String pattern() {
        return this.pattern;
    }

    public JsonExtract.JsonExtractor<Slice> getScalarExtractor() {
        return this.scalarExtractor;
    }

    public JsonExtract.JsonExtractor<Slice> getObjectExtractor() {
        return this.objectExtractor;
    }

    public JsonExtract.JsonExtractor<Long> getSizeExtractor() {
        return this.sizeExtractor;
    }

    public String toString() {
        return this.pattern;
    }
}

