/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.prestosql.execution.StageId;
import io.prestosql.spi.QueryId;
import java.util.List;
import java.util.Objects;

public class TaskId {
    private final String fullId;

    @JsonCreator
    public static TaskId valueOf(String taskId) {
        return new TaskId(taskId);
    }

    public TaskId(String queryId, int stageId, int id) {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
        this.fullId = queryId + "." + stageId + "." + id;
    }

    public TaskId(StageId stageId, int id) {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
        this.fullId = stageId.getQueryId().getId() + "." + stageId.getId() + "." + id;
    }

    public TaskId(String fullId) {
        this.fullId = fullId;
    }

    public QueryId getQueryId() {
        return new QueryId((String)QueryId.parseDottedId((String)this.fullId, (int)3, (String)"taskId").get(0));
    }

    public StageId getStageId() {
        List ids = QueryId.parseDottedId((String)this.fullId, (int)3, (String)"taskId");
        return StageId.valueOf(ids.subList(0, 2));
    }

    public int getId() {
        return Integer.parseInt((String)QueryId.parseDottedId((String)this.fullId, (int)3, (String)"taskId").get(2));
    }

    @JsonValue
    public String toString() {
        return this.fullId;
    }

    public int hashCode() {
        return Objects.hash(this.fullId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskId other = (TaskId)obj;
        return Objects.equals(this.fullId, other.fullId);
    }
}

