/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.operator.TypeSignatureParser;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import java.util.Objects;
import java.util.Set;

public final class TypeImplementationDependency
implements ImplementationDependency {
    private final TypeSignature signature;

    public TypeImplementationDependency(String signature) {
        this.signature = TypeSignatureParser.parseTypeSignature(Objects.requireNonNull(signature, "signature is null"), (Set<String>)ImmutableSet.of());
    }

    public Type resolve(BoundVariables boundVariables, Metadata metadata) {
        return metadata.getType(SignatureBinder.applyBoundVariables(this.signature, boundVariables));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeImplementationDependency that = (TypeImplementationDependency)o;
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }
}

