/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import io.prestosql.execution.Lifespan;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.OperatorInfo;
import io.prestosql.operator.PageBuffer;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorAdapter;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.Optional;

public class BasicWorkProcessorOperatorAdapter
implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
    private final PageBuffer pageBuffer = new PageBuffer();
    private final WorkProcessorOperator operator;

    public static OperatorFactory createAdapterOperatorFactory(BasicAdapterWorkProcessorOperatorFactory operatorFactory) {
        return WorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorFactory));
    }

    private BasicWorkProcessorOperatorAdapter(ProcessorContext processorContext, BasicAdapterWorkProcessorOperatorFactory operatorFactory) {
        this.operator = Objects.requireNonNull(operatorFactory, "operator is null").createAdapterOperator(processorContext, this.pageBuffer.pages());
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public boolean needsInput() {
        return this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.operator.getOutputPages();
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return this.operator.getOperatorInfo();
    }

    @Override
    public void close() throws Exception {
        this.operator.close();
    }

    private static class Factory
    implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory {
        private final BasicAdapterWorkProcessorOperatorFactory operatorFactory;

        Factory(BasicAdapterWorkProcessorOperatorFactory operatorFactory) {
            this.operatorFactory = Objects.requireNonNull(operatorFactory, "operatorFactory is null");
        }

        @Override
        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory duplicate() {
            return new Factory(this.operatorFactory.duplicate());
        }

        @Override
        public int getOperatorId() {
            return this.operatorFactory.getOperatorId();
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.operatorFactory.getPlanNodeId();
        }

        @Override
        public String getOperatorType() {
            return this.operatorFactory.getOperatorType();
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            return this.operatorFactory.create(processorContext, sourcePages);
        }

        @Override
        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext processorContext) {
            return new BasicWorkProcessorOperatorAdapter(processorContext, this.operatorFactory);
        }

        @Override
        public void lifespanFinished(Lifespan lifespan) {
            this.operatorFactory.lifespanFinished(lifespan);
        }

        @Override
        public void close() {
            this.operatorFactory.close();
        }
    }

    public static interface BasicAdapterWorkProcessorOperatorFactory
    extends WorkProcessorOperatorFactory {
        default public WorkProcessorOperator createAdapterOperator(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            return this.create(processorContext, sourcePages);
        }

        public BasicAdapterWorkProcessorOperatorFactory duplicate();
    }
}

