/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.UnexpectedTypeException;
import javax.validation.constraintvalidation.ValidationTarget;
import org.apache.bval.jsr.ConstraintCached;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.job.ComputeConstraintValidatorClass$org_apache_bval_util_reflection_Reflection$$hierarchy$$Ljava_lang_Class$Lorg_apache_bval_util_reflection_Reflection$Interfaces$_ACTION;
import org.apache.bval.jsr.job.ComputeConstraintValidatorClass$org_apache_bval_util_reflection_Reflection$$primitiveToWrapper$$Ljava_lang_Class$_ACTION;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.util.reflection.TypeUtils;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
class ComputeConstraintValidatorClass<A extends Annotation>
implements Supplier<Class<? extends ConstraintValidator<A, ?>>> {
    private static final String CV;
    private static final WildcardType UNBOUNDED;
    private final ConstraintCached constraintsCache;
    private final ConstraintD<?> descriptor;
    private final ValidationTarget validationTarget;
    private final Class<?> validatedType;

    private static Class<?> getValidatedType(Class<? extends ConstraintValidator<?, ?>> validatorType) {
        Type result = TypeUtils.getTypeArguments(validatorType, ConstraintValidator.class).get(ConstraintValidator.class.getTypeParameters()[1]);
        if (!ComputeConstraintValidatorClass.isSupported(result)) {
            Exceptions.raise(ConstraintDefinitionException::new, "Validated type %s declared by %s %s is unsupported", result, CV, validatorType.getName());
        }
        return TypeUtils.getRawType(result, null);
    }

    private static boolean isSupported(Type validatedType) {
        if (validatedType instanceof Class) {
            return true;
        }
        if (validatedType instanceof ParameterizedType) {
            return Stream.of(((ParameterizedType)validatedType).getActualTypeArguments()).allMatch(arg -> TypeUtils.equals(arg, (Type)UNBOUNDED));
        }
        return false;
    }

    ComputeConstraintValidatorClass(ConstraintCached constraintsCache, ConstraintD<A> descriptor, ValidationTarget validationTarget, Class<?> validatedType) {
        this.constraintsCache = Validate.notNull(constraintsCache, "constraintsCache", new Object[0]);
        this.descriptor = Validate.notNull(descriptor, "descriptor", new Object[0]);
        this.validationTarget = Validate.notNull(validationTarget, "validationTarget", new Object[0]);
        this.validatedType = Validate.notNull(validatedType, "validatedType", new Object[0]);
    }

    @Override
    public Class<? extends ConstraintValidator<A, ?>> get() {
        Class<? extends Annotation> constraintType = this.descriptor.getAnnotation().annotationType();
        return this.findValidator(this.constraintsCache.getConstraintValidatorInfo(constraintType));
    }

    private Class<? extends ConstraintValidator<A, ?>> findValidator(Set<ConstraintCached.ConstraintValidatorInfo<A>> infos) {
        switch (this.validationTarget) {
            case PARAMETERS: {
                return this.findCrossParameterValidator(infos);
            }
            case ANNOTATED_ELEMENT: {
                return this.findAnnotatedElementValidator(infos);
            }
        }
        return null;
    }

    private Class<? extends ConstraintValidator<A, ?>> findCrossParameterValidator(Set<ConstraintCached.ConstraintValidatorInfo<A>> infos) {
        Set set = infos.stream().filter(info -> info.getSupportedTargets().contains(ValidationTarget.PARAMETERS)).collect(Collectors.toSet());
        Class<? extends Annotation> constraintType = this.descriptor.getAnnotation().annotationType();
        int size = set.size();
        Exceptions.raiseIf(size > 1 || !this.isComposed() && set.isEmpty(), ConstraintDefinitionException::new, "%d cross-parameter %ss found for constraint type %s", size, CV, constraintType);
        Class result = ((ConstraintCached.ConstraintValidatorInfo)set.iterator().next()).getType();
        if (!TypeUtils.isAssignable(Object[].class, ComputeConstraintValidatorClass.getValidatedType(result))) {
            Exceptions.raise(ConstraintDefinitionException::new, "Cross-parameter %s %s does not support the validation of an object array", CV, result.getName());
        }
        return result;
    }

    private Class<? extends ConstraintValidator<A, ?>> findAnnotatedElementValidator(Set<ConstraintCached.ConstraintValidatorInfo<A>> infos) {
        String cond;
        Map validators = infos.stream().filter(info -> info.getSupportedTargets().contains(ValidationTarget.ANNOTATED_ELEMENT)).map(ConstraintCached.ConstraintValidatorInfo::getType).collect(Collectors.toMap(ComputeConstraintValidatorClass::getValidatedType, Function.identity(), (v1, v2) -> {
            Exceptions.raiseUnless(Objects.equals(v1, v2), UnexpectedTypeException::new, "Detected collision of constraint and target type between %s and %s", v1, v2);
            return v1;
        }));
        HashMap candidates = new HashMap();
        this.walkHierarchy().filter(validators::containsKey).forEach(type -> {
            if (!candidates.keySet().stream().anyMatch(k -> TypeUtils.isAssignable(k, (Type)type))) {
                candidates.put(type, validators.get(type));
            }
        });
        switch (candidates.size()) {
            case 1: {
                Class result = (Class)candidates.values().iterator().next();
                return result;
            }
            case 0: {
                if (this.isComposed()) {
                    return null;
                }
                cond = "No compliant";
                break;
            }
            default: {
                cond = "> 1 maximally specific";
            }
        }
        throw Exceptions.create(UnexpectedTypeException::new, "%s %s %s found for annotated element of type %s", cond, this.descriptor.getAnnotation().annotationType().getName(), CV, TypeUtils.toString(this.validatedType));
    }

    private Stream<Class<?>> walkHierarchy() {
        TypeWrapper w = new TypeWrapper(ComputeConstraintValidatorClass.org_apache_bval_util_reflection_Reflection$$primitiveToWrapper(this.validatedType));
        Stream.Builder hierarchy = Stream.builder();
        ComputeConstraintValidatorClass.org_apache_bval_util_reflection_Reflection$$hierarchy(w.componentType, Reflection.Interfaces.INCLUDE).forEach(hierarchy);
        Stream<Class<?>> result = hierarchy.build().map(w::unwrapArrayComponentType);
        if (this.validatedType.isInterface() || this.validatedType.isArray()) {
            return Stream.concat(result, Stream.of(Object.class));
        }
        return result;
    }

    @Privileged
    private static /* synthetic */ Class<?> org_apache_bval_util_reflection_Reflection$$primitiveToWrapper(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return ComputeConstraintValidatorClass.__privileged_org_apache_bval_util_reflection_Reflection$$primitiveToWrapper(clazz);
        }
        return (Class)AccessController.doPrivileged(new ComputeConstraintValidatorClass$org_apache_bval_util_reflection_Reflection$$primitiveToWrapper$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ Class __privileged_access$0(Class clazz) {
        return ComputeConstraintValidatorClass.__privileged_org_apache_bval_util_reflection_Reflection$$primitiveToWrapper(clazz);
    }

    private static /* synthetic */ Class<?> __privileged_org_apache_bval_util_reflection_Reflection$$primitiveToWrapper(Class<?> clazz) {
        Field[] fieldArray = new Field[1];
        BitSet bitSet = new BitSet(1);
        int n = 0;
        fieldArray[n] = Reflection.class.getDeclaredField("PRIMITIVE_WRAPPER_MAP");
        if (fieldArray[n].isAccessible()) {
            Field cfr_ignored_0 = fieldArray[n];
            bitSet.set(n);
        } else {
            fieldArray[n].setAccessible(true);
        }
        ++n;
        try {
            Class clazz2 = clazz;
            if (clazz != null && clazz.isPrimitive()) {
                clazz2 = (Class)((Map)fieldArray[0].get(null)).get(clazz);
            }
            for (n = 0; n < 1; ++n) {
                if (bitSet.get(n)) continue;
                fieldArray[n].setAccessible(false);
            }
            return clazz2;
        }
        catch (Throwable throwable) {
            for (n = 0; n < 1; ++n) {
                if (bitSet.get(n)) continue;
                fieldArray[n].setAccessible(false);
            }
            throw throwable;
        }
    }

    @Privileged
    private static /* synthetic */ Iterable<Class<?>> org_apache_bval_util_reflection_Reflection$$hierarchy(Class<?> clazz, Reflection.Interfaces interfaces) {
        if (!(System.getSecurityManager() != null)) {
            return ComputeConstraintValidatorClass.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, interfaces);
        }
        return (Iterable)AccessController.doPrivileged(new ComputeConstraintValidatorClass$org_apache_bval_util_reflection_Reflection$$hierarchy$$Ljava_lang_Class$Lorg_apache_bval_util_reflection_Reflection$Interfaces$_ACTION(clazz, interfaces));
    }

    static /* synthetic */ Iterable __privileged_access$1(Class clazz, Reflection.Interfaces interfaces) {
        return ComputeConstraintValidatorClass.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, interfaces);
    }

    private static /* synthetic */ Iterable<Class<?>> __privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(Class<?> clazz, Reflection.Interfaces interfaces) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Reflection.ClassHierarchy classHierarchy = new Reflection.ClassHierarchy(clazz);
        return interfaces == Reflection.Interfaces.INCLUDE ? new Reflection.FullHierarchy(classHierarchy) : classHierarchy;
    }

    private boolean isComposed() {
        return !this.descriptor.getComposingConstraints().isEmpty();
    }

    private static void __privileged_clinit0() {
        CV = ConstraintValidator.class.getSimpleName();
        UNBOUNDED = TypeUtils.wildcardType().build();
    }

    static {
        ComputeConstraintValidatorClass.__privileged_clinit0();
    }

    private static class TypeWrapper {
        final Class<?> componentType;
        final int arrayDepth;

        TypeWrapper(Class<?> type) {
            Class<?> c = type;
            int d = 0;
            while (Object[].class.isAssignableFrom(c)) {
                ++d;
                c = c.getComponentType();
            }
            this.componentType = c;
            this.arrayDepth = d;
        }

        Class<?> unwrapArrayComponentType(Class<?> t) {
            Exceptions.raiseUnless(t.isAssignableFrom(this.componentType), IllegalArgumentException::new, "%s not assignable from %s", t, this.componentType);
            if (this.arrayDepth == 0) {
                return t;
            }
            return Array.newInstance(t, new int[this.arrayDepth]).getClass();
        }
    }
}

