/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.jmx;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigBinder;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;

public class ConnectorObjectNameGeneratorModule
implements Module {
    private final String catalogName;
    private final String packageName;
    private final String defaultDomainBase;

    public ConnectorObjectNameGeneratorModule(String catalogName, String packageName, String defaultDomainBase) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.packageName = Objects.requireNonNull(packageName, "packageName is null");
        this.defaultDomainBase = Objects.requireNonNull(defaultDomainBase, "defaultDomainBase is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(ConnectorObjectNameGeneratorConfig.class);
    }

    @Provides
    ObjectNameGenerator createPrefixObjectNameGenerator(ConnectorObjectNameGeneratorConfig config) {
        String domainBase = (String)MoreObjects.firstNonNull((Object)config.getDomainBase(), (Object)this.defaultDomainBase);
        return new ConnectorObjectNameGenerator(this.packageName, domainBase, this.catalogName);
    }

    public static final class ConnectorObjectNameGenerator
    implements ObjectNameGenerator {
        private final String packageName;
        private final String domainBase;
        private final String catalogName;

        public ConnectorObjectNameGenerator(String packageName, String domainBase, String catalogName) {
            this.packageName = packageName;
            this.domainBase = domainBase;
            this.catalogName = catalogName;
        }

        public String generatedNameOf(Class<?> type) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties((Map)ImmutableMap.builder().put((Object)"type", (Object)type.getSimpleName()).put((Object)"name", (Object)this.catalogName).build()).build();
        }

        public String generatedNameOf(Class<?> type, Map<String, String> properties) {
            return new ObjectNameBuilder(this.toDomain(type)).withProperties((Map)ImmutableMap.builder().putAll(properties).put((Object)"catalog", (Object)this.catalogName).build()).build();
        }

        private String toDomain(Class<?> type) {
            String domain = type.getPackage().getName();
            if (domain.startsWith(this.packageName)) {
                domain = this.domainBase + domain.substring(this.packageName.length());
            }
            return domain;
        }
    }

    public static class ConnectorObjectNameGeneratorConfig {
        private String domainBase;

        public String getDomainBase() {
            return this.domainBase;
        }

        @Config(value="jmx.base-name")
        public ConnectorObjectNameGeneratorConfig setDomainBase(String domainBase) {
            this.domainBase = domainBase;
            return this;
        }
    }
}

