/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.concurrent.atomic.LongAdder;

public class StatsBuckets {
    private final long[] boundaries;
    private final LongAdder sumCounter;
    private final LongAdder[] buckets;
    private final long[] values;
    private long count = 0L;
    private long sum = 0L;

    public StatsBuckets(long ... boundaries) {
        Preconditions.checkArgument((boundaries.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.isSorted(boundaries), (Object)"Boundaries array must be sorted");
        this.boundaries = boundaries;
        this.sumCounter = new LongAdder();
        this.buckets = new LongAdder[boundaries.length + 1];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new LongAdder();
        }
        this.values = new long[this.buckets.length];
    }

    public void addValue(long value) {
        int idx = Arrays.binarySearch(this.boundaries, value);
        if (idx < 0) {
            idx ^= 0xFFFFFFFF;
        }
        this.buckets[idx].increment();
        this.sumCounter.add(value);
    }

    public void refresh() {
        long count = 0L;
        this.sum = this.sumCounter.sumThenReset();
        for (int i = 0; i < this.buckets.length; ++i) {
            long value = this.buckets[i].sumThenReset();
            count += value;
            this.values[i] = value;
        }
        this.count = count;
    }

    public void reset() {
        this.sum = 0L;
        this.sumCounter.reset();
        this.count = 0L;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].reset();
            this.values[i] = 0L;
        }
    }

    public long[] getBuckets() {
        return this.values;
    }

    public long getCount() {
        return this.count;
    }

    public long getSum() {
        return this.sum;
    }

    public double getAvg() {
        return (double)this.sum / (double)this.count;
    }

    public void addAll(StatsBuckets other) {
        Preconditions.checkArgument((this.boundaries.length == other.boundaries.length ? 1 : 0) != 0, (String)"boundaries size %s doesn't match with given boundaries size %s", (int)this.boundaries.length, (int)other.boundaries.length);
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].add(other.values[i]);
        }
        this.sumCounter.add(other.count);
    }

    private boolean isSorted(long[] array) {
        long previous = Long.MIN_VALUE;
        for (long value : array) {
            if (value < previous) {
                return false;
            }
            previous = value;
        }
        return true;
    }
}

