/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.util.concurrent.FastThreadLocal;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.LedgerMetadataUtils;
import org.apache.bookkeeper.mledger.impl.ManagedCursorMXBeanImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.OpFindNewest;
import org.apache.bookkeeper.mledger.impl.OpReadEntry;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.impl.PositionImplRecyclable;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.Errors;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.common.util.collections.ConcurrentOpenLongPairRangeSet;
import org.apache.pulsar.common.util.collections.LongPairRangeSet;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedCursorImpl
implements ManagedCursor {
    protected final BookKeeper bookkeeper;
    protected final ManagedLedgerConfig config;
    protected final ManagedLedgerImpl ledger;
    private final String name;
    private final BookKeeper.DigestType digestType;
    protected volatile PositionImpl markDeletePosition;
    protected volatile PositionImpl persistentMarkDeletePosition;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, PositionImpl> READ_POSITION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, PositionImpl.class, "readPosition");
    protected volatile PositionImpl readPosition;
    protected volatile PositionImpl statsLastReadPosition;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, MarkDeleteEntry> LAST_MARK_DELETE_ENTRY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, MarkDeleteEntry.class, "lastMarkDeleteEntry");
    protected volatile MarkDeleteEntry lastMarkDeleteEntry;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, OpReadEntry> WAITING_READ_OP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, OpReadEntry.class, "waitingReadOp");
    private volatile OpReadEntry waitingReadOp = null;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<ManagedCursorImpl> RESET_CURSOR_IN_PROGRESS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedCursorImpl.class, "resetCursorInProgress");
    private volatile int resetCursorInProgress = 0;
    private static final AtomicIntegerFieldUpdater<ManagedCursorImpl> PENDING_READ_OPS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedCursorImpl.class, "pendingReadOps");
    private volatile int pendingReadOps = 0;
    private static final AtomicLongFieldUpdater<ManagedCursorImpl> MSG_CONSUMED_COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedCursorImpl.class, "messagesConsumedCounter");
    protected volatile long messagesConsumedCounter;
    private volatile LedgerHandle cursorLedger;
    private boolean isCursorLedgerReadOnly = true;
    private volatile Stat cursorLedgerStat;
    private static final LongPairRangeSet.LongPairConsumer<PositionImpl> positionRangeConverter = PositionImpl::new;
    private static final LongPairRangeSet.LongPairConsumer<PositionImplRecyclable> recyclePositionRangeConverter = (key, value) -> {
        PositionImplRecyclable position = PositionImplRecyclable.create();
        position.ledgerId = key;
        position.entryId = value;
        position.ackSet = null;
        return position;
    };
    private final LongPairRangeSet<PositionImpl> individualDeletedMessages;
    private final ConcurrentSkipListMap<PositionImpl, BitSetRecyclable> batchDeletedIndexes;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private RateLimiter markDeleteLimiter;
    private volatile boolean isDirty = false;
    private boolean alwaysInactive = false;
    private static final FastThreadLocal<Long> tempTotalEntriesToSkip = new FastThreadLocal();
    private static final FastThreadLocal<Long> tempDeletedMessages = new FastThreadLocal();
    private static final FastThreadLocal<PositionImpl> tempStartPosition = new FastThreadLocal();
    private static final FastThreadLocal<PositionImpl> tempEndPosition = new FastThreadLocal();
    private static final long NO_MAX_SIZE_LIMIT = -1L;
    private long entriesReadCount;
    private long entriesReadSize;
    private int individualDeletedMessagesSerializedSize;
    private static final String COMPACTION_CURSOR_NAME = "__compaction";
    protected final ArrayDeque<MarkDeleteEntry> pendingMarkDeleteOps = new ArrayDeque();
    private static final AtomicIntegerFieldUpdater<ManagedCursorImpl> PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedCursorImpl.class, "pendingMarkDeletedSubmittedCount");
    private volatile int pendingMarkDeletedSubmittedCount = 0;
    private long lastLedgerSwitchTimestamp;
    private final Clock clock;
    private long lastActive;
    private static final AtomicReferenceFieldUpdater<ManagedCursorImpl, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, State.class, "state");
    protected volatile State state = null;
    protected final ManagedCursorMXBean mbean;
    private static final Logger log = LoggerFactory.getLogger(ManagedCursorImpl.class);

    ManagedCursorImpl(BookKeeper bookkeeper, ManagedLedgerConfig config, ManagedLedgerImpl ledger, String cursorName) {
        this.bookkeeper = bookkeeper;
        this.config = config;
        this.ledger = ledger;
        this.name = cursorName;
        this.individualDeletedMessages = config.isUnackedRangesOpenCacheSetEnabled() ? new ConcurrentOpenLongPairRangeSet(4096, positionRangeConverter) : new LongPairRangeSet.DefaultRangeSet(positionRangeConverter);
        this.batchDeletedIndexes = config.isDeletionAtBatchIndexLevelEnabled() ? new ConcurrentSkipListMap() : null;
        this.digestType = BookKeeper.DigestType.fromApiDigestType((DigestType)config.getDigestType());
        STATE_UPDATER.set(this, State.Uninitialized);
        PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.set(this, 0);
        PENDING_READ_OPS_UPDATER.set(this, 0);
        RESET_CURSOR_IN_PROGRESS_UPDATER.set(this, 0);
        WAITING_READ_OP_UPDATER.set(this, null);
        this.clock = config.getClock();
        this.lastActive = this.clock.millis();
        this.lastLedgerSwitchTimestamp = this.clock.millis();
        this.markDeleteLimiter = config.getThrottleMarkDelete() > 0.0 ? RateLimiter.create((double)config.getThrottleMarkDelete()) : null;
        this.mbean = new ManagedCursorMXBeanImpl(this);
    }

    @Override
    public Map<String, Long> getProperties() {
        return this.lastMarkDeleteEntry != null ? this.lastMarkDeleteEntry.properties : Collections.emptyMap();
    }

    @Override
    public boolean putProperty(String key, Long value) {
        if (this.lastMarkDeleteEntry != null) {
            LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> {
                Map<String, Long> properties = last.properties;
                HashMap newProperties = properties == null ? Maps.newHashMap() : Maps.newHashMap(properties);
                newProperties.put(key, value);
                MarkDeleteEntry newLastMarkDeleteEntry = new MarkDeleteEntry(last.newPosition, newProperties, last.callback, last.ctx);
                newLastMarkDeleteEntry.callbackGroup = last.callbackGroup;
                return newLastMarkDeleteEntry;
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean removeProperty(String key) {
        if (this.lastMarkDeleteEntry != null) {
            LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> {
                Map<String, Long> properties = last.properties;
                if (properties != null && properties.containsKey(key)) {
                    properties.remove(key);
                }
                return last;
            });
            return true;
        }
        return false;
    }

    void recover(final VoidCallback callback) {
        log.info("[{}] Recovering from bookkeeper ledger cursor: {}", (Object)this.ledger.getName(), (Object)this.name);
        this.ledger.getStore().asyncGetCursorInfo(this.ledger.getName(), this.name, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedCursorInfo info, Stat stat) {
                ManagedCursorImpl.this.cursorLedgerStat = stat;
                ManagedCursorImpl.this.lastActive = info.getLastActive() != 0L ? info.getLastActive() : ManagedCursorImpl.this.lastActive;
                if (info.getCursorsLedgerId() == -1L) {
                    PositionImpl recoveredPosition = new PositionImpl(info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId());
                    if (info.getIndividualDeletedMessagesCount() > 0) {
                        ManagedCursorImpl.this.recoverIndividualDeletedMessages(info.getIndividualDeletedMessagesList());
                    }
                    HashMap recoveredProperties = Collections.emptyMap();
                    if (info.getPropertiesCount() > 0) {
                        recoveredProperties = Maps.newHashMap();
                        for (int i = 0; i < info.getPropertiesCount(); ++i) {
                            MLDataFormats.LongProperty property = info.getProperties(i);
                            recoveredProperties.put(property.getName(), property.getValue());
                        }
                    }
                    ManagedCursorImpl.this.recoveredCursor(recoveredPosition, recoveredProperties, null);
                    callback.operationComplete();
                } else {
                    log.info("[{}] Consumer {} meta-data recover from ledger {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, info.getCursorsLedgerId()});
                    ManagedCursorImpl.this.recoverFromLedger(info, callback);
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.operationFailed(e);
            }
        });
    }

    protected void recoverFromLedger(MLDataFormats.ManagedCursorInfo info, VoidCallback callback) {
        this.ledger.mbean.startCursorLedgerOpenOp();
        long ledgerId = info.getCursorsLedgerId();
        AsyncCallback.OpenCallback openCallback = (rc, lh, ctx) -> {
            if (log.isInfoEnabled()) {
                log.info("[{}] Opened ledger {} for consumer {}. rc={}", new Object[]{this.ledger.getName(), ledgerId, this.name, rc});
            }
            if (ManagedCursorImpl.isBkErrorNotRecoverable(rc)) {
                log.error("[{}] Error opening metadata ledger {} for consumer {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc)});
                this.initialize(this.getRollbackPosition(info), Collections.emptyMap(), callback);
                return;
            }
            if (rc != 0) {
                log.warn("[{}] Error opening metadata ledger {} for consumer {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc)});
                callback.operationFailed(new ManagedLedgerException(BKException.getMessage((int)rc)));
                return;
            }
            long lastEntryInLedger = lh.getLastAddConfirmed();
            if (lastEntryInLedger < 0L) {
                log.warn("[{}] Error reading from metadata ledger {} for consumer {}: No entries in ledger", new Object[]{this.ledger.getName(), ledgerId, this.name});
                this.initialize(this.getRollbackPosition(info), Collections.emptyMap(), callback);
                return;
            }
            lh.asyncReadEntries(lastEntryInLedger, lastEntryInLedger, (rc1, lh1, seq, ctx1) -> {
                MLDataFormats.PositionInfo positionInfo;
                if (log.isDebugEnabled()) {
                    log.debug("[{}} readComplete rc={} entryId={}", new Object[]{this.ledger.getName(), rc1, lh1.getLastAddConfirmed()});
                }
                if (ManagedCursorImpl.isBkErrorNotRecoverable(rc1)) {
                    log.error("[{}] Error reading from metadata ledger {} for consumer {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc1)});
                    this.initialize(this.getRollbackPosition(info), Collections.emptyMap(), callback);
                    return;
                }
                if (rc1 != 0) {
                    log.warn("[{}] Error reading from metadata ledger {} for consumer {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc1)});
                    callback.operationFailed(ManagedLedgerImpl.createManagedLedgerException(rc1));
                    return;
                }
                LedgerEntry entry = (LedgerEntry)seq.nextElement();
                this.mbean.addReadCursorLedgerSize(entry.getLength());
                try {
                    positionInfo = MLDataFormats.PositionInfo.parseFrom(entry.getEntry());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(new ManagedLedgerException(e));
                    return;
                }
                HashMap recoveredProperties = Collections.emptyMap();
                if (positionInfo.getPropertiesCount() > 0) {
                    recoveredProperties = Maps.newHashMap();
                    for (int i = 0; i < positionInfo.getPropertiesCount(); ++i) {
                        MLDataFormats.LongProperty property = positionInfo.getProperties(i);
                        recoveredProperties.put(property.getName(), property.getValue());
                    }
                }
                PositionImpl position = new PositionImpl(positionInfo);
                if (positionInfo.getIndividualDeletedMessagesCount() > 0) {
                    this.recoverIndividualDeletedMessages(positionInfo.getIndividualDeletedMessagesList());
                }
                if (this.config.isDeletionAtBatchIndexLevelEnabled() && this.batchDeletedIndexes != null && positionInfo.getBatchedEntryDeletionIndexInfoCount() > 0) {
                    this.recoverBatchDeletedIndexes(positionInfo.getBatchedEntryDeletionIndexInfoList());
                }
                this.recoveredCursor(position, recoveredProperties, lh);
                callback.operationComplete();
            }, null);
        };
        try {
            this.bookkeeper.asyncOpenLedger(ledgerId, this.digestType, this.config.getPassword(), openCallback, null);
        }
        catch (Throwable t) {
            log.error("[{}] Encountered error on opening cursor ledger {} for cursor {}", new Object[]{this.ledger.getName(), ledgerId, this.name, t});
            openCallback.openComplete(-999, null, null);
        }
    }

    private void recoverIndividualDeletedMessages(List<MLDataFormats.MessageRange> individualDeletedMessagesList) {
        this.lock.writeLock().lock();
        try {
            this.individualDeletedMessages.clear();
            individualDeletedMessagesList.forEach(messageRange -> {
                MLDataFormats.NestedPositionInfo lowerEndpoint = messageRange.getLowerEndpoint();
                MLDataFormats.NestedPositionInfo upperEndpoint = messageRange.getUpperEndpoint();
                if (lowerEndpoint.getLedgerId() == upperEndpoint.getLedgerId()) {
                    this.individualDeletedMessages.addOpenClosed(lowerEndpoint.getLedgerId(), lowerEndpoint.getEntryId(), upperEndpoint.getLedgerId(), upperEndpoint.getEntryId());
                } else {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo lowerEndpointLedgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgersInfo().get(lowerEndpoint.getLedgerId());
                    if (lowerEndpointLedgerInfo != null) {
                        this.individualDeletedMessages.addOpenClosed(lowerEndpoint.getLedgerId(), lowerEndpoint.getEntryId(), lowerEndpoint.getLedgerId(), lowerEndpointLedgerInfo.getEntries() - 1L);
                    } else {
                        log.warn("[{}][{}] No ledger info of lower endpoint {}:{}", new Object[]{this.ledger.getName(), this.name, lowerEndpoint.getLedgerId(), lowerEndpoint.getEntryId()});
                    }
                    for (MLDataFormats.ManagedLedgerInfo.LedgerInfo li : this.ledger.getLedgersInfo().subMap(lowerEndpoint.getLedgerId(), false, upperEndpoint.getLedgerId(), false).values()) {
                        this.individualDeletedMessages.addOpenClosed(li.getLedgerId(), -1L, li.getLedgerId(), li.getEntries() - 1L);
                    }
                    this.individualDeletedMessages.addOpenClosed(upperEndpoint.getLedgerId(), -1L, upperEndpoint.getLedgerId(), upperEndpoint.getEntryId());
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void recoverBatchDeletedIndexes(List<MLDataFormats.BatchedEntryDeletionIndexInfo> batchDeletedIndexInfoList) {
        this.lock.writeLock().lock();
        try {
            this.batchDeletedIndexes.clear();
            batchDeletedIndexInfoList.forEach(batchDeletedIndexInfo -> {
                if (batchDeletedIndexInfo.getDeleteSetCount() > 0) {
                    long[] array = new long[batchDeletedIndexInfo.getDeleteSetCount()];
                    for (int i = 0; i < batchDeletedIndexInfo.getDeleteSetList().size(); ++i) {
                        array[i] = batchDeletedIndexInfo.getDeleteSetList().get(i);
                    }
                    this.batchDeletedIndexes.put(PositionImpl.get(batchDeletedIndexInfo.getPosition().getLedgerId(), batchDeletedIndexInfo.getPosition().getEntryId()), BitSetRecyclable.create().resetWords(array));
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void recoveredCursor(PositionImpl position, Map<String, Long> properties, LedgerHandle recoveredFromCursorLedger) {
        if (!this.ledger.ledgerExists(position.getLedgerId())) {
            Long nextExistingLedger = this.ledger.getNextValidLedger(position.getLedgerId());
            if (nextExistingLedger == null) {
                log.info("[{}] [{}] Couldn't find next next valid ledger for recovery {}", new Object[]{this.ledger.getName(), this.name, position});
            }
            PositionImpl positionImpl = position = nextExistingLedger != null ? PositionImpl.get(nextExistingLedger, -1L) : position;
        }
        if (position.compareTo(this.ledger.getLastPosition()) > 0) {
            log.warn("[{}] [{}] Current position {} is ahead of last position {}", new Object[]{this.ledger.getName(), this.name, position, this.ledger.getLastPosition()});
            position = this.ledger.getLastPosition();
        }
        log.info("[{}] Cursor {} recovered to position {}", new Object[]{this.ledger.getName(), this.name, position});
        this.messagesConsumedCounter = -this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)position, (Comparable)this.ledger.getLastPosition()));
        this.markDeletePosition = position;
        this.persistentMarkDeletePosition = position;
        this.readPosition = this.ledger.getNextValidPosition(position);
        this.lastMarkDeleteEntry = new MarkDeleteEntry(this.markDeletePosition, properties, null, null);
        this.cursorLedger = recoveredFromCursorLedger;
        this.isCursorLedgerReadOnly = true;
        STATE_UPDATER.set(this, State.NoLedger);
    }

    void initialize(PositionImpl position, Map<String, Long> properties, final VoidCallback callback) {
        this.recoveredCursor(position, properties, null);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Consumer {} cursor initialized with counters: consumed {} mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
        }
        this.createNewMetadataLedger(new VoidCallback(){

            @Override
            public void operationComplete() {
                STATE_UPDATER.set(ManagedCursorImpl.this, State.Open);
                callback.operationComplete();
            }

            @Override
            public void operationFailed(ManagedLedgerException exception) {
                callback.operationFailed(exception);
            }
        });
    }

    @Override
    public List<Entry> readEntries(int numberOfEntriesToRead) throws InterruptedException, ManagedLedgerException {
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            List<Entry> entries = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncReadEntries(numberOfEntriesToRead, new AsyncCallbacks.ReadEntriesCallback(){
            {
            }

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                result.entries = entries;
                counter.countDown();
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null, PositionImpl.latest);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entries;
    }

    @Override
    public void asyncReadEntries(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        this.asyncReadEntries(numberOfEntriesToRead, -1L, callback, ctx, maxPosition);
    }

    @Override
    public void asyncReadEntries(int numberOfEntriesToRead, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        if (this.isClosed()) {
            callback.readEntriesFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        int numOfEntriesToRead = this.applyMaxSizeCap(numberOfEntriesToRead, maxSizeBytes);
        PENDING_READ_OPS_UPDATER.incrementAndGet(this);
        OpReadEntry op = OpReadEntry.create(this, this.readPosition, numOfEntriesToRead, callback, ctx, maxPosition);
        this.ledger.asyncReadEntries(op);
    }

    @Override
    public Entry getNthEntry(int n, ManagedCursor.IndividualDeletedEntries deletedEntries) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            Entry entry = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncGetNthEntry(n, deletedEntries, new AsyncCallbacks.ReadEntryCallback(){
            {
            }

            @Override
            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }

            @Override
            public void readEntryComplete(Entry entry, Object ctx) {
                result.entry = entry;
                counter.countDown();
            }
        }, null);
        counter.await(this.ledger.getConfig().getMetadataOperationsTimeoutSeconds(), TimeUnit.SECONDS);
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entry;
    }

    @Override
    public void asyncGetNthEntry(int n, ManagedCursor.IndividualDeletedEntries deletedEntries, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        PositionImpl endPosition;
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        if (this.isClosed()) {
            callback.readEntryFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        PositionImpl startPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
        if (startPosition.compareTo(endPosition = this.ledger.getLastPosition()) <= 0) {
            long numOfEntries = this.getNumberOfEntries((Range<PositionImpl>)Range.closed((Comparable)startPosition, (Comparable)endPosition));
            if (numOfEntries >= (long)n) {
                long deletedMessages = 0L;
                if (deletedEntries == ManagedCursor.IndividualDeletedEntries.Exclude) {
                    deletedMessages = this.getNumIndividualDeletedEntriesToSkip(n);
                }
                PositionImpl positionAfterN = this.ledger.getPositionAfterN(this.markDeletePosition, (long)n + deletedMessages, ManagedLedgerImpl.PositionBound.startExcluded);
                this.ledger.asyncReadEntry(positionAfterN, callback, ctx);
            } else {
                callback.readEntryComplete(null, ctx);
            }
        } else {
            callback.readEntryComplete(null, ctx);
        }
    }

    @Override
    public List<Entry> readEntriesOrWait(int numberOfEntriesToRead) throws InterruptedException, ManagedLedgerException {
        return this.readEntriesOrWait(numberOfEntriesToRead, -1L);
    }

    @Override
    public List<Entry> readEntriesOrWait(int numberOfEntriesToRead, long maxSizeBytes) throws InterruptedException, ManagedLedgerException {
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            List<Entry> entries = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncReadEntriesOrWait(numberOfEntriesToRead, maxSizeBytes, new AsyncCallbacks.ReadEntriesCallback(){
            {
            }

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                result.entries = entries;
                counter.countDown();
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null, PositionImpl.latest);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entries;
    }

    @Override
    public void asyncReadEntriesOrWait(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        this.asyncReadEntriesOrWait(numberOfEntriesToRead, -1L, callback, ctx, maxPosition);
    }

    @Override
    public void asyncReadEntriesOrWait(int maxEntries, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        Preconditions.checkArgument((maxEntries > 0 ? 1 : 0) != 0);
        if (this.isClosed()) {
            callback.readEntriesFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        int numberOfEntriesToRead = this.applyMaxSizeCap(maxEntries, maxSizeBytes);
        if (this.hasMoreEntries()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Read entries immediately", (Object)this.ledger.getName(), (Object)this.name);
            }
            this.asyncReadEntries(numberOfEntriesToRead, callback, ctx, maxPosition);
        } else {
            OpReadEntry op = OpReadEntry.create(this, this.readPosition, numberOfEntriesToRead, callback, ctx, maxPosition);
            if (!WAITING_READ_OP_UPDATER.compareAndSet(this, null, op)) {
                callback.readEntriesFailed(new ManagedLedgerException("We can only have a single waiting callback"), ctx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Deferring retry of read at position {}", new Object[]{this.ledger.getName(), this.name, op.readPosition});
            }
            if (this.config.getNewEntriesCheckDelayInMillis() > 0) {
                this.ledger.getScheduledExecutor().schedule(() -> this.checkForNewEntries(op, callback, ctx), (long)this.config.getNewEntriesCheckDelayInMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.checkForNewEntries(op, callback, ctx);
            }
        }
    }

    private void checkForNewEntries(OpReadEntry op, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Re-trying the read at position {}", new Object[]{this.ledger.getName(), this.name, op.readPosition});
            }
            if (!this.hasMoreEntries()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Still no entries available. Register for notification", (Object)this.ledger.getName(), (Object)this.name);
                }
                this.ledger.waitingCursors.add(this);
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Skip notification registering since we do have entries available", (Object)this.ledger.getName(), (Object)this.name);
            }
            if (this.hasMoreEntries()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Found more entries", (Object)this.ledger.getName(), (Object)this.name);
                }
                if (WAITING_READ_OP_UPDATER.compareAndSet(this, op, null)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Cancelled notification and scheduled read at {}", new Object[]{this.ledger.getName(), this.name, op.readPosition});
                    }
                    PENDING_READ_OPS_UPDATER.incrementAndGet(this);
                    this.ledger.asyncReadEntries(op);
                } else if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] notification was already cancelled", (Object)this.ledger.getName(), (Object)this.name);
                }
            } else if (this.ledger.isTerminated()) {
                callback.readEntriesFailed(new ManagedLedgerException.NoMoreEntriesToReadException("Topic was terminated"), ctx);
            }
        }
        catch (Throwable t) {
            callback.readEntriesFailed(new ManagedLedgerException(t), ctx);
        }
    }

    public boolean isClosed() {
        return this.state == State.Closed || this.state == State.Closing;
    }

    @Override
    public boolean cancelPendingReadRequest() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Cancel pending read request", (Object)this.ledger.getName(), (Object)this.name);
        }
        return WAITING_READ_OP_UPDATER.getAndSet(this, null) != null;
    }

    public boolean hasPendingReadRequest() {
        return WAITING_READ_OP_UPDATER.get(this) != null;
    }

    @Override
    public boolean hasMoreEntries() {
        PositionImpl writerPosition = this.ledger.getLastPosition();
        if (writerPosition.getEntryId() != -1L) {
            return this.readPosition.compareTo(writerPosition) <= 0;
        }
        return this.getNumberOfEntries() > 0L;
    }

    @Override
    public long getNumberOfEntries() {
        if (this.readPosition.compareTo(this.ledger.getLastPosition().getNext()) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Read position {} is ahead of last position {}. There are no entries to read", new Object[]{this.ledger.getName(), this.name, this.readPosition, this.ledger.getLastPosition()});
            }
            return 0L;
        }
        return this.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)this.readPosition, (Comparable)this.ledger.getLastPosition().getNext()));
    }

    @Override
    public long getNumberOfEntriesSinceFirstNotAckedMessage() {
        PositionImpl markDeletePosition = this.markDeletePosition;
        PositionImpl readPosition = this.readPosition;
        return markDeletePosition != null && readPosition != null && markDeletePosition.compareTo(readPosition) < 0 ? this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)markDeletePosition, (Comparable)readPosition)) : 0L;
    }

    @Override
    public int getTotalNonContiguousDeletedMessagesRange() {
        return this.individualDeletedMessages.size();
    }

    @Override
    public int getNonContiguousDeletedMessagesRangeSerializedSize() {
        return this.individualDeletedMessagesSerializedSize;
    }

    @Override
    public long getEstimatedSizeSinceMarkDeletePosition() {
        return this.ledger.estimateBacklogFromPosition(this.markDeletePosition);
    }

    @Override
    public long getNumberOfEntriesInBacklog(boolean isPrecise) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Consumer {} cursor ml-entries: {} -- deleted-counter: {} other counters: mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, ManagedLedgerImpl.ENTRIES_ADDED_COUNTER_UPDATER.get(this.ledger), this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
        }
        if (isPrecise) {
            return this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)this.ledger.getLastPosition()));
        }
        long backlog = ManagedLedgerImpl.ENTRIES_ADDED_COUNTER_UPDATER.get(this.ledger) - this.messagesConsumedCounter;
        if (backlog < 0L) {
            backlog = this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)this.ledger.getLastPosition()));
        }
        return backlog;
    }

    public long getNumberOfEntriesInStorage() {
        return this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)this.ledger.getLastPosition().getNext()));
    }

    @Override
    public Position findNewestMatching(Predicate<Entry> condition) throws InterruptedException, ManagedLedgerException {
        return this.findNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, condition);
    }

    @Override
    public Position findNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            Position position = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncFindNewestMatching(constraint, condition, new AsyncCallbacks.FindEntryCallback(){
            {
            }

            @Override
            public void findEntryComplete(Position position, Object ctx) {
                result.position = position;
                counter.countDown();
            }

            @Override
            public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.position;
    }

    @Override
    public void asyncFindNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        PositionImpl startPosition = null;
        long max = 0L;
        switch (constraint) {
            case SearchAllAvailableEntries: {
                startPosition = (PositionImpl)this.getFirstPosition();
                max = this.ledger.getNumberOfEntries() - 1L;
                break;
            }
            case SearchActiveEntries: {
                startPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
                max = this.getNumberOfEntriesInStorage();
                break;
            }
            default: {
                callback.findEntryFailed(new ManagedLedgerException("Unknown position constraint"), Optional.empty(), ctx);
                return;
            }
        }
        if (startPosition == null) {
            callback.findEntryFailed(new ManagedLedgerException("Couldn't find start position"), Optional.empty(), ctx);
            return;
        }
        OpFindNewest op = new OpFindNewest(this, startPosition, condition, max, callback, ctx);
        op.find();
    }

    @Override
    public void setActive() {
        if (!this.alwaysInactive) {
            this.ledger.activateCursor(this);
        }
    }

    @Override
    public boolean isActive() {
        return this.ledger.isCursorActive(this);
    }

    @Override
    public void setInactive() {
        this.ledger.deactivateCursor(this);
    }

    @Override
    public void setAlwaysInactive() {
        this.setInactive();
        this.alwaysInactive = true;
    }

    @Override
    public Position getFirstPosition() {
        Long firstLedgerId = (Long)this.ledger.getLedgersInfo().firstKey();
        return firstLedgerId == null ? null : new PositionImpl(firstLedgerId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalResetCursor(PositionImpl position, AsyncCallbacks.ResetCursorCallback resetCursorCallback) {
        if (position.equals(PositionImpl.earliest)) {
            position = this.ledger.getFirstPosition();
        } else if (position.equals(PositionImpl.latest)) {
            position = this.ledger.getLastPosition().getNext();
        }
        log.info("[{}] Initiate reset position to {} on cursor {}", new Object[]{this.ledger.getName(), position, this.name});
        ArrayDeque<MarkDeleteEntry> arrayDeque = this.pendingMarkDeleteOps;
        synchronized (arrayDeque) {
            if (!RESET_CURSOR_IN_PROGRESS_UPDATER.compareAndSet(this, 0, 1)) {
                log.error("[{}] reset requested - position [{}], previous reset in progress - cursor {}", new Object[]{this.ledger.getName(), position, this.name});
                resetCursorCallback.resetFailed(new ManagedLedgerException.ConcurrentFindCursorPositionException("reset already in progress"), position);
            }
        }
        final AsyncCallbacks.ResetCursorCallback callback = resetCursorCallback;
        final PositionImpl newPosition = position;
        final VoidCallback finalCallback = new VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete() {
                ManagedCursorImpl.this.lock.writeLock().lock();
                try {
                    PositionImpl oldReadPosition;
                    PositionImpl newMarkDeletePosition = ManagedCursorImpl.this.ledger.getPreviousPosition(newPosition);
                    if (ManagedCursorImpl.this.markDeletePosition.compareTo(newMarkDeletePosition) >= 0) {
                        MSG_CONSUMED_COUNTER_UPDATER.addAndGet(ManagedCursorImpl.this.cursorImpl(), -ManagedCursorImpl.this.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)newMarkDeletePosition, (Comparable)ManagedCursorImpl.this.markDeletePosition)));
                    } else {
                        MSG_CONSUMED_COUNTER_UPDATER.addAndGet(ManagedCursorImpl.this.cursorImpl(), ManagedCursorImpl.this.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)ManagedCursorImpl.this.markDeletePosition, (Comparable)newMarkDeletePosition)));
                    }
                    ManagedCursorImpl.this.markDeletePosition = newMarkDeletePosition;
                    ManagedCursorImpl.this.lastMarkDeleteEntry = new MarkDeleteEntry(newMarkDeletePosition, ManagedCursorImpl.this.isCompactionCursor() ? ManagedCursorImpl.this.getProperties() : Collections.emptyMap(), null, null);
                    ManagedCursorImpl.this.individualDeletedMessages.clear();
                    if (ManagedCursorImpl.this.config.isDeletionAtBatchIndexLevelEnabled() && ManagedCursorImpl.this.batchDeletedIndexes != null) {
                        ManagedCursorImpl.this.batchDeletedIndexes.values().forEach(BitSetRecyclable::recycle);
                        ManagedCursorImpl.this.batchDeletedIndexes.clear();
                        long[] resetWords = newPosition.ackSet;
                        if (resetWords != null) {
                            BitSetRecyclable ackSet = BitSetRecyclable.create().resetWords(resetWords);
                            ManagedCursorImpl.this.batchDeletedIndexes.put(newPosition, ackSet);
                        }
                    }
                    if ((oldReadPosition = ManagedCursorImpl.this.readPosition).compareTo(newPosition) >= 0) {
                        log.info("[{}] reset position to {} before current read position {} on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newPosition, oldReadPosition, ManagedCursorImpl.this.name});
                    } else {
                        log.info("[{}] reset position to {} skipping from current read position {} on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newPosition, oldReadPosition, ManagedCursorImpl.this.name});
                    }
                    ManagedCursorImpl.this.readPosition = newPosition;
                }
                finally {
                    ManagedCursorImpl.this.lock.writeLock().unlock();
                }
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    ManagedCursorImpl.this.pendingMarkDeleteOps.clear();
                    if (!RESET_CURSOR_IN_PROGRESS_UPDATER.compareAndSet(ManagedCursorImpl.this, 1, 0)) {
                        log.error("[{}] expected reset position [{}], but another reset in progress on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newPosition, ManagedCursorImpl.this.name});
                    }
                }
                callback.resetComplete(newPosition);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationFailed(ManagedLedgerException exception) {
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    if (!RESET_CURSOR_IN_PROGRESS_UPDATER.compareAndSet(ManagedCursorImpl.this, 1, 0)) {
                        log.error("[{}] expected reset position [{}], but another reset in progress on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newPosition, ManagedCursorImpl.this.name});
                    }
                }
                callback.resetFailed(new ManagedLedgerException.InvalidCursorPositionException("unable to persist position for cursor reset " + newPosition.toString()), newPosition);
            }
        };
        this.internalAsyncMarkDelete(newPosition, this.isCompactionCursor() ? this.getProperties() : Collections.emptyMap(), new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                finalCallback.operationComplete();
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                finalCallback.operationFailed(exception);
            }
        }, null);
    }

    @Override
    public void asyncResetCursor(Position newPos, AsyncCallbacks.ResetCursorCallback callback) {
        Preconditions.checkArgument((boolean)(newPos instanceof PositionImpl));
        PositionImpl newPosition = (PositionImpl)newPos;
        this.ledger.getExecutor().executeOrdered((Object)this.ledger.getName(), (SafeRunnable)SafeRun.safeRun(() -> {
            PositionImpl actualPosition = newPosition;
            if (!(this.ledger.isValidPosition(actualPosition) || actualPosition.equals(PositionImpl.earliest) || actualPosition.equals(PositionImpl.latest) || (actualPosition = this.ledger.getNextValidPosition(actualPosition)) != null)) {
                actualPosition = PositionImpl.latest;
            }
            this.internalResetCursor(actualPosition, callback);
        }));
    }

    @Override
    public void resetCursor(Position newPos) throws ManagedLedgerException, InterruptedException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncResetCursor(newPos, new AsyncCallbacks.ResetCursorCallback(){
            {
            }

            @Override
            public void resetComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void resetFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        });
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            if (result.exception != null) {
                log.warn("[{}] Reset cursor to {} on cursor {} timed out with exception {}", new Object[]{this.ledger.getName(), newPos, this.name, result.exception});
            }
            throw new ManagedLedgerException("Timeout during reset cursor");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public List<Entry> replayEntries(Set<? extends Position> positions) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            List<Entry> entries = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncReplayEntries(positions, new AsyncCallbacks.ReadEntriesCallback(){
            {
            }

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                result.entries = entries;
                counter.countDown();
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entries;
    }

    @Override
    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        return this.asyncReplayEntries(positions, callback, ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions, final AsyncCallbacks.ReadEntriesCallback callback, Object ctx, final boolean sortEntries) {
        final ArrayList entries = Lists.newArrayListWithExpectedSize((int)positions.size());
        if (positions.isEmpty()) {
            callback.readEntriesComplete(entries, ctx);
            return Collections.emptySet();
        }
        HashSet alreadyAcknowledgedPositions = Sets.newHashSet();
        this.lock.readLock().lock();
        try {
            positions.stream().filter(position -> this.individualDeletedMessages.contains(((PositionImpl)position).getLedgerId(), ((PositionImpl)position).getEntryId()) || ((PositionImpl)position).compareTo(this.markDeletePosition) <= 0).forEach(alreadyAcknowledgedPositions::add);
        }
        finally {
            this.lock.readLock().unlock();
        }
        final int totalValidPositions = positions.size() - alreadyAcknowledgedPositions.size();
        final AtomicReference exception = new AtomicReference();
        AsyncCallbacks.ReadEntryCallback cb = new AsyncCallbacks.ReadEntryCallback(){
            int pendingCallbacks;
            {
                this.pendingCallbacks = totalValidPositions;
            }

            @Override
            public synchronized void readEntryComplete(Entry entry, Object ctx) {
                if (exception.get() != null) {
                    entry.release();
                    if (--this.pendingCallbacks == 0) {
                        callback.readEntriesFailed((ManagedLedgerException)exception.get(), ctx);
                    }
                } else {
                    entries.add(entry);
                    if (--this.pendingCallbacks == 0) {
                        if (sortEntries) {
                            entries.sort((e1, e2) -> ComparisonChain.start().compare(e1.getLedgerId(), e2.getLedgerId()).compare(e1.getEntryId(), e2.getEntryId()).result());
                        }
                        callback.readEntriesComplete(entries, ctx);
                    }
                }
            }

            @Override
            public synchronized void readEntryFailed(ManagedLedgerException mle, Object ctx) {
                log.warn("[{}][{}] Error while replaying entries", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, mle});
                if (exception.compareAndSet(null, mle)) {
                    entries.forEach(Entry::release);
                }
                if (--this.pendingCallbacks == 0) {
                    callback.readEntriesFailed((ManagedLedgerException)exception.get(), ctx);
                }
            }
        };
        positions.stream().filter(position -> !alreadyAcknowledgedPositions.contains(position)).forEach(p -> {
            if (((PositionImpl)p).compareTo(this.readPosition) == 0) {
                this.setReadPosition(this.readPosition.getNext());
                log.warn("[{}][{}] replayPosition{} equals readPosition{}, need set next readPositio", new Object[]{this.ledger.getName(), this.name, p, this.readPosition});
            }
            this.ledger.asyncReadEntry((PositionImpl)p, cb, ctx);
        });
        return alreadyAcknowledgedPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNumberOfEntries(Range<PositionImpl> range) {
        long allEntries = this.ledger.getNumberOfEntries(range);
        if (log.isDebugEnabled()) {
            log.debug("[{}] getNumberOfEntries. {} allEntries: {}", new Object[]{this.ledger.getName(), range, allEntries});
        }
        AtomicLong deletedEntries = new AtomicLong(0L);
        this.lock.readLock().lock();
        try {
            this.individualDeletedMessages.forEach(r -> {
                try {
                    if (r.isConnected(range)) {
                        Range commonEntries = r.intersection(range);
                        long commonCount = this.ledger.getNumberOfEntries((Range<PositionImpl>)commonEntries);
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] [{}] Discounting {} entries for already deleted range {}", new Object[]{this.ledger.getName(), this.name, commonCount, commonEntries});
                        }
                        deletedEntries.addAndGet(commonCount);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (r.lowerEndpoint() instanceof PositionImplRecyclable) {
                        ((PositionImplRecyclable)r.lowerEndpoint()).recycle();
                        ((PositionImplRecyclable)r.upperEndpoint()).recycle();
                    }
                }
            }, recyclePositionRangeConverter);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Found {} entries - deleted: {}", new Object[]{this.ledger.getName(), allEntries - deletedEntries.get(), deletedEntries});
        }
        return allEntries - deletedEntries.get();
    }

    @Override
    public void markDelete(Position position) throws InterruptedException, ManagedLedgerException {
        this.markDelete(position, Collections.emptyMap());
    }

    @Override
    public void markDelete(Position position, Map<String, Long> properties) throws InterruptedException, ManagedLedgerException {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((boolean)(position instanceof PositionImpl));
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncMarkDelete(position, properties, new AsyncCallbacks.MarkDeleteCallback(){
            {
            }

            @Override
            public void markDeleteComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during mark-delete operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public void clearBacklog() throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncClearBacklog(new AsyncCallbacks.ClearBacklogCallback(){
            {
            }

            @Override
            public void clearBacklogComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void clearBacklogFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during clear backlog operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public void asyncClearBacklog(final AsyncCallbacks.ClearBacklogCallback callback, Object ctx) {
        this.asyncMarkDelete(this.ledger.getLastPosition(), new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                callback.clearBacklogComplete(ctx);
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                if (exception.getCause() instanceof IllegalArgumentException) {
                    callback.clearBacklogComplete(ctx);
                } else {
                    callback.clearBacklogFailed(exception, ctx);
                }
            }
        }, ctx);
    }

    @Override
    public void skipEntries(int numEntriesToSkip, ManagedCursor.IndividualDeletedEntries deletedEntries) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncSkipEntries(numEntriesToSkip, deletedEntries, new AsyncCallbacks.SkipEntriesCallback(){
            {
            }

            @Override
            public void skipEntriesComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void skipEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during skip messages operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public void asyncSkipEntries(final int numEntriesToSkip, ManagedCursor.IndividualDeletedEntries deletedEntries, final AsyncCallbacks.SkipEntriesCallback callback, Object ctx) {
        log.info("[{}] Skipping {} entries on cursor {}", new Object[]{this.ledger.getName(), numEntriesToSkip, this.name});
        long numDeletedMessages = 0L;
        if (deletedEntries == ManagedCursor.IndividualDeletedEntries.Exclude) {
            numDeletedMessages = this.getNumIndividualDeletedEntriesToSkip(numEntriesToSkip);
        }
        this.asyncMarkDelete(this.ledger.getPositionAfterN(this.markDeletePosition, (long)numEntriesToSkip + numDeletedMessages, ManagedLedgerImpl.PositionBound.startExcluded), new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                callback.skipEntriesComplete(ctx);
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                if (exception.getCause() instanceof IllegalArgumentException) {
                    callback.skipEntriesComplete(ctx);
                } else {
                    log.error("[{}] Skip {} entries failed for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), numEntriesToSkip, ManagedCursorImpl.this.name, exception});
                    callback.skipEntriesFailed(exception, ctx);
                }
            }
        }, ctx);
    }

    long getNumIndividualDeletedEntriesToSkip(long numEntries) {
        tempTotalEntriesToSkip.set((Object)0L);
        tempDeletedMessages.set((Object)0L);
        this.lock.readLock().lock();
        try {
            tempStartPosition.set((Object)this.markDeletePosition);
            tempEndPosition.set(null);
            this.individualDeletedMessages.forEach(r -> {
                try {
                    tempEndPosition.set((Object)r.lowerEndpoint());
                    if (((PositionImpl)tempStartPosition.get()).compareTo((PositionImpl)tempEndPosition.get()) <= 0) {
                        Range range = Range.openClosed((Comparable)((Comparable)tempStartPosition.get()), (Comparable)((Comparable)tempEndPosition.get()));
                        long entries = this.ledger.getNumberOfEntries((Range<PositionImpl>)range);
                        if ((Long)tempTotalEntriesToSkip.get() + entries >= numEntries) {
                            boolean bl = false;
                            return bl;
                        }
                        tempTotalEntriesToSkip.set((Object)((Long)tempTotalEntriesToSkip.get() + entries));
                        tempDeletedMessages.set((Object)((Long)tempDeletedMessages.get() + this.ledger.getNumberOfEntries((Range<PositionImpl>)r)));
                        tempStartPosition.set((Object)r.upperEndpoint());
                    } else if (log.isDebugEnabled()) {
                        log.debug("[{}] deletePosition {} moved ahead without clearing deleteMsgs {} for cursor {}", new Object[]{this.ledger.getName(), this.markDeletePosition, r.lowerEndpoint(), this.name});
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (r.lowerEndpoint() instanceof PositionImplRecyclable) {
                        ((PositionImplRecyclable)r.lowerEndpoint()).recycle();
                        ((PositionImplRecyclable)r.upperEndpoint()).recycle();
                    }
                }
            }, recyclePositionRangeConverter);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return (Long)tempDeletedMessages.get();
    }

    boolean hasMoreEntries(PositionImpl position) {
        PositionImpl lastPositionInLedger = this.ledger.getLastPosition();
        if (position.compareTo(lastPositionInLedger) <= 0) {
            return this.getNumberOfEntries((Range<PositionImpl>)Range.closed((Comparable)position, (Comparable)lastPositionInLedger)) > 0L;
        }
        return false;
    }

    void initializeCursorPosition(Pair<PositionImpl, Long> lastPositionCounter) {
        this.readPosition = this.ledger.getNextValidPosition((PositionImpl)lastPositionCounter.getLeft());
        this.markDeletePosition = (PositionImpl)lastPositionCounter.getLeft();
        this.messagesConsumedCounter = (Long)lastPositionCounter.getRight();
    }

    PositionImpl setAcknowledgedPosition(PositionImpl newMarkDeletePosition) {
        if (newMarkDeletePosition.compareTo(this.markDeletePosition) < 0) {
            throw new IllegalArgumentException("Mark deleting an already mark-deleted position");
        }
        PositionImpl oldMarkDeletePosition = this.markDeletePosition;
        if (!newMarkDeletePosition.equals(oldMarkDeletePosition)) {
            long skippedEntries = 0L;
            skippedEntries = newMarkDeletePosition.getLedgerId() == oldMarkDeletePosition.getLedgerId() && newMarkDeletePosition.getEntryId() == oldMarkDeletePosition.getEntryId() + 1L ? (this.individualDeletedMessages.contains(newMarkDeletePosition.getLedgerId(), newMarkDeletePosition.getEntryId()) ? 0L : 1L) : this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)oldMarkDeletePosition, (Comparable)newMarkDeletePosition));
            PositionImpl positionAfterNewMarkDelete = this.ledger.getNextValidPosition(newMarkDeletePosition);
            while (positionAfterNewMarkDelete.compareTo(this.ledger.lastConfirmedEntry) <= 0 && this.individualDeletedMessages.contains(positionAfterNewMarkDelete.getLedgerId(), positionAfterNewMarkDelete.getEntryId())) {
                Range rangeToBeMarkDeleted = this.individualDeletedMessages.rangeContaining(positionAfterNewMarkDelete.getLedgerId(), positionAfterNewMarkDelete.getEntryId());
                newMarkDeletePosition = (PositionImpl)rangeToBeMarkDeleted.upperEndpoint();
                positionAfterNewMarkDelete = this.ledger.getNextValidPosition(newMarkDeletePosition);
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Moved ack position from: {} to: {} -- skipped: {}", new Object[]{this.ledger.getName(), oldMarkDeletePosition, newMarkDeletePosition, skippedEntries});
            }
            MSG_CONSUMED_COUNTER_UPDATER.addAndGet(this, skippedEntries);
        }
        this.markDeletePosition = newMarkDeletePosition;
        this.individualDeletedMessages.removeAtMost(this.markDeletePosition.getLedgerId(), this.markDeletePosition.getEntryId());
        READ_POSITION_UPDATER.updateAndGet(this, currentReadPosition -> {
            if (currentReadPosition.compareTo(this.markDeletePosition) <= 0) {
                PositionImpl newReadPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Moved read position from: {} to: {}, and new mark-delete position {}", new Object[]{this.ledger.getName(), currentReadPosition, newReadPosition, this.markDeletePosition});
                }
                return newReadPosition;
            }
            return currentReadPosition;
        });
        return newMarkDeletePosition;
    }

    @Override
    public void asyncMarkDelete(Position position, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        this.asyncMarkDelete(position, Collections.emptyMap(), callback, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncMarkDelete(Position position, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((boolean)(position instanceof PositionImpl));
        if (this.isClosed()) {
            callback.markDeleteFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        if (RESET_CURSOR_IN_PROGRESS_UPDATER.get(this) == 1) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] cursor reset in progress - ignoring mark delete on position [{}] for cursor [{}]", new Object[]{this.ledger.getName(), position, this.name});
            }
            callback.markDeleteFailed(new ManagedLedgerException("Reset cursor in progress - unable to mark delete position " + position.toString()), ctx);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Mark delete cursor {} up to position: {}", new Object[]{this.ledger.getName(), this.name, position});
        }
        PositionImpl newPosition = (PositionImpl)position;
        if (this.config.isDeletionAtBatchIndexLevelEnabled() && this.batchDeletedIndexes != null) {
            if (newPosition.ackSet != null) {
                this.batchDeletedIndexes.put(newPosition, BitSetRecyclable.create().resetWords(newPosition.ackSet));
                newPosition = this.ledger.getPreviousPosition(newPosition);
            }
            SortedMap subMap = this.batchDeletedIndexes.subMap((Object)PositionImpl.earliest, (Object)newPosition);
            subMap.values().forEach(BitSetRecyclable::recycle);
            subMap.clear();
        } else if (newPosition.ackSet != null) {
            newPosition = this.ledger.getPreviousPosition(newPosition);
            newPosition.ackSet = null;
        }
        if (((PositionImpl)this.ledger.getLastConfirmedEntry()).compareTo(newPosition) < 0) {
            boolean shouldCursorMoveForward = false;
            try {
                long ledgerEntries = this.ledger.getLedgerInfo(this.markDeletePosition.getLedgerId()).get().getEntries();
                Long nextValidLedger = this.ledger.getNextValidLedger(this.ledger.getLastConfirmedEntry().getLedgerId());
                shouldCursorMoveForward = this.markDeletePosition.getEntryId() + 1L >= ledgerEntries && newPosition.getLedgerId() == nextValidLedger.longValue();
            }
            catch (Exception e) {
                log.warn("Failed to get ledger entries while setting mark-delete-position", (Throwable)e);
            }
            if (shouldCursorMoveForward) {
                log.info("[{}] move mark-delete-position from {} to {} since all the entries have been consumed", new Object[]{this.ledger.getName(), this.markDeletePosition, newPosition});
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed mark delete due to invalid markDelete {} is ahead of last-confirmed-entry {} for cursor [{}]", new Object[]{this.ledger.getName(), position, this.ledger.getLastConfirmedEntry(), this.name});
                }
                callback.markDeleteFailed(new ManagedLedgerException("Invalid mark deleted position"), ctx);
                return;
            }
        }
        this.lock.writeLock().lock();
        try {
            newPosition = this.setAcknowledgedPosition(newPosition);
        }
        catch (IllegalArgumentException e) {
            callback.markDeleteFailed(ManagedLedgerException.getManagedLedgerException(e), ctx);
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.markDeleteLimiter != null && !this.markDeleteLimiter.tryAcquire()) {
            this.isDirty = true;
            this.lastMarkDeleteEntry = new MarkDeleteEntry(newPosition, properties, null, null);
            callback.markDeleteComplete(ctx);
            return;
        }
        this.internalAsyncMarkDelete(newPosition, properties, callback, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalAsyncMarkDelete(PositionImpl newPosition, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        this.ledger.mbean.addMarkDeleteOp();
        MarkDeleteEntry mdEntry = new MarkDeleteEntry(newPosition, properties, callback, ctx);
        ArrayDeque<MarkDeleteEntry> arrayDeque = this.pendingMarkDeleteOps;
        synchronized (arrayDeque) {
            switch (STATE_UPDATER.get(this)) {
                case Closed: {
                    callback.markDeleteFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
                    return;
                }
                case NoLedger: {
                    this.startCreatingNewMetadataLedger();
                }
                case SwitchingLedger: {
                    this.pendingMarkDeleteOps.add(mdEntry);
                    break;
                }
                case Open: {
                    if (PENDING_READ_OPS_UPDATER.get(this) > 0) {
                        this.pendingMarkDeleteOps.add(mdEntry);
                        break;
                    }
                    this.internalMarkDelete(mdEntry);
                    break;
                }
                default: {
                    log.error("[{}][{}] Invalid cursor state: {}", new Object[]{this.ledger.getName(), this.name, this.state});
                    callback.markDeleteFailed(new ManagedLedgerException("Cursor was in invalid state: " + (Object)((Object)this.state)), ctx);
                }
            }
        }
    }

    void internalMarkDelete(final MarkDeleteEntry mdEntry) {
        PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.incrementAndGet(this);
        this.lastMarkDeleteEntry = mdEntry;
        this.persistPositionToLedger(this.cursorLedger, mdEntry, new VoidCallback(){

            @Override
            public void operationComplete() {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Mark delete cursor {} to position {} succeeded", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, mdEntry.newPosition});
                }
                ManagedCursorImpl.this.lock.writeLock().lock();
                try {
                    ManagedCursorImpl.this.individualDeletedMessages.removeAtMost(mdEntry.newPosition.getLedgerId(), mdEntry.newPosition.getEntryId());
                    if (ManagedCursorImpl.this.config.isDeletionAtBatchIndexLevelEnabled() && ManagedCursorImpl.this.batchDeletedIndexes != null) {
                        NavigableMap subMap = ManagedCursorImpl.this.batchDeletedIndexes.subMap(PositionImpl.earliest, false, PositionImpl.get(mdEntry.newPosition.getLedgerId(), mdEntry.newPosition.getEntryId()), true);
                        subMap.values().forEach(BitSetRecyclable::recycle);
                        subMap.clear();
                    }
                    if (ManagedCursorImpl.this.persistentMarkDeletePosition == null || mdEntry.newPosition.compareTo(ManagedCursorImpl.this.persistentMarkDeletePosition) > 0) {
                        ManagedCursorImpl.this.persistentMarkDeletePosition = mdEntry.newPosition;
                    }
                }
                finally {
                    ManagedCursorImpl.this.lock.writeLock().unlock();
                }
                ManagedCursorImpl.this.ledger.updateCursor(ManagedCursorImpl.this, mdEntry.newPosition);
                ManagedCursorImpl.this.decrementPendingMarkDeleteCount();
                if (mdEntry.callbackGroup != null) {
                    for (MarkDeleteEntry e : mdEntry.callbackGroup) {
                        e.callback.markDeleteComplete(e.ctx);
                    }
                } else {
                    mdEntry.callback.markDeleteComplete(mdEntry.ctx);
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException exception) {
                log.warn("[{}] Failed to mark delete position for cursor={} position={}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this, mdEntry.newPosition});
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Consumer {} cursor mark delete failed with counters: consumed {} mdPos {} rdPos {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.messagesConsumedCounter, ManagedCursorImpl.this.markDeletePosition, ManagedCursorImpl.this.readPosition});
                }
                ManagedCursorImpl.this.decrementPendingMarkDeleteCount();
                if (mdEntry.callbackGroup != null) {
                    for (MarkDeleteEntry e : mdEntry.callbackGroup) {
                        e.callback.markDeleteFailed(exception, e.ctx);
                    }
                } else {
                    mdEntry.callback.markDeleteFailed(exception, mdEntry.ctx);
                }
            }
        });
    }

    @Override
    public void delete(Position position) throws InterruptedException, ManagedLedgerException {
        this.delete(Collections.singletonList(position));
    }

    @Override
    public void asyncDelete(Position pos, AsyncCallbacks.DeleteCallback callback, Object ctx) {
        this.asyncDelete(Collections.singletonList(pos), callback, ctx);
    }

    @Override
    public void delete(final Iterable<Position> positions) throws InterruptedException, ManagedLedgerException {
        Preconditions.checkNotNull(positions);
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        final AtomicBoolean timeout = new AtomicBoolean(false);
        this.asyncDelete(positions, new AsyncCallbacks.DeleteCallback(){
            {
            }

            @Override
            public void deleteComplete(Object ctx) {
                if (timeout.get()) {
                    log.warn("[{}] [{}] Delete operation timeout. Callback deleteComplete at position {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, positions});
                }
                counter.countDown();
            }

            @Override
            public void deleteFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                if (timeout.get()) {
                    log.warn("[{}] [{}] Delete operation timeout. Callback deleteFailed at position {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, positions});
                }
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            timeout.set(true);
            log.warn("[{}] [{}] Delete operation timeout. No callback was triggered at position {}", new Object[]{this.ledger.getName(), this.name, positions});
            throw new ManagedLedgerException("Timeout during delete operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDelete(Iterable<Position> positions, final AsyncCallbacks.DeleteCallback callback, Object ctx) {
        if (this.isClosed()) {
            callback.deleteFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        PositionImpl newMarkDeletePosition = null;
        this.lock.writeLock().lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Deleting individual messages at {}. Current status: {} - md-position: {}", new Object[]{this.ledger.getName(), this.name, positions, this.individualDeletedMessages, this.markDeletePosition});
            }
            for (Position pos : positions) {
                BitSetRecyclable bitSetRecyclable;
                PositionImpl position = (PositionImpl)Preconditions.checkNotNull((Object)pos);
                if (((PositionImpl)this.ledger.getLastConfirmedEntry()).compareTo(position) < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Failed mark delete due to invalid markDelete {} is ahead of last-confirmed-entry {} for cursor [{}]", new Object[]{this.ledger.getName(), position, this.ledger.getLastConfirmedEntry(), this.name});
                    }
                    callback.deleteFailed(new ManagedLedgerException("Invalid mark deleted position"), ctx);
                    return;
                }
                if (this.individualDeletedMessages.contains(position.getLedgerId(), position.getEntryId()) || position.compareTo(this.markDeletePosition) <= 0) {
                    if (this.config.isDeletionAtBatchIndexLevelEnabled() && this.batchDeletedIndexes != null && (bitSetRecyclable = this.batchDeletedIndexes.remove(position)) != null) {
                        bitSetRecyclable.recycle();
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("[{}] [{}] Position was already deleted {}", new Object[]{this.ledger.getName(), this.name, position});
                    continue;
                }
                if (position.ackSet == null) {
                    if (this.config.isDeletionAtBatchIndexLevelEnabled() && this.batchDeletedIndexes != null && (bitSetRecyclable = this.batchDeletedIndexes.remove(position)) != null) {
                        bitSetRecyclable.recycle();
                    }
                    PositionImpl previousPosition = this.ledger.getPreviousPosition(position);
                    this.individualDeletedMessages.addOpenClosed(previousPosition.getLedgerId(), previousPosition.getEntryId(), position.getLedgerId(), position.getEntryId());
                    MSG_CONSUMED_COUNTER_UPDATER.incrementAndGet(this);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("[{}] [{}] Individually deleted messages: {}", new Object[]{this.ledger.getName(), this.name, this.individualDeletedMessages});
                    continue;
                }
                if (!this.config.isDeletionAtBatchIndexLevelEnabled() || this.batchDeletedIndexes == null) continue;
                BitSetRecyclable bitSet = this.batchDeletedIndexes.computeIfAbsent(position, v -> BitSetRecyclable.create().resetWords(position.ackSet));
                BitSetRecyclable givenBitSet = BitSetRecyclable.create().resetWords(position.ackSet);
                bitSet.and(givenBitSet);
                givenBitSet.recycle();
                if (!bitSet.isEmpty()) continue;
                PositionImpl previousPosition = this.ledger.getPreviousPosition(position);
                this.individualDeletedMessages.addOpenClosed(previousPosition.getLedgerId(), previousPosition.getEntryId(), position.getLedgerId(), position.getEntryId());
                MSG_CONSUMED_COUNTER_UPDATER.incrementAndGet(this);
                BitSetRecyclable bitSetRecyclable2 = this.batchDeletedIndexes.remove(position);
                if (bitSetRecyclable2 == null) continue;
                bitSetRecyclable2.recycle();
            }
            if (this.individualDeletedMessages.isEmpty()) {
                callback.deleteComplete(ctx);
                return;
            }
            Range range = this.individualDeletedMessages.firstRange();
            if (((PositionImpl)range.lowerEndpoint()).compareTo(this.markDeletePosition) <= 0 || this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)range.lowerEndpoint())) <= 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Found a position range to mark delete for cursor {}: {} ", new Object[]{this.ledger.getName(), this.name, range});
                }
                newMarkDeletePosition = (PositionImpl)range.upperEndpoint();
            }
            newMarkDeletePosition = newMarkDeletePosition != null ? this.setAcknowledgedPosition(newMarkDeletePosition) : this.markDeletePosition;
        }
        catch (Exception e) {
            log.warn("[{}] [{}] Error while updating individualDeletedMessages [{}]", new Object[]{this.ledger.getName(), this.name, e.getMessage(), e});
            callback.deleteFailed(ManagedLedgerException.getManagedLedgerException(e), ctx);
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.markDeleteLimiter != null && !this.markDeleteLimiter.tryAcquire()) {
            this.isDirty = true;
            PositionImpl finalNewMarkDeletePosition = newMarkDeletePosition;
            LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> new MarkDeleteEntry(finalNewMarkDeletePosition, last.properties, null, null));
            callback.deleteComplete(ctx);
            return;
        }
        try {
            Map<String, Long> properties = this.lastMarkDeleteEntry != null ? this.lastMarkDeleteEntry.properties : Collections.emptyMap();
            this.internalAsyncMarkDelete(newMarkDeletePosition, properties, new AsyncCallbacks.MarkDeleteCallback(){

                @Override
                public void markDeleteComplete(Object ctx) {
                    callback.deleteComplete(ctx);
                }

                @Override
                public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                    callback.deleteFailed(exception, ctx);
                }
            }, ctx);
        }
        catch (Exception e) {
            log.warn("[{}] [{}] Error doing asyncDelete [{}]", new Object[]{this.ledger.getName(), this.name, e.getMessage(), e});
            if (log.isDebugEnabled()) {
                log.debug("[{}] Consumer {} cursor asyncDelete error, counters: consumed {} mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
            }
            callback.deleteFailed(new ManagedLedgerException(e), ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Entry> filterReadEntries(List<Entry> entries) {
        this.lock.readLock().lock();
        try {
            Range entriesRange = Range.closed((Comparable)((PositionImpl)entries.get(0).getPosition()), (Comparable)((PositionImpl)entries.get(entries.size() - 1).getPosition()));
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Filtering entries {} - alreadyDeleted: {}", new Object[]{this.ledger.getName(), this.name, entriesRange, this.individualDeletedMessages});
            }
            if (this.individualDeletedMessages.isEmpty() || this.individualDeletedMessages.span() == null || !entriesRange.isConnected(this.individualDeletedMessages.span())) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] No filtering needed for entries {}", new Object[]{this.ledger.getName(), this.name, entriesRange});
                }
                List<Entry> list = entries;
                return list;
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(entries, entry -> {
                boolean includeEntry;
                boolean bl = includeEntry = !this.individualDeletedMessages.contains(((PositionImpl)entry.getPosition()).getLedgerId(), ((PositionImpl)entry.getPosition()).getEntryId());
                if (!includeEntry) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Filtering entry at {} - already deleted", new Object[]{this.ledger.getName(), this.name, entry.getPosition()});
                    }
                    entry.release();
                }
                return includeEntry;
            }));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ledger", (Object)this.ledger.getName()).add("name", (Object)this.name).add("ackPos", (Object)this.markDeletePosition).add("readPos", (Object)this.readPosition).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLastActive() {
        return this.lastActive;
    }

    @Override
    public void updateLastActive() {
        this.lastActive = System.currentTimeMillis();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public Position getReadPosition() {
        return this.readPosition;
    }

    @Override
    public Position getMarkDeletedPosition() {
        return this.markDeletePosition;
    }

    @Override
    public Position getPersistentMarkDeletedPosition() {
        return this.persistentMarkDeletePosition;
    }

    @Override
    public void rewind() {
        this.lock.writeLock().lock();
        try {
            PositionImpl newReadPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
            PositionImpl oldReadPosition = this.readPosition;
            log.info("[{}-{}] Rewind from {} to {}", new Object[]{this.ledger.getName(), this.name, oldReadPosition, newReadPosition});
            this.readPosition = newReadPosition;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(Position newReadPositionInt, boolean force) {
        Preconditions.checkArgument((boolean)(newReadPositionInt instanceof PositionImpl));
        PositionImpl newReadPosition = (PositionImpl)newReadPositionInt;
        this.lock.writeLock().lock();
        try {
            if (!force && newReadPosition.compareTo(this.markDeletePosition) <= 0) {
                newReadPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
            }
            this.readPosition = newReadPosition;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncClose(new AsyncCallbacks.CloseCallback(){
            {
            }

            @Override
            public void closeComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Successfully closed ledger for cursor {}", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)ManagedCursorImpl.this.name);
                }
                latch.countDown();
            }

            @Override
            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Closing ledger failed for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception});
                result.exception = exception;
                latch.countDown();
            }
        }, null);
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during close operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    void persistPositionWhenClosing(PositionImpl position, Map<String, Long> properties, final AsyncCallbacks.CloseCallback callback, final Object ctx) {
        if (this.shouldPersistUnackRangesToLedger()) {
            this.persistPositionToLedger(this.cursorLedger, new MarkDeleteEntry(position, properties, null, null), new VoidCallback(){

                @Override
                public void operationComplete() {
                    log.info("[{}][{}] Updated md-position={} into cursor-ledger {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.markDeletePosition, ManagedCursorImpl.this.cursorLedger.getId()});
                    ManagedCursorImpl.this.cursorLedger.asyncClose((rc, lh, ctx1) -> {
                        callback.closeComplete(ctx);
                        if (rc == 0) {
                            log.info("[{}][{}] Closed cursor-ledger {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.cursorLedger.getId()});
                        } else {
                            log.warn("[{}][{}] Failed to close cursor-ledger {}: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.cursorLedger.getId(), BKException.getMessage((int)rc)});
                        }
                    }, ctx);
                }

                @Override
                public void operationFailed(ManagedLedgerException e) {
                    log.warn("[{}][{}] Failed to persist mark-delete position into cursor-ledger{}: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.cursorLedger.getId(), e.getMessage()});
                    callback.closeFailed(e, ctx);
                }
            });
        } else {
            this.persistPositionMetaStore(-1L, position, properties, new MetaStore.MetaStoreCallback<Void>(){

                @Override
                public void operationComplete(Void result, Stat stat) {
                    log.info("[{}][{}] Closed cursor at md-position={}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.markDeletePosition});
                    callback.closeComplete(ctx);
                    ManagedCursorImpl.this.asyncDeleteLedger(ManagedCursorImpl.this.cursorLedger);
                }

                @Override
                public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                    log.warn("[{}][{}] Failed to update cursor info when closing: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, e.getMessage()});
                    callback.closeFailed(e, ctx);
                }
            }, true);
        }
    }

    private boolean shouldPersistUnackRangesToLedger() {
        return this.cursorLedger != null && !this.isCursorLedgerReadOnly && this.config.getMaxUnackedRangesToPersist() > 0 && this.individualDeletedMessages.size() > this.config.getMaxUnackedRangesToPersistInZk();
    }

    private void persistPositionMetaStore(long cursorsLedgerId, PositionImpl position, Map<String, Long> properties, final MetaStore.MetaStoreCallback<Void> callback, boolean persistIndividualDeletedMessageRanges) {
        if (this.state == State.Closed) {
            this.ledger.getExecutor().execute((Runnable)SafeRun.safeRun(() -> callback.operationFailed(new ManagedLedgerException.MetaStoreException(new ManagedLedgerException.CursorAlreadyClosedException(this.name + " cursor already closed")))));
            return;
        }
        MLDataFormats.ManagedCursorInfo.Builder info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(cursorsLedgerId).setMarkDeleteLedgerId(position.getLedgerId()).setMarkDeleteEntryId(position.getEntryId()).setLastActive(this.lastActive);
        info.addAllProperties(this.buildPropertiesMap(properties));
        if (persistIndividualDeletedMessageRanges) {
            info.addAllIndividualDeletedMessages(this.buildIndividualDeletedMessageRanges());
            if (this.config.isDeletionAtBatchIndexLevelEnabled()) {
                info.addAllBatchedEntryDeletionIndexInfo(this.buildBatchEntryDeletionIndexInfoList());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}]  Closing cursor at md-position: {}", new Object[]{this.ledger.getName(), this.name, position});
        }
        this.ledger.getStore().asyncUpdateCursorInfo(this.ledger.getName(), this.name, info.build(), this.cursorLedgerStat, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                ManagedCursorImpl.this.cursorLedgerStat = stat;
                callback.operationComplete(result, stat);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                if (e instanceof ManagedLedgerException.BadVersionException) {
                    log.warn("[{}] Failed to update cursor metadata for {} due to version conflict {}", new Object[]{ManagedCursorImpl.this.ledger.name, ManagedCursorImpl.this.name, e.getMessage()});
                    if (ManagedCursorImpl.this.ledger.mlOwnershipChecker != null && ManagedCursorImpl.this.ledger.mlOwnershipChecker.get().booleanValue()) {
                        ManagedCursorImpl.this.ledger.getStore().asyncGetCursorInfo(ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

                            @Override
                            public void operationComplete(MLDataFormats.ManagedCursorInfo info, Stat stat) {
                                ManagedCursorImpl.this.cursorLedgerStat = stat;
                            }

                            @Override
                            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                                if (log.isDebugEnabled()) {
                                    log.debug("[{}] Failed to refresh cursor metadata-version for {} due to {}", new Object[]{ManagedCursorImpl.this.ledger.name, ManagedCursorImpl.this.name, e.getMessage()});
                                }
                            }
                        });
                    }
                }
                callback.operationFailed(e);
            }
        });
    }

    @Override
    public void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        State oldState = STATE_UPDATER.getAndSet(this, State.Closing);
        if (oldState == State.Closed || oldState == State.Closing) {
            log.info("[{}] [{}] State is already closed", (Object)this.ledger.getName(), (Object)this.name);
            callback.closeComplete(ctx);
            return;
        }
        this.persistPositionWhenClosing(this.lastMarkDeleteEntry.newPosition, this.lastMarkDeleteEntry.properties, callback, ctx);
        STATE_UPDATER.set(this, State.Closed);
    }

    void setReadPosition(Position newReadPositionInt) {
        Preconditions.checkArgument((boolean)(newReadPositionInt instanceof PositionImpl));
        if (this.markDeletePosition == null || ((PositionImpl)newReadPositionInt).compareTo(this.markDeletePosition) > 0) {
            this.readPosition = (PositionImpl)newReadPositionInt;
        }
    }

    void startCreatingNewMetadataLedger() {
        State oldState = STATE_UPDATER.getAndSet(this, State.SwitchingLedger);
        if (oldState == State.SwitchingLedger) {
            return;
        }
        if (PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.get(this) == 0) {
            this.createNewMetadataLedger();
        }
    }

    void createNewMetadataLedger() {
        this.createNewMetadataLedger(new VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete() {
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    ManagedCursorImpl.this.flushPendingMarkDeletes();
                    STATE_UPDATER.set(ManagedCursorImpl.this, State.Open);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationFailed(ManagedLedgerException exception) {
                log.error("[{}][{}] Metadata ledger creation failed", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception});
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    while (!ManagedCursorImpl.this.pendingMarkDeleteOps.isEmpty()) {
                        MarkDeleteEntry entry = ManagedCursorImpl.this.pendingMarkDeleteOps.poll();
                        entry.callback.markDeleteFailed(exception, entry.ctx);
                    }
                    STATE_UPDATER.set(ManagedCursorImpl.this, State.NoLedger);
                }
            }
        });
    }

    private void flushPendingMarkDeletes() {
        if (!this.pendingMarkDeleteOps.isEmpty()) {
            this.internalFlushPendingMarkDeletes();
        }
    }

    void internalFlushPendingMarkDeletes() {
        MarkDeleteEntry lastEntry = this.pendingMarkDeleteOps.getLast();
        lastEntry.callbackGroup = Lists.newArrayList(this.pendingMarkDeleteOps);
        this.pendingMarkDeleteOps.clear();
        this.internalMarkDelete(lastEntry);
    }

    void createNewMetadataLedger(final VoidCallback callback) {
        this.ledger.mbean.startCursorLedgerCreateOp();
        this.ledger.asyncCreateLedger(this.bookkeeper, this.config, this.digestType, (rc, lh, ctx) -> {
            if (this.ledger.checkAndCompleteLedgerOpTask(rc, lh, ctx)) {
                return;
            }
            this.ledger.getExecutor().execute((Runnable)SafeRun.safeRun(() -> {
                this.ledger.mbean.endCursorLedgerCreateOp();
                if (rc != 0) {
                    log.warn("[{}] Error creating ledger for cursor {}: {}", new Object[]{this.ledger.getName(), this.name, BKException.getMessage((int)rc)});
                    callback.operationFailed(new ManagedLedgerException(BKException.getMessage((int)rc)));
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Created ledger {} for cursor {}", new Object[]{this.ledger.getName(), lh.getId(), this.name});
                }
                final MarkDeleteEntry mdEntry = this.lastMarkDeleteEntry;
                this.persistPositionToLedger(lh, mdEntry, new VoidCallback(){

                    @Override
                    public void operationComplete() {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Persisted position {} for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), mdEntry.newPosition, ManagedCursorImpl.this.name});
                        }
                        ManagedCursorImpl.this.switchToNewLedger(lh, new VoidCallback(){

                            @Override
                            public void operationComplete() {
                                callback.operationComplete();
                            }

                            @Override
                            public void operationFailed(ManagedLedgerException exception) {
                                ManagedCursorImpl.this.bookkeeper.asyncDeleteLedger(lh.getId(), (rc, ctx) -> {
                                    if (rc != 0) {
                                        log.warn("[{}] Failed to delete orphan ledger {}", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)lh.getId());
                                    }
                                }, null);
                                callback.operationFailed(exception);
                            }
                        });
                    }

                    @Override
                    public void operationFailed(ManagedLedgerException exception) {
                        log.warn("[{}] Failed to persist position {} for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), mdEntry.newPosition, ManagedCursorImpl.this.name});
                        ManagedCursorImpl.this.ledger.mbean.startCursorLedgerDeleteOp();
                        ManagedCursorImpl.this.bookkeeper.asyncDeleteLedger(lh.getId(), new AsyncCallback.DeleteCallback(){

                            public void deleteComplete(int rc, Object ctx) {
                                ManagedCursorImpl.this.ledger.mbean.endCursorLedgerDeleteOp();
                            }
                        }, null);
                        callback.operationFailed(exception);
                    }
                });
            }));
        }, LedgerMetadataUtils.buildAdditionalMetadataForCursor(this.name));
    }

    private List<MLDataFormats.LongProperty> buildPropertiesMap(Map<String, Long> properties) {
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList longProperties = Lists.newArrayList();
        properties.forEach((name, value) -> {
            MLDataFormats.LongProperty lp = MLDataFormats.LongProperty.newBuilder().setName((String)name).setValue((long)value).build();
            longProperties.add(lp);
        });
        return longProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MLDataFormats.MessageRange> buildIndividualDeletedMessageRanges() {
        this.lock.readLock().lock();
        try {
            if (this.individualDeletedMessages.isEmpty()) {
                List<MLDataFormats.MessageRange> list = Collections.emptyList();
                return list;
            }
            MLDataFormats.NestedPositionInfo.Builder nestedPositionBuilder = MLDataFormats.NestedPositionInfo.newBuilder();
            MLDataFormats.MessageRange.Builder messageRangeBuilder = MLDataFormats.MessageRange.newBuilder();
            AtomicInteger acksSerializedSize = new AtomicInteger(0);
            ArrayList rangeList = Lists.newArrayList();
            this.individualDeletedMessages.forEach(positionRange -> {
                PositionImpl p = (PositionImpl)positionRange.lowerEndpoint();
                nestedPositionBuilder.setLedgerId(p.getLedgerId());
                nestedPositionBuilder.setEntryId(p.getEntryId());
                messageRangeBuilder.setLowerEndpoint(nestedPositionBuilder.build());
                p = (PositionImpl)positionRange.upperEndpoint();
                nestedPositionBuilder.setLedgerId(p.getLedgerId());
                nestedPositionBuilder.setEntryId(p.getEntryId());
                messageRangeBuilder.setUpperEndpoint(nestedPositionBuilder.build());
                MLDataFormats.MessageRange messageRange = messageRangeBuilder.build();
                acksSerializedSize.addAndGet(messageRange.getSerializedSize());
                rangeList.add(messageRange);
                return rangeList.size() <= this.config.getMaxUnackedRangesToPersist();
            });
            this.individualDeletedMessagesSerializedSize = acksSerializedSize.get();
            ArrayList arrayList = rangeList;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MLDataFormats.BatchedEntryDeletionIndexInfo> buildBatchEntryDeletionIndexInfoList() {
        this.lock.readLock().lock();
        try {
            if (!this.config.isDeletionAtBatchIndexLevelEnabled() || this.batchDeletedIndexes == null || this.batchDeletedIndexes.isEmpty()) {
                List<MLDataFormats.BatchedEntryDeletionIndexInfo> list = Collections.emptyList();
                return list;
            }
            MLDataFormats.NestedPositionInfo.Builder nestedPositionBuilder = MLDataFormats.NestedPositionInfo.newBuilder();
            MLDataFormats.BatchedEntryDeletionIndexInfo.Builder batchDeletedIndexInfoBuilder = MLDataFormats.BatchedEntryDeletionIndexInfo.newBuilder();
            ArrayList result = Lists.newArrayList();
            Iterator<Map.Entry<PositionImpl, BitSetRecyclable>> iterator = this.batchDeletedIndexes.entrySet().iterator();
            while (iterator.hasNext() && result.size() < this.config.getMaxBatchDeletedIndexToPersist()) {
                Map.Entry<PositionImpl, BitSetRecyclable> entry = iterator.next();
                nestedPositionBuilder.setLedgerId(entry.getKey().getLedgerId());
                nestedPositionBuilder.setEntryId(entry.getKey().getEntryId());
                batchDeletedIndexInfoBuilder.setPosition(nestedPositionBuilder.build());
                long[] array = entry.getValue().toLongArray();
                ArrayList<Long> deleteSet = new ArrayList<Long>(array.length);
                for (long l : array) {
                    deleteSet.add(l);
                }
                batchDeletedIndexInfoBuilder.clearDeleteSet();
                batchDeletedIndexInfoBuilder.addAllDeleteSet(deleteSet);
                result.add(batchDeletedIndexInfoBuilder.build());
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void persistPositionToLedger(LedgerHandle lh, MarkDeleteEntry mdEntry, final VoidCallback callback) {
        final PositionImpl position = mdEntry.newPosition;
        MLDataFormats.PositionInfo pi = MLDataFormats.PositionInfo.newBuilder().setLedgerId(position.getLedgerId()).setEntryId(position.getEntryId()).addAllIndividualDeletedMessages(this.buildIndividualDeletedMessageRanges()).addAllBatchedEntryDeletionIndexInfo(this.buildBatchEntryDeletionIndexInfoList()).addAllProperties(this.buildPropertiesMap(mdEntry.properties)).build();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Cursor {} Appending to ledger={} position={}", new Object[]{this.ledger.getName(), this.name, lh.getId(), position});
        }
        Preconditions.checkNotNull((Object)lh);
        byte[] data = pi.toByteArray();
        lh.asyncAddEntry(data, (rc, lh1, entryId, ctx) -> {
            if (rc == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Updated cursor {} position {} in meta-ledger {}", new Object[]{this.ledger.getName(), this.name, position, lh1.getId()});
                }
                if (this.shouldCloseLedger(lh1)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Need to create new metadata ledger for consumer {}", (Object)this.ledger.getName(), (Object)this.name);
                    }
                    this.startCreatingNewMetadataLedger();
                }
                this.mbean.persistToLedger(true);
                this.mbean.addWriteCursorLedgerSize(data.length);
                callback.operationComplete();
            } else {
                log.warn("[{}] Error updating cursor {} position {} in meta-ledger {}: {}", new Object[]{this.ledger.getName(), this.name, position, lh1.getId(), BKException.getMessage((int)rc)});
                STATE_UPDATER.compareAndSet(this, State.Open, State.NoLedger);
                this.mbean.persistToLedger(false);
                this.persistPositionMetaStore(-1L, position, mdEntry.properties, new MetaStore.MetaStoreCallback<Void>(){

                    @Override
                    public void operationComplete(Void result, Stat stat) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}][{}] Updated cursor in meta store after previous failure in ledger at position {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, position});
                        }
                        ManagedCursorImpl.this.mbean.persistToZookeeper(true);
                        callback.operationComplete();
                    }

                    @Override
                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        log.warn("[{}][{}] Failed to update cursor in meta store after previous failure in ledger: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, e.getMessage()});
                        ManagedCursorImpl.this.mbean.persistToZookeeper(false);
                        callback.operationFailed(ManagedLedgerImpl.createManagedLedgerException(rc));
                    }
                }, true);
            }
        }, null);
    }

    boolean shouldCloseLedger(LedgerHandle lh) {
        long now = this.clock.millis();
        if ((lh.getLastAddConfirmed() >= (long)this.config.getMetadataMaxEntriesPerLedger() || this.lastLedgerSwitchTimestamp < now - (long)(this.config.getLedgerRolloverTimeout() * 1000)) && STATE_UPDATER.get(this) != State.Closed && STATE_UPDATER.get(this) != State.Closing) {
            this.lastLedgerSwitchTimestamp = now;
            return true;
        }
        return false;
    }

    void switchToNewLedger(final LedgerHandle lh, final VoidCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Switching cursor {} to ledger {}", new Object[]{this.ledger.getName(), this.name, lh.getId()});
        }
        this.persistPositionMetaStore(lh.getId(), this.lastMarkDeleteEntry.newPosition, this.lastMarkDeleteEntry.properties, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                log.info("[{}] Updated cursor {} with ledger id {} md-position={} rd-position={}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, lh.getId(), ManagedCursorImpl.this.markDeletePosition, ManagedCursorImpl.this.readPosition});
                LedgerHandle oldLedger = ManagedCursorImpl.this.cursorLedger;
                ManagedCursorImpl.this.cursorLedger = lh;
                ManagedCursorImpl.this.isCursorLedgerReadOnly = false;
                ManagedCursorImpl.this.cursorLedgerStat = stat;
                callback.operationComplete();
                ManagedCursorImpl.this.asyncDeleteLedger(oldLedger);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}] Failed to update consumer {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, e});
                callback.operationFailed(e);
            }
        }, false);
    }

    void notifyEntriesAvailable() {
        OpReadEntry opReadEntry;
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Received ml notification", (Object)this.ledger.getName(), (Object)this.name);
        }
        if ((opReadEntry = (OpReadEntry)WAITING_READ_OP_UPDATER.getAndSet(this, null)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Received notification of new messages persisted, reading at {} -- last: {}", new Object[]{this.ledger.getName(), this.name, opReadEntry.readPosition, this.ledger.lastConfirmedEntry});
                log.debug("[{}] Consumer {} cursor notification: other counters: consumed {} mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
            }
            PENDING_READ_OPS_UPDATER.incrementAndGet(this);
            opReadEntry.readPosition = (PositionImpl)this.getReadPosition();
            this.ledger.asyncReadEntries(opReadEntry);
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Received notification but had no pending read operation", (Object)this.ledger.getName(), (Object)this.name);
        }
    }

    void asyncCloseCursorLedger(final AsyncCallbacks.CloseCallback callback, Object ctx) {
        LedgerHandle lh = this.cursorLedger;
        this.ledger.mbean.startCursorLedgerCloseOp();
        log.info("[{}] [{}] Closing metadata ledger {}", new Object[]{this.ledger.getName(), this.name, lh.getId()});
        lh.asyncClose(new AsyncCallback.CloseCallback(){

            public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                ManagedCursorImpl.this.ledger.mbean.endCursorLedgerCloseOp();
                if (rc == 0) {
                    callback.closeComplete(ctx);
                } else {
                    callback.closeFailed(ManagedLedgerImpl.createManagedLedgerException(rc), ctx);
                }
            }
        }, ctx);
    }

    void decrementPendingMarkDeleteCount() {
        State state;
        if (PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.decrementAndGet(this) == 0 && (state = STATE_UPDATER.get(this)) == State.SwitchingLedger) {
            this.createNewMetadataLedger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readOperationCompleted() {
        if (PENDING_READ_OPS_UPDATER.decrementAndGet(this) == 0) {
            ArrayDeque<MarkDeleteEntry> arrayDeque = this.pendingMarkDeleteOps;
            synchronized (arrayDeque) {
                if (STATE_UPDATER.get(this) == State.Open) {
                    this.flushPendingMarkDeletes();
                } else if (PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.get(this) != 0) {
                    log.info("[{}] read operation completed and cursor was closed. need to call any queued cursor close", (Object)this.name);
                }
            }
        }
    }

    void asyncDeleteLedger(LedgerHandle lh) {
        this.asyncDeleteLedger(lh, 3);
    }

    private void asyncDeleteLedger(LedgerHandle lh, int retry) {
        if (lh == null || retry <= 0) {
            if (lh != null) {
                log.warn("[{}-{}] Failed to delete ledger after retries {}", new Object[]{this.ledger.getName(), this.name, lh.getId()});
            }
            return;
        }
        this.ledger.mbean.startCursorLedgerDeleteOp();
        this.bookkeeper.asyncDeleteLedger(lh.getId(), (rc, ctx) -> {
            this.ledger.mbean.endCursorLedgerDeleteOp();
            if (rc != 0) {
                log.warn("[{}] Failed to delete ledger {}: {}", new Object[]{this.ledger.getName(), lh.getId(), BKException.getMessage((int)rc)});
                if (!Errors.isNoSuchLedgerExistsException(rc)) {
                    this.ledger.getScheduledExecutor().schedule((SafeRunnable)SafeRun.safeRun(() -> this.asyncDeleteLedger(lh, retry - 1)), 60L, TimeUnit.SECONDS);
                }
                return;
            }
            log.info("[{}][{}] Successfully closed & deleted ledger {} in cursor", new Object[]{this.ledger.getName(), this.name, lh.getId()});
        }, null);
    }

    void asyncDeleteCursorLedger() {
        this.asyncDeleteCursorLedger(3);
    }

    private void asyncDeleteCursorLedger(int retry) {
        STATE_UPDATER.set(this, State.Closed);
        if (this.cursorLedger == null || retry <= 0) {
            if (this.cursorLedger != null) {
                log.warn("[{}-{}] Failed to delete ledger after retries {}", new Object[]{this.ledger.getName(), this.name, this.cursorLedger.getId()});
            }
            return;
        }
        this.ledger.mbean.startCursorLedgerDeleteOp();
        this.bookkeeper.asyncDeleteLedger(this.cursorLedger.getId(), (rc, ctx) -> {
            this.ledger.mbean.endCursorLedgerDeleteOp();
            if (rc == 0) {
                log.info("[{}][{}] Deleted cursor ledger {}", new Object[]{this.ledger.getName(), this.name, this.cursorLedger.getId()});
            } else {
                log.warn("[{}][{}] Failed to delete ledger {}: {}", new Object[]{this.ledger.getName(), this.name, this.cursorLedger.getId(), BKException.getMessage((int)rc)});
                if (!Errors.isNoSuchLedgerExistsException(rc)) {
                    this.ledger.getScheduledExecutor().schedule((SafeRunnable)SafeRun.safeRun(() -> this.asyncDeleteCursorLedger(retry - 1)), 60L, TimeUnit.SECONDS);
                }
            }
        }, null);
    }

    public static boolean isBkErrorNotRecoverable(int rc) {
        switch (rc) {
            case -25: 
            case -13: 
            case -10: 
            case -7: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    private PositionImpl getRollbackPosition(MLDataFormats.ManagedCursorInfo info) {
        PositionImpl firstPosition = this.ledger.getFirstPosition();
        PositionImpl snapshottedPosition = new PositionImpl(info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId());
        if (firstPosition == null) {
            return snapshottedPosition;
        }
        if (snapshottedPosition.compareTo(firstPosition) < 0) {
            return firstPosition;
        }
        return snapshottedPosition;
    }

    public int getPendingReadOpsCount() {
        return PENDING_READ_OPS_UPDATER.get(this);
    }

    public long getMessagesConsumedCounter() {
        return this.messagesConsumedCounter;
    }

    public long getCursorLedger() {
        LedgerHandle lh = this.cursorLedger;
        return lh != null ? lh.getId() : -1L;
    }

    public long getCursorLedgerLastEntry() {
        LedgerHandle lh = this.cursorLedger;
        return lh != null ? lh.getLastAddConfirmed() : -1L;
    }

    public String getIndividuallyDeletedMessages() {
        this.lock.readLock().lock();
        try {
            String string = this.individualDeletedMessages.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    public LongPairRangeSet<PositionImpl> getIndividuallyDeletedMessagesSet() {
        return this.individualDeletedMessages;
    }

    public boolean isMessageDeleted(Position position) {
        Preconditions.checkArgument((boolean)(position instanceof PositionImpl));
        return this.individualDeletedMessages.contains(((PositionImpl)position).getLedgerId(), ((PositionImpl)position).getEntryId()) || ((PositionImpl)position).compareTo(this.markDeletePosition) <= 0;
    }

    public long[] getBatchPositionAckSet(Position position) {
        if (!(position instanceof PositionImpl)) {
            return null;
        }
        if (this.batchDeletedIndexes != null) {
            BitSetRecyclable bitSetRecyclable = this.batchDeletedIndexes.get(position);
            if (bitSetRecyclable == null) {
                return null;
            }
            return bitSetRecyclable.toLongArray();
        }
        return null;
    }

    public PositionImpl getNextAvailablePosition(PositionImpl position) {
        Range range = this.individualDeletedMessages.rangeContaining(position.getLedgerId(), position.getEntryId());
        if (range != null) {
            PositionImpl nextPosition = ((PositionImpl)range.upperEndpoint()).getNext();
            return nextPosition != null && nextPosition.compareTo(position) > 0 ? nextPosition : position.getNext();
        }
        return position.getNext();
    }

    public Position getNextLedgerPosition(long currentLedgerId) {
        Long nextExistingLedger = this.ledger.getNextValidLedger(currentLedgerId);
        return nextExistingLedger != null ? PositionImpl.get(nextExistingLedger, 0L) : null;
    }

    public boolean isIndividuallyDeletedEntriesEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.individualDeletedMessages.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getLastLedgerSwitchTimestamp() {
        return this.lastLedgerSwitchTimestamp;
    }

    public String getState() {
        return STATE_UPDATER.get(this).toString();
    }

    @Override
    public double getThrottleMarkDelete() {
        return this.markDeleteLimiter.getRate();
    }

    @Override
    public void setThrottleMarkDelete(double throttleMarkDelete) {
        if (throttleMarkDelete > 0.0) {
            if (this.markDeleteLimiter == null) {
                this.markDeleteLimiter = RateLimiter.create((double)throttleMarkDelete);
            } else {
                this.markDeleteLimiter.setRate(throttleMarkDelete);
            }
        } else {
            this.markDeleteLimiter = null;
        }
    }

    @Override
    public ManagedLedger getManagedLedger() {
        return this.ledger;
    }

    @Override
    public Range<PositionImpl> getLastIndividualDeletedRange() {
        return this.individualDeletedMessages.lastRange();
    }

    @Override
    public void trimDeletedEntries(List<Entry> entries) {
        entries.removeIf(entry -> ((PositionImpl)entry.getPosition()).compareTo(this.markDeletePosition) <= 0 || this.individualDeletedMessages.contains(entry.getLedgerId(), entry.getEntryId()));
    }

    private ManagedCursorImpl cursorImpl() {
        return this;
    }

    @Override
    public long[] getDeletedBatchIndexesAsLongArray(PositionImpl position) {
        if (this.config.isDeletionAtBatchIndexLevelEnabled() && this.batchDeletedIndexes != null) {
            BitSetRecyclable bitSet = this.batchDeletedIndexes.get(position);
            return bitSet == null ? null : bitSet.toLongArray();
        }
        return null;
    }

    @Override
    public ManagedCursorMXBean getStats() {
        return this.mbean;
    }

    void updateReadStats(int readEntriesCount, long readEntriesSize) {
        this.entriesReadCount += (long)readEntriesCount;
        this.entriesReadSize += readEntriesSize;
    }

    void flush() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        this.asyncMarkDelete(this.lastMarkDeleteEntry.newPosition, this.lastMarkDeleteEntry.properties, new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Flushed dirty mark-delete position", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)ManagedCursorImpl.this.name);
                }
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}][{}] Failed to flush mark-delete position", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception});
            }
        }, null);
    }

    private int applyMaxSizeCap(int maxEntries, long maxSizeBytes) {
        if (maxSizeBytes == -1L) {
            return maxEntries;
        }
        double avgEntrySize = this.ledger.getStats().getEntrySizeAverage();
        if (!Double.isFinite(avgEntrySize)) {
            avgEntrySize = (double)this.entriesReadSize / (double)this.entriesReadCount;
        }
        if (!Double.isFinite(avgEntrySize)) {
            return 1;
        }
        int maxEntriesBasedOnSize = (int)((double)maxSizeBytes / avgEntrySize);
        if (maxEntriesBasedOnSize < 1) {
            return 1;
        }
        return Math.min(maxEntriesBasedOnSize, maxEntries);
    }

    @Override
    public boolean checkAndUpdateReadPositionChanged() {
        PositionImpl lastEntry = this.ledger.lastConfirmedEntry;
        boolean isReadPositionOnTail = lastEntry == null || this.readPosition == null || lastEntry.compareTo(this.readPosition) <= 0;
        boolean isReadPositionChanged = this.readPosition != null && !this.readPosition.equals(this.statsLastReadPosition);
        this.statsLastReadPosition = this.readPosition;
        return isReadPositionOnTail || isReadPositionChanged;
    }

    private boolean isCompactionCursor() {
        return COMPACTION_CURSOR_NAME.equals(this.name);
    }

    public static interface VoidCallback {
        public void operationComplete();

        public void operationFailed(ManagedLedgerException var1);
    }

    static enum State {
        Uninitialized,
        NoLedger,
        Open,
        SwitchingLedger,
        Closing,
        Closed;

    }

    class MarkDeleteEntry {
        final PositionImpl newPosition;
        final AsyncCallbacks.MarkDeleteCallback callback;
        final Object ctx;
        final Map<String, Long> properties;
        List<MarkDeleteEntry> callbackGroup;

        public MarkDeleteEntry(PositionImpl newPosition, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
            this.newPosition = newPosition;
            this.properties = properties;
            this.callback = callback;
            this.ctx = ctx;
        }
    }
}

