/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.bval.util.Validate;

public class Lazy<T>
implements Supplier<T> {
    private T value;
    private volatile Supplier<T> init;

    public Lazy(Supplier<T> init) {
        this.reset((T)init);
    }

    public Lazy<T> reset(Supplier<T> init) {
        this.init = Validate.notNull(init);
        return this;
    }

    public synchronized Lazy<T> reset(T value) {
        this.value = value;
        this.init = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.init != null) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.init != null) {
                    this.value = this.init.get();
                    this.init = null;
                }
            }
        }
        return this.value;
    }

    public Optional<T> optional() {
        return Optional.ofNullable(this.value);
    }

    public <U> Consumer<U> consumer(BiConsumer<? super T, ? super U> delegate) {
        return u -> delegate.accept((T)this.get(), (Object)u);
    }
}

