/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import com.google.inject.Inject;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBean;
import org.weakref.jmx.MBeanBuilder;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.internal.guava.collect.ImmutableMap;
import org.weakref.jmx.internal.guava.collect.MapMaker;

public class MBeanExporter {
    private final MBeanServer server;
    private final Map<ObjectName, Object> exportedObjects;
    private final ObjectNameGenerator objectNameGenerator;

    MBeanExporter() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public MBeanExporter(MBeanServer server) {
        this(server, Optional.empty());
    }

    @Inject
    public MBeanExporter(MBeanServer server, Optional<ObjectNameGenerator> objectNameGenerator) {
        this.server = server;
        this.objectNameGenerator = objectNameGenerator.orElseGet(ObjectNameGenerator::defaultObjectNameGenerator);
        this.exportedObjects = new MapMaker().weakValues().makeMap();
    }

    public MBeanExport exportWithGeneratedName(Object object) {
        Objects.requireNonNull(object, "object is null");
        ObjectName objectName = MBeanExporter.createObjectName(this.objectNameGenerator.generatedNameOf(object.getClass()));
        this.export(objectName, object);
        return new MBeanExport(objectName, () -> this.unexport(objectName));
    }

    public MBeanExport exportWithGeneratedName(Object object, Class<?> type) {
        Objects.requireNonNull(object, "object is null");
        Objects.requireNonNull(type, "type is null");
        ObjectName objectName = MBeanExporter.createObjectName(this.objectNameGenerator.generatedNameOf(type));
        this.export(objectName, object);
        return new MBeanExport(objectName, () -> this.unexport(objectName));
    }

    public MBeanExport exportWithGeneratedName(Object object, Class<?> type, String name) {
        Objects.requireNonNull(object, "object is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(name, "name is null");
        ObjectName objectName = MBeanExporter.createObjectName(this.objectNameGenerator.generatedNameOf(type, name));
        this.export(objectName, object);
        return new MBeanExport(objectName, () -> this.unexport(objectName));
    }

    public MBeanExport exportWithGeneratedName(Object object, Class<?> type, Map<String, String> properties) {
        Objects.requireNonNull(object, "object is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(properties, "properties is null");
        ObjectName objectName = MBeanExporter.createObjectName(this.objectNameGenerator.generatedNameOf(type, properties));
        this.export(objectName, object);
        return new MBeanExport(objectName, () -> this.unexport(objectName));
    }

    public void export(String name, Object object) {
        this.export(MBeanExporter.createObjectName(name), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ObjectName objectName, Object object) {
        try {
            MBeanBuilder builder = new MBeanBuilder(object);
            MBean mbean = builder.build();
            Map<ObjectName, Object> map = this.exportedObjects;
            synchronized (map) {
                if (this.exportedObjects.containsKey(objectName)) {
                    throw new JmxException(JmxException.Reason.INSTANCE_ALREADY_EXISTS, "key already exported: %s", objectName);
                }
                this.server.registerMBean(mbean, objectName);
                this.exportedObjects.put(objectName, object);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JmxException(JmxException.Reason.INSTANCE_ALREADY_EXISTS, e.getMessage(), new Object[0]);
        }
        catch (MBeanRegistrationException e) {
            throw new JmxException(JmxException.Reason.MBEAN_REGISTRATION, e.getMessage(), e.getCause());
        }
        catch (NotCompliantMBeanException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void unexportWithGeneratedName(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        this.unexport(this.objectNameGenerator.generatedNameOf(type));
    }

    public void unexportWithGeneratedName(Class<?> type, String name) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(name, "name is null");
        this.unexport(this.objectNameGenerator.generatedNameOf(type, name));
    }

    public void unexportWithGeneratedName(Class<?> type, Map<String, String> properties) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(properties, "properties is null");
        this.unexport(this.objectNameGenerator.generatedNameOf(type, properties));
    }

    public void unexport(String name) {
        this.unexport(MBeanExporter.createObjectName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(ObjectName objectName) {
        try {
            Map<ObjectName, Object> map = this.exportedObjects;
            synchronized (map) {
                this.server.unregisterMBean(objectName);
                this.exportedObjects.remove(objectName);
            }
        }
        catch (MBeanRegistrationException e) {
            throw new JmxException(JmxException.Reason.MBEAN_REGISTRATION, e.getMessage(), e.getCause());
        }
        catch (InstanceNotFoundException e) {
            throw new JmxException(JmxException.Reason.INSTANCE_NOT_FOUND, e.getMessage(), new Object[0]);
        }
    }

    @Deprecated
    public void unexportAll() {
        this.unexportAllAndReportMissing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> unexportAllAndReportMissing() {
        HashMap<String, Exception> errors = new HashMap<String, Exception>();
        Map<ObjectName, Object> map = this.exportedObjects;
        synchronized (map) {
            ArrayList<ObjectName> toRemove = new ArrayList<ObjectName>(this.exportedObjects.size());
            for (ObjectName objectName : this.exportedObjects.keySet()) {
                try {
                    this.server.unregisterMBean(objectName);
                    toRemove.add(objectName);
                }
                catch (InstanceNotFoundException e) {
                    toRemove.add(objectName);
                }
                catch (MBeanRegistrationException e) {
                    errors.put(objectName.toString(), e);
                }
            }
            this.exportedObjects.keySet().removeAll(toRemove);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getExportedObjects() {
        Map<ObjectName, Object> map = this.exportedObjects;
        synchronized (map) {
            ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
            for (Map.Entry<ObjectName, Object> entry : this.exportedObjects.entrySet()) {
                builder.put(entry.getKey().toString(), entry.getValue());
            }
            return builder.build();
        }
    }

    public static MBeanExporter withPlatformMBeanServer() {
        return new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
    }

    private static ObjectName createObjectName(String name) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new JmxException(JmxException.Reason.MALFORMED_OBJECT_NAME, e.getMessage(), new Object[0]);
        }
        return objectName;
    }
}

