/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyDataImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;

@ApiModel(value="NamespaceIsolationData", description="The data of namespace isolation configuration")
public class NamespaceIsolationDataImpl
implements NamespaceIsolationData {
    @ApiModelProperty(name="namespaces", value="The list of namespaces to apply this namespace isolation data")
    public List<String> namespaces = new ArrayList<String>();
    @ApiModelProperty(name="primary", value="The list of primary brokers for serving the list of namespaces in this isolation policy")
    public List<String> primary = new ArrayList<String>();
    @ApiModelProperty(name="primary", value="The list of secondary brokers for serving the list of namespaces in this isolation policy")
    public List<String> secondary = new ArrayList<String>();
    @ApiModelProperty(name="auto_failover_policy", value="The data of auto-failover policy configuration", example="{  \"policy_type\": \"min_available\"  \"parameters\": {    \"\": \"\"  }}")
    public AutoFailoverPolicyDataImpl auto_failover_policy;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.namespaces, this.primary, this.secondary, this.auto_failover_policy});
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceIsolationDataImpl) {
            NamespaceIsolationDataImpl other = (NamespaceIsolationDataImpl)obj;
            return Objects.equal(this.namespaces, other.namespaces) && Objects.equal(this.primary, other.primary) && Objects.equal(this.secondary, other.secondary) && Objects.equal((Object)this.auto_failover_policy, (Object)other.auto_failover_policy);
        }
        return false;
    }

    public void validate() {
        Preconditions.checkArgument((this.namespaces != null && !this.namespaces.isEmpty() && this.primary != null && !this.primary.isEmpty() && this.validateRegex(this.primary) && this.secondary != null && this.validateRegex(this.secondary) && this.auto_failover_policy != null ? 1 : 0) != 0);
        this.auto_failover_policy.validate();
    }

    private boolean validateRegex(List<String> policies) {
        if (policies != null && !policies.isEmpty()) {
            policies.forEach(policy -> {
                try {
                    if (StringUtils.isNotBlank((CharSequence)policy)) {
                        Pattern.compile(policy);
                    }
                }
                catch (PatternSyntaxException exception) {
                    throw new IllegalArgumentException("invalid policy regex " + policy);
                }
            });
        }
        return true;
    }

    public String toString() {
        return String.format("namespaces=%s primary=%s secondary=%s auto_failover_policy=%s", this.namespaces, this.primary, this.secondary, this.auto_failover_policy);
    }

    public void setAuto_failover_policy(AutoFailoverPolicyData autoFailoverPolicyData) {
        this.auto_failover_policy = (AutoFailoverPolicyDataImpl)autoFailoverPolicyData;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public List<String> getPrimary() {
        return this.primary;
    }

    public List<String> getSecondary() {
        return this.secondary;
    }

    public AutoFailoverPolicyDataImpl getAuto_failover_policy() {
        return this.auto_failover_policy;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public void setPrimary(List<String> primary) {
        this.primary = primary;
    }

    public void setSecondary(List<String> secondary) {
        this.secondary = secondary;
    }
}

