/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.pulsar.common.policies.data.FunctionInstanceStats;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataBase;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataBaseImpl;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsDataImpl;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.util.ObjectMapperFactory;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonPropertyOrder(value={"receivedTotal", "processedSuccessfullyTotal", "systemExceptionsTotal", "userExceptionsTotal", "avgProcessLatency", "1min", "lastInvocation", "instances"})
public class FunctionStatsImpl
implements FunctionStats {
    public long receivedTotal;
    public long processedSuccessfullyTotal;
    public long systemExceptionsTotal;
    public long userExceptionsTotal;
    public Double avgProcessLatency;
    @JsonProperty(value="1min")
    public FunctionInstanceStatsDataBase oneMin = new FunctionInstanceStatsDataBaseImpl();
    public Long lastInvocation;
    public List<FunctionInstanceStats> instances = new LinkedList<FunctionInstanceStats>();

    public void addInstance(FunctionInstanceStats functionInstanceStats) {
        this.instances.add(functionInstanceStats);
    }

    public FunctionStatsImpl calculateOverall() {
        int nonNullInstances = 0;
        int nonNullInstancesOneMin = 0;
        for (FunctionInstanceStats functionInstanceStats : this.instances) {
            FunctionInstanceStatsDataImpl functionInstanceStatsData = (FunctionInstanceStatsDataImpl)functionInstanceStats.getMetrics();
            this.receivedTotal += functionInstanceStatsData.receivedTotal;
            this.processedSuccessfullyTotal += functionInstanceStatsData.processedSuccessfullyTotal;
            this.systemExceptionsTotal += functionInstanceStatsData.systemExceptionsTotal;
            this.userExceptionsTotal += functionInstanceStatsData.userExceptionsTotal;
            if (functionInstanceStatsData.avgProcessLatency != null) {
                if (this.avgProcessLatency == null) {
                    this.avgProcessLatency = 0.0;
                }
                this.avgProcessLatency = this.avgProcessLatency + functionInstanceStatsData.avgProcessLatency;
                ++nonNullInstances;
            }
            this.oneMin.setReceivedTotal(this.oneMin.getReceivedTotal() + functionInstanceStatsData.oneMin.getReceivedTotal());
            this.oneMin.setProcessedSuccessfullyTotal(this.oneMin.getProcessedSuccessfullyTotal() + functionInstanceStatsData.oneMin.getProcessedSuccessfullyTotal());
            this.oneMin.setSystemExceptionsTotal(this.oneMin.getSystemExceptionsTotal() + functionInstanceStatsData.oneMin.getSystemExceptionsTotal());
            this.oneMin.setUserExceptionsTotal(this.oneMin.getUserExceptionsTotal() + functionInstanceStatsData.oneMin.getUserExceptionsTotal());
            if (functionInstanceStatsData.oneMin.getAvgProcessLatency() != null) {
                if (this.oneMin.getAvgProcessLatency() == null) {
                    this.oneMin.setAvgProcessLatency(Double.valueOf(0.0));
                }
                this.oneMin.setAvgProcessLatency(Double.valueOf(this.oneMin.getAvgProcessLatency() + functionInstanceStatsData.oneMin.getAvgProcessLatency()));
                ++nonNullInstancesOneMin;
            }
            if (functionInstanceStatsData.lastInvocation == null || this.lastInvocation != null && functionInstanceStatsData.lastInvocation <= this.lastInvocation) continue;
            this.lastInvocation = functionInstanceStatsData.lastInvocation;
        }
        this.avgProcessLatency = nonNullInstances > 0 ? Double.valueOf(this.avgProcessLatency / (double)nonNullInstances) : null;
        if (nonNullInstancesOneMin > 0) {
            this.oneMin.setAvgProcessLatency(Double.valueOf(this.oneMin.getAvgProcessLatency() / (double)nonNullInstancesOneMin));
        } else {
            this.oneMin.setAvgProcessLatency(null);
        }
        return this;
    }

    public static FunctionStatsImpl decode(String json) throws IOException {
        return (FunctionStatsImpl)ObjectMapperFactory.getThreadLocal().readValue(json, FunctionStatsImpl.class);
    }

    public long getReceivedTotal() {
        return this.receivedTotal;
    }

    public long getProcessedSuccessfullyTotal() {
        return this.processedSuccessfullyTotal;
    }

    public long getSystemExceptionsTotal() {
        return this.systemExceptionsTotal;
    }

    public long getUserExceptionsTotal() {
        return this.userExceptionsTotal;
    }

    public Double getAvgProcessLatency() {
        return this.avgProcessLatency;
    }

    public FunctionInstanceStatsDataBase getOneMin() {
        return this.oneMin;
    }

    public Long getLastInvocation() {
        return this.lastInvocation;
    }

    public List<FunctionInstanceStats> getInstances() {
        return this.instances;
    }

    public void setReceivedTotal(long receivedTotal) {
        this.receivedTotal = receivedTotal;
    }

    public void setProcessedSuccessfullyTotal(long processedSuccessfullyTotal) {
        this.processedSuccessfullyTotal = processedSuccessfullyTotal;
    }

    public void setSystemExceptionsTotal(long systemExceptionsTotal) {
        this.systemExceptionsTotal = systemExceptionsTotal;
    }

    public void setUserExceptionsTotal(long userExceptionsTotal) {
        this.userExceptionsTotal = userExceptionsTotal;
    }

    public void setAvgProcessLatency(Double avgProcessLatency) {
        this.avgProcessLatency = avgProcessLatency;
    }

    @JsonProperty(value="1min")
    public void setOneMin(FunctionInstanceStatsDataBase oneMin) {
        this.oneMin = oneMin;
    }

    public void setLastInvocation(Long lastInvocation) {
        this.lastInvocation = lastInvocation;
    }

    public void setInstances(List<FunctionInstanceStats> instances) {
        this.instances = instances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionStatsImpl)) {
            return false;
        }
        FunctionStatsImpl other = (FunctionStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReceivedTotal() != other.getReceivedTotal()) {
            return false;
        }
        if (this.getProcessedSuccessfullyTotal() != other.getProcessedSuccessfullyTotal()) {
            return false;
        }
        if (this.getSystemExceptionsTotal() != other.getSystemExceptionsTotal()) {
            return false;
        }
        if (this.getUserExceptionsTotal() != other.getUserExceptionsTotal()) {
            return false;
        }
        Double this$avgProcessLatency = this.getAvgProcessLatency();
        Double other$avgProcessLatency = other.getAvgProcessLatency();
        if (this$avgProcessLatency == null ? other$avgProcessLatency != null : !((Object)this$avgProcessLatency).equals(other$avgProcessLatency)) {
            return false;
        }
        Long this$lastInvocation = this.getLastInvocation();
        Long other$lastInvocation = other.getLastInvocation();
        if (this$lastInvocation == null ? other$lastInvocation != null : !((Object)this$lastInvocation).equals(other$lastInvocation)) {
            return false;
        }
        FunctionInstanceStatsDataBase this$oneMin = this.getOneMin();
        FunctionInstanceStatsDataBase other$oneMin = other.getOneMin();
        if (this$oneMin == null ? other$oneMin != null : !this$oneMin.equals(other$oneMin)) {
            return false;
        }
        List<FunctionInstanceStats> this$instances = this.getInstances();
        List<FunctionInstanceStats> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $receivedTotal = this.getReceivedTotal();
        result = result * 59 + (int)($receivedTotal >>> 32 ^ $receivedTotal);
        long $processedSuccessfullyTotal = this.getProcessedSuccessfullyTotal();
        result = result * 59 + (int)($processedSuccessfullyTotal >>> 32 ^ $processedSuccessfullyTotal);
        long $systemExceptionsTotal = this.getSystemExceptionsTotal();
        result = result * 59 + (int)($systemExceptionsTotal >>> 32 ^ $systemExceptionsTotal);
        long $userExceptionsTotal = this.getUserExceptionsTotal();
        result = result * 59 + (int)($userExceptionsTotal >>> 32 ^ $userExceptionsTotal);
        Double $avgProcessLatency = this.getAvgProcessLatency();
        result = result * 59 + ($avgProcessLatency == null ? 43 : ((Object)$avgProcessLatency).hashCode());
        Long $lastInvocation = this.getLastInvocation();
        result = result * 59 + ($lastInvocation == null ? 43 : ((Object)$lastInvocation).hashCode());
        FunctionInstanceStatsDataBase $oneMin = this.getOneMin();
        result = result * 59 + ($oneMin == null ? 43 : $oneMin.hashCode());
        List<FunctionInstanceStats> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        return result;
    }

    public String toString() {
        return "FunctionStatsImpl(receivedTotal=" + this.getReceivedTotal() + ", processedSuccessfullyTotal=" + this.getProcessedSuccessfullyTotal() + ", systemExceptionsTotal=" + this.getSystemExceptionsTotal() + ", userExceptionsTotal=" + this.getUserExceptionsTotal() + ", avgProcessLatency=" + this.getAvgProcessLatency() + ", oneMin=" + this.getOneMin() + ", lastInvocation=" + this.getLastInvocation() + ", instances=" + this.getInstances() + ")";
    }
}

