/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.impl;

import java.util.Objects;
import java.util.SortedSet;
import org.apache.pulsar.common.policies.AutoFailoverPolicy;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerStatus;

public class MinAvailablePolicy
extends AutoFailoverPolicy {
    private static final String MIN_LIMIT_KEY = "min_limit";
    private static final String USAGE_THRESHOLD_KEY = "usage_threshold";
    private static final int MAX_USAGE_THRESHOLD = 100;
    public int min_limit;
    public int usage_threshold;

    MinAvailablePolicy(int minLimit, int usageThreshold) {
        this.min_limit = minLimit;
        this.usage_threshold = usageThreshold;
    }

    public MinAvailablePolicy(AutoFailoverPolicyData policyData) {
        if (!policyData.getPolicy_type().equals((Object)AutoFailoverPolicyType.min_available)) {
            throw new IllegalArgumentException();
        }
        if (!policyData.getParameters().containsKey(MIN_LIMIT_KEY)) {
            throw new IllegalArgumentException();
        }
        if (!policyData.getParameters().containsKey(USAGE_THRESHOLD_KEY)) {
            throw new IllegalArgumentException();
        }
        this.min_limit = Integer.parseInt(policyData.getParameters().get(MIN_LIMIT_KEY));
        this.usage_threshold = Integer.parseInt(policyData.getParameters().get(USAGE_THRESHOLD_KEY));
    }

    public int hashCode() {
        return Objects.hash(this.min_limit, this.usage_threshold);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MinAvailablePolicy) {
            MinAvailablePolicy other = (MinAvailablePolicy)obj;
            return Objects.equals(this.min_limit, other.min_limit) && Objects.equals(this.usage_threshold, other.usage_threshold);
        }
        return false;
    }

    @Override
    public boolean isBrokerAvailable(BrokerStatus brokerStatus) {
        return brokerStatus.isActive() && (this.usage_threshold == 100 || brokerStatus.getLoadFactor() < this.usage_threshold);
    }

    @Override
    public boolean shouldFailoverToSecondary(SortedSet<BrokerStatus> primaryCandidates) {
        int numAvailablePrimaryBrokers = 0;
        for (BrokerStatus brkStatus : primaryCandidates) {
            if (!this.isBrokerAvailable(brkStatus)) continue;
            ++numAvailablePrimaryBrokers;
        }
        return numAvailablePrimaryBrokers < this.min_limit;
    }

    @Override
    public boolean shouldFailoverToSecondary(int totalPrimaryCandidates) {
        return totalPrimaryCandidates < this.min_limit;
    }

    public String toString() {
        return String.format("[policy_type=min_available min_limit=%s usage_threshold=%s]", this.min_limit, this.usage_threshold);
    }
}

