/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicStats;

public class NonPersistentTopicStats
extends TopicStats {
    public double msgDropRate;
    public List<NonPersistentPublisherStats> publishers = new ArrayList<NonPersistentPublisherStats>();
    public Map<String, NonPersistentSubscriptionStats> subscriptions = new HashMap<String, NonPersistentSubscriptionStats>();
    public Map<String, NonPersistentReplicatorStats> replication = new TreeMap<String, NonPersistentReplicatorStats>();

    @Override
    public void reset() {
        super.reset();
        this.msgDropRate = 0.0;
    }

    public NonPersistentTopicStats add(NonPersistentTopicStats stats) {
        Objects.requireNonNull(stats);
        super.add(stats);
        this.msgDropRate += stats.msgDropRate;
        return this;
    }

    public List<NonPersistentPublisherStats> getPublishers() {
        return this.publishers;
    }

    public Map<String, NonPersistentSubscriptionStats> getSubscriptions() {
        return this.subscriptions;
    }

    public Map<String, NonPersistentReplicatorStats> getReplication() {
        return this.replication;
    }
}

