/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

public class BrokerStatus
implements Comparable<BrokerStatus> {
    private String brokerAddress;
    private boolean active;
    private int loadFactor;

    public BrokerStatus(String lookupServiceAddress, boolean active, int loadFactor) {
        this.brokerAddress = lookupServiceAddress;
        this.active = active;
        this.loadFactor = loadFactor;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    @Override
    public int compareTo(BrokerStatus other) {
        int result = Integer.compare(this.loadFactor, other.loadFactor);
        if (result == 0) {
            result = this.brokerAddress.compareTo(other.brokerAddress);
        }
        return result;
    }

    public String toString() {
        return String.format("[brokerAddress=%s, active=%s, loadFactor=%s]", this.brokerAddress, this.active, this.loadFactor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerStatus)) {
            return false;
        }
        BrokerStatus other = (BrokerStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.getLoadFactor() != other.getLoadFactor()) {
            return false;
        }
        String this$brokerAddress = this.getBrokerAddress();
        String other$brokerAddress = other.getBrokerAddress();
        return !(this$brokerAddress == null ? other$brokerAddress != null : !this$brokerAddress.equals(other$brokerAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + this.getLoadFactor();
        String $brokerAddress = this.getBrokerAddress();
        result = result * 59 + ($brokerAddress == null ? 43 : $brokerAddress.hashCode());
        return result;
    }
}

