/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.Objects;

public class BacklogQuota {
    private long limitSize;
    private int limitTime;
    private RetentionPolicy policy;

    public long getLimitSize() {
        return this.limitSize;
    }

    public int getLimitTime() {
        return this.limitTime;
    }

    public RetentionPolicy getPolicy() {
        return this.policy;
    }

    public void setLimitSize(long limitSize) {
        this.limitSize = limitSize;
    }

    public void setPolicy(RetentionPolicy policy) {
        this.policy = policy;
    }

    protected BacklogQuota() {
    }

    public BacklogQuota(long limitSize, RetentionPolicy policy) {
        this(limitSize, -1, policy);
    }

    public BacklogQuota(long limitSize, int limitTime, RetentionPolicy policy) {
        this.limitTime = limitTime;
        this.limitSize = limitSize;
        this.policy = policy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.limitSize, (long)this.limitTime, this.policy});
    }

    public boolean equals(Object obj) {
        if (obj instanceof BacklogQuota) {
            BacklogQuota other = (BacklogQuota)obj;
            return Objects.equals(this.limitSize, other.limitSize) && Objects.equals(this.limitTime, other.limitTime) && Objects.equals((Object)this.policy, (Object)other.policy);
        }
        return false;
    }

    public String toString() {
        return "BacklogQuota(limitSize=" + this.getLimitSize() + ", limitTime=" + this.getLimitTime() + ", policy=" + (Object)((Object)this.getPolicy()) + ")";
    }

    public static enum RetentionPolicy {
        producer_request_hold,
        producer_exception,
        consumer_backlog_eviction;

    }

    public static enum BacklogQuotaType {
        destination_storage,
        message_age;

    }
}

