/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;

public class PulsarColumnMetadata
extends ColumnMetadata {
    private boolean isInternal;
    private String nameWithCase;
    private String[] fieldNames;
    private Integer[] positionIndices;
    private PulsarColumnHandle.HandleKeyValueType handleKeyValueType;
    public static final String KEY_SCHEMA_COLUMN_PREFIX = "__key.";

    public PulsarColumnMetadata(String name, Type type, String comment, String extraInfo, boolean hidden, boolean isInternal, String[] fieldNames, Integer[] positionIndices, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        super(name, type, comment, extraInfo, hidden);
        this.nameWithCase = name;
        this.isInternal = isInternal;
        this.fieldNames = fieldNames;
        this.positionIndices = positionIndices;
        this.handleKeyValueType = handleKeyValueType;
    }

    public String getNameWithCase() {
        return this.nameWithCase;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Integer[] getPositionIndices() {
        return this.positionIndices;
    }

    public PulsarColumnHandle.HandleKeyValueType getHandleKeyValueType() {
        return this.handleKeyValueType;
    }

    public boolean isKey() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)PulsarColumnHandle.HandleKeyValueType.KEY);
    }

    public boolean isValue() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)PulsarColumnHandle.HandleKeyValueType.VALUE);
    }

    public static String getColumnName(PulsarColumnHandle.HandleKeyValueType handleKeyValueType, String name) {
        if (Objects.equals((Object)PulsarColumnHandle.HandleKeyValueType.KEY, (Object)handleKeyValueType)) {
            return KEY_SCHEMA_COLUMN_PREFIX + name;
        }
        return name;
    }

    public String toString() {
        return "PulsarColumnMetadata{isInternal=" + this.isInternal + ", nameWithCase='" + this.nameWithCase + '\'' + ", fieldNames=" + Arrays.toString(this.fieldNames) + ", positionIndices=" + Arrays.toString((Object[])this.positionIndices) + ", handleKeyValueType=" + (Object)((Object)this.handleKeyValueType) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PulsarColumnMetadata that = (PulsarColumnMetadata)((Object)o);
        if (this.isInternal != that.isInternal) {
            return false;
        }
        if (this.nameWithCase != null ? !this.nameWithCase.equals(that.nameWithCase) : that.nameWithCase != null) {
            return false;
        }
        if (!Arrays.deepEquals(this.fieldNames, that.fieldNames)) {
            return false;
        }
        if (!Arrays.deepEquals(this.positionIndices, that.positionIndices)) {
            return false;
        }
        return Objects.equals((Object)this.handleKeyValueType, (Object)that.handleKeyValueType);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isInternal ? 1 : 0);
        result = 31 * result + (this.nameWithCase != null ? this.nameWithCase.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode((Object[])this.positionIndices);
        result = 31 * result + (this.handleKeyValueType != null ? this.handleKeyValueType.hashCode() : 0);
        return result;
    }
}

