/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.dslplatform.json.DslJson;
import io.airlift.log.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.SchemaHandler;

public class JSONSchemaHandler
implements SchemaHandler {
    private static final Logger log = Logger.get(JSONSchemaHandler.class);
    private List<PulsarColumnHandle> columnHandles;
    private final DslJson<Object> dslJson = new DslJson();
    private static final FastThreadLocal<byte[]> tmpBuffer = new FastThreadLocal<byte[]>(){

        protected byte[] initialValue() {
            return new byte[1024];
        }
    };

    public JSONSchemaHandler(List<PulsarColumnHandle> columnHandles) {
        this.columnHandles = columnHandles;
    }

    @Override
    public Object deserialize(ByteBuf payload) {
        int size = payload.readableBytes();
        byte[] buffer = (byte[])tmpBuffer.get();
        if (buffer.length < size) {
            buffer = new byte[size * 2];
            tmpBuffer.set((Object)buffer);
        }
        payload.readBytes(buffer, 0, size);
        try {
            return this.dslJson.deserialize(Map.class, buffer, size);
        }
        catch (IOException e) {
            log.error("Failed to deserialize Json object", new Object[]{e});
            return null;
        }
    }

    @Override
    public Object extractField(int index, Object currentRecord) {
        try {
            Map jsonObject = (Map)currentRecord;
            PulsarColumnHandle pulsarColumnHandle = this.columnHandles.get(index);
            String[] fieldNames = pulsarColumnHandle.getFieldNames();
            Object field = jsonObject.get(fieldNames[0]);
            if (field == null) {
                return null;
            }
            for (int i = 1; i < fieldNames.length; ++i) {
                if ((field = ((Map)field).get(fieldNames[i])) != null) continue;
                return null;
            }
            Type type = pulsarColumnHandle.getType();
            Class javaType = type.getJavaType();
            if (javaType == Double.TYPE) {
                return ((BigDecimal)field).doubleValue();
            }
            return field;
        }
        catch (Exception ex) {
            log.debug((Throwable)ex, "%s", new Object[]{ex});
            return null;
        }
    }
}

