/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;

public class GenericAvroWriter
implements SchemaWriter<org.apache.pulsar.client.api.schema.GenericRecord> {
    private final GenericDatumWriter<GenericRecord> writer;
    private BinaryEncoder encoder;
    private final ByteArrayOutputStream byteArrayOutputStream;

    public GenericAvroWriter(Schema schema) {
        this.writer = new GenericDatumWriter(schema);
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.byteArrayOutputStream, this.encoder);
    }

    public synchronized byte[] write(org.apache.pulsar.client.api.schema.GenericRecord message) {
        try {
            this.writer.write((Object)((GenericAvroRecord)message).getAvroRecord(), (Encoder)this.encoder);
            this.encoder.flush();
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SchemaSerializationException((Throwable)e);
        }
        finally {
            this.byteArrayOutputStream.reset();
        }
    }
}

