/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.SecurityUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationDataTls
implements AuthenticationDataProvider {
    protected X509Certificate[] tlsCertificates;
    protected PrivateKey tlsPrivateKey;
    private FileModifiedTimeUpdater certFile;
    private FileModifiedTimeUpdater keyFile;
    private InputStream certStream;
    private InputStream keyStream;
    private Supplier<ByteArrayInputStream> certStreamProvider;
    private Supplier<ByteArrayInputStream> keyStreamProvider;
    private Supplier<ByteArrayInputStream> trustStoreStreamProvider;
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationDataTls.class);

    public AuthenticationDataTls(String certFilePath, String keyFilePath) throws KeyManagementException {
        if (certFilePath == null) {
            throw new IllegalArgumentException("certFilePath must not be null");
        }
        if (keyFilePath == null) {
            throw new IllegalArgumentException("keyFilePath must not be null");
        }
        this.certFile = new FileModifiedTimeUpdater(certFilePath);
        this.keyFile = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsCertificates = SecurityUtility.loadCertificatesFromPemFile((String)certFilePath);
        this.tlsPrivateKey = SecurityUtility.loadPrivateKeyFromPemFile((String)keyFilePath);
    }

    public AuthenticationDataTls(Supplier<ByteArrayInputStream> certStreamProvider, Supplier<ByteArrayInputStream> keyStreamProvider) throws KeyManagementException {
        this(certStreamProvider, keyStreamProvider, null);
    }

    public AuthenticationDataTls(Supplier<ByteArrayInputStream> certStreamProvider, Supplier<ByteArrayInputStream> keyStreamProvider, Supplier<ByteArrayInputStream> trustStoreStreamProvider) throws KeyManagementException {
        if (certStreamProvider == null || certStreamProvider.get() == null) {
            throw new IllegalArgumentException("certStream provider or stream must not be null");
        }
        if (keyStreamProvider == null || keyStreamProvider.get() == null) {
            throw new IllegalArgumentException("keyStream provider or stream must not be null");
        }
        this.certStreamProvider = certStreamProvider;
        this.keyStreamProvider = keyStreamProvider;
        this.trustStoreStreamProvider = trustStoreStreamProvider;
        this.certStream = certStreamProvider.get();
        this.keyStream = keyStreamProvider.get();
        this.tlsCertificates = SecurityUtility.loadCertificatesFromPemStream((InputStream)this.certStream);
        this.tlsPrivateKey = SecurityUtility.loadPrivateKeyFromPemStream((InputStream)this.keyStream);
    }

    public boolean hasDataForTls() {
        return true;
    }

    public Certificate[] getTlsCertificates() {
        if (this.certFile != null && this.certFile.checkAndRefresh()) {
            try {
                this.tlsCertificates = SecurityUtility.loadCertificatesFromPemFile((String)this.certFile.getFileName());
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to refresh authData for cert {}: ", (Object)this.certFile.getFileName(), (Object)e);
            }
        } else if (this.certStreamProvider != null && this.certStreamProvider.get() != null && !this.certStreamProvider.get().equals(this.certStream)) {
            try {
                this.certStream = this.certStreamProvider.get();
                this.tlsCertificates = SecurityUtility.loadCertificatesFromPemStream((InputStream)this.certStream);
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to refresh authData from cert stream ", (Throwable)e);
            }
        }
        return this.tlsCertificates;
    }

    public PrivateKey getTlsPrivateKey() {
        if (this.keyFile != null && this.keyFile.checkAndRefresh()) {
            try {
                this.tlsPrivateKey = SecurityUtility.loadPrivateKeyFromPemFile((String)this.keyFile.getFileName());
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to refresh authData for cert {}: ", (Object)this.keyFile.getFileName(), (Object)e);
            }
        } else if (this.keyStreamProvider != null && this.keyStreamProvider.get() != null && !this.keyStreamProvider.get().equals(this.keyStream)) {
            try {
                this.keyStream = this.keyStreamProvider.get();
                this.tlsPrivateKey = SecurityUtility.loadPrivateKeyFromPemStream((InputStream)this.keyStream);
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to refresh authData from key stream ", (Throwable)e);
            }
        }
        return this.tlsPrivateKey;
    }

    public InputStream getTlsTrustStoreStream() {
        return this.trustStoreStreamProvider != null ? (InputStream)this.trustStoreStreamProvider.get() : null;
    }
}

