/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.autorecovery;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.net.URI;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoIsAuditorCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(WhoIsAuditorCommand.class);
    private static final String NAME = "whoisauditor";
    private static final String DESC = "Print the node which holds the auditor lock.";

    public WhoIsAuditorCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            return this.getAuditor(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAuditor(ServerConfiguration conf) throws ConfigurationException, InterruptedException, IOException, KeeperException {
        try (ZooKeeperClient zk = null;){
            String metadataServiceUri = conf.getMetadataServiceUri();
            String zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri(URI.create(metadataServiceUri));
            zk = ZooKeeperClient.newBuilder().connectString(zkServers).sessionTimeoutMs(conf.getZkTimeout()).build();
            BookieId bookieId = AuditorElector.getCurrentAuditor(conf, zk);
            if (bookieId == null) {
                LOG.info("No auditor elected");
                boolean bl = false;
                return bl;
            }
            LOG.info("Auditor: " + bookieId);
        }
        return true;
    }
}

