/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.apache.pulsar.client.admin.ProxyStats;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class ProxyStatsImpl
extends BaseResource
implements ProxyStats {
    private final WebTarget adminProxyStats;

    public ProxyStatsImpl(WebTarget target, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminProxyStats = target.path("/proxy-stats");
    }

    @Override
    public JsonArray getConnections() throws PulsarAdminException {
        try {
            String json = this.request(this.adminProxyStats.path("/connections")).get(String.class);
            return (JsonArray)new Gson().fromJson(json, JsonArray.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public JsonObject getTopics() throws PulsarAdminException {
        try {
            String json = this.request(this.adminProxyStats.path("/topics")).get(String.class);
            return (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

