/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import io.netty.buffer.ByteBuf;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.SchemaHandler;

public class PulsarPrimitiveSchemaHandler
implements SchemaHandler {
    private final SchemaInfo schemaInfo;
    private final AbstractSchema<?> schema;

    PulsarPrimitiveSchemaHandler(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        this.schema = (AbstractSchema)AutoConsumeSchema.getSchema(schemaInfo);
    }

    @Override
    public Object deserialize(ByteBuf payload) {
        Object currentRecord = this.schema.decode(payload);
        switch (this.schemaInfo.getType()) {
            case DATE: {
                return ((Date)currentRecord).getTime();
            }
            case TIME: {
                return ((Time)currentRecord).getTime();
            }
            case TIMESTAMP: {
                return ((Timestamp)currentRecord).getTime();
            }
        }
        return currentRecord;
    }

    @Override
    public Object extractField(int index, Object currentRecord) {
        return currentRecord;
    }
}

