/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.bookkeeper.mledger.LedgerOffloaderStats;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.naming.TopicName;

public final class LedgerOffloaderStatsImpl
implements LedgerOffloaderStats,
Runnable {
    private static final String TOPIC_LABEL = "topic";
    private static final String NAMESPACE_LABEL = "namespace";
    private static final String UNKNOWN = "unknown";
    private static final String STATUS = "status";
    private static final String SUCCEED = "succeed";
    private static final String FAILED = "failed";
    private final boolean exposeTopicLevelMetrics;
    private final int interval;
    private final Counter offloadError;
    private final Gauge offloadRate;
    private final Counter deleteOffloadOps;
    private final Summary readLedgerLatency;
    private final Counter writeStorageError;
    private final Counter readOffloadError;
    private final Gauge readOffloadRate;
    private final Summary readOffloadIndexLatency;
    private final Summary readOffloadDataLatency;
    private final Map<String, Long> topicAccess;
    private final Map<String, String> topic2Namespace;
    private final Map<String, Pair<LongAdder, LongAdder>> offloadAndReadOffloadBytesMap;
    final AtomicBoolean closed = new AtomicBoolean(false);
    private static LedgerOffloaderStats instance;

    private LedgerOffloaderStatsImpl(boolean exposeTopicLevelMetrics, ScheduledExecutorService scheduler, int interval) {
        String[] stringArray;
        String[] stringArray2;
        this.interval = interval;
        this.exposeTopicLevelMetrics = exposeTopicLevelMetrics;
        if (null != scheduler) {
            scheduler.scheduleAtFixedRate(this, interval, interval, TimeUnit.SECONDS);
        }
        this.topicAccess = new ConcurrentHashMap<String, Long>();
        this.topic2Namespace = new ConcurrentHashMap<String, String>();
        this.offloadAndReadOffloadBytesMap = new ConcurrentHashMap<String, Pair<LongAdder, LongAdder>>();
        if (exposeTopicLevelMetrics) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = NAMESPACE_LABEL;
            stringArray2 = stringArray3;
            stringArray3[1] = TOPIC_LABEL;
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = NAMESPACE_LABEL;
        }
        String[] labels = stringArray2;
        this.offloadError = (Counter)((Counter.Builder)Counter.build((String)"brk_ledgeroffloader_offload_error", (String)"-").labelNames(labels)).create().register();
        this.offloadRate = (Gauge)((Gauge.Builder)Gauge.build((String)"brk_ledgeroffloader_offload_rate", (String)"-").labelNames(labels)).create().register();
        this.readOffloadError = (Counter)((Counter.Builder)Counter.build((String)"brk_ledgeroffloader_read_offload_error", (String)"-").labelNames(labels)).create().register();
        this.readOffloadRate = (Gauge)((Gauge.Builder)Gauge.build((String)"brk_ledgeroffloader_read_offload_rate", (String)"-").labelNames(labels)).create().register();
        this.writeStorageError = (Counter)((Counter.Builder)Counter.build((String)"brk_ledgeroffloader_write_storage_error", (String)"-").labelNames(labels)).create().register();
        this.readOffloadIndexLatency = (Summary)((Summary.Builder)Summary.build((String)"brk_ledgeroffloader_read_offload_index_latency", (String)"-").labelNames(labels)).create().register();
        this.readOffloadDataLatency = (Summary)((Summary.Builder)Summary.build((String)"brk_ledgeroffloader_read_offload_data_latency", (String)"-").labelNames(labels)).create().register();
        this.readLedgerLatency = (Summary)((Summary.Builder)Summary.build((String)"brk_ledgeroffloader_read_ledger_latency", (String)"-").labelNames(labels)).create().register();
        if (exposeTopicLevelMetrics) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = NAMESPACE_LABEL;
            stringArray5[1] = TOPIC_LABEL;
            stringArray = stringArray5;
            stringArray5[2] = STATUS;
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = NAMESPACE_LABEL;
            stringArray = stringArray6;
            stringArray6[1] = STATUS;
        }
        String[] deleteOpsLabels = stringArray;
        this.deleteOffloadOps = (Counter)((Counter.Builder)Counter.build((String)"brk_ledgeroffloader_delete_offload_ops", (String)"-").labelNames(deleteOpsLabels)).create().register();
    }

    public static synchronized LedgerOffloaderStats getInstance(boolean exposeTopicLevelMetrics, ScheduledExecutorService scheduler, int interval) {
        if (null == instance) {
            instance = new LedgerOffloaderStatsImpl(exposeTopicLevelMetrics, scheduler, interval);
        }
        return instance;
    }

    @Override
    public void recordOffloadError(String topic) {
        String[] labelValues = this.labelValues(topic);
        ((Counter.Child)this.offloadError.labels(labelValues)).inc();
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordOffloadBytes(String topic, long size) {
        topic = StringUtils.isBlank((CharSequence)topic) ? UNKNOWN : topic;
        Pair pair = this.offloadAndReadOffloadBytesMap.computeIfAbsent(topic, __ -> new ImmutablePair((Object)new LongAdder(), (Object)new LongAdder()));
        ((LongAdder)pair.getLeft()).add(size);
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordReadLedgerLatency(String topic, long latency, TimeUnit unit) {
        String[] labelValues = this.labelValues(topic);
        ((Summary.Child)this.readLedgerLatency.labels(labelValues)).observe((double)unit.toMicros(latency));
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordWriteToStorageError(String topic) {
        String[] labelValues = this.labelValues(topic);
        ((Counter.Child)this.writeStorageError.labels(labelValues)).inc();
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordReadOffloadError(String topic) {
        String[] labelValues = this.labelValues(topic);
        ((Counter.Child)this.readOffloadError.labels(labelValues)).inc();
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordReadOffloadBytes(String topic, long size) {
        topic = StringUtils.isBlank((CharSequence)topic) ? UNKNOWN : topic;
        Pair pair = this.offloadAndReadOffloadBytesMap.computeIfAbsent(topic, __ -> new ImmutablePair((Object)new LongAdder(), (Object)new LongAdder()));
        ((LongAdder)pair.getRight()).add(size);
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordReadOffloadIndexLatency(String topic, long latency, TimeUnit unit) {
        String[] labelValues = this.labelValues(topic);
        ((Summary.Child)this.readOffloadIndexLatency.labels(labelValues)).observe((double)unit.toMicros(latency));
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordReadOffloadDataLatency(String topic, long latency, TimeUnit unit) {
        String[] labelValues = this.labelValues(topic);
        ((Summary.Child)this.readOffloadDataLatency.labels(labelValues)).observe((double)unit.toMicros(latency));
        this.addOrUpdateTopicAccess(topic);
    }

    @Override
    public void recordDeleteOffloadOps(String topic, boolean succeed) {
        String status = succeed ? SUCCEED : FAILED;
        String[] labelValues = this.labelValues(topic, status);
        ((Counter.Child)this.deleteOffloadOps.labels(labelValues)).inc();
        this.addOrUpdateTopicAccess(topic);
    }

    private void addOrUpdateTopicAccess(String topic) {
        topic = StringUtils.isBlank((CharSequence)topic) ? UNKNOWN : topic;
        this.topicAccess.put(topic, System.currentTimeMillis());
    }

    private String[] labelValues(String topic, String status) {
        String[] stringArray;
        if (StringUtils.isBlank((CharSequence)topic)) {
            String[] stringArray2;
            if (this.exposeTopicLevelMetrics) {
                String[] stringArray3 = new String[3];
                stringArray3[0] = UNKNOWN;
                stringArray3[1] = UNKNOWN;
                stringArray2 = stringArray3;
                stringArray3[2] = status;
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = UNKNOWN;
                stringArray2 = stringArray4;
                stringArray4[1] = status;
            }
            return stringArray2;
        }
        String namespace = this.getNamespace(topic);
        if (this.exposeTopicLevelMetrics) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = namespace;
            stringArray5[1] = topic;
            stringArray = stringArray5;
            stringArray5[2] = status;
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = namespace;
            stringArray = stringArray6;
            stringArray6[1] = status;
        }
        return stringArray;
    }

    private String[] labelValues(String topic) {
        String[] stringArray;
        if (StringUtils.isBlank((CharSequence)topic)) {
            String[] stringArray2;
            if (this.exposeTopicLevelMetrics) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = UNKNOWN;
                stringArray2 = stringArray3;
                stringArray3[1] = UNKNOWN;
            } else {
                String[] stringArray4 = new String[1];
                stringArray2 = stringArray4;
                stringArray4[0] = UNKNOWN;
            }
            return stringArray2;
        }
        String namespace = this.getNamespace(topic);
        if (this.exposeTopicLevelMetrics) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = namespace;
            stringArray = stringArray5;
            stringArray5[1] = topic;
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = namespace;
        }
        return stringArray;
    }

    private String getNamespace(String topic) {
        return this.topic2Namespace.computeIfAbsent(topic, t -> {
            try {
                return TopicName.get((String)t).getNamespace();
            }
            catch (IllegalArgumentException ex) {
                return UNKNOWN;
            }
        });
    }

    private void cleanExpiredTopicMetrics() {
        long now = System.currentTimeMillis();
        long timeout = TimeUnit.MINUTES.toMillis(2L);
        this.topicAccess.entrySet().removeIf(entry -> {
            String topic = (String)entry.getKey();
            long access = (Long)entry.getValue();
            if (now - access >= timeout) {
                this.topic2Namespace.remove(topic);
                this.offloadAndReadOffloadBytesMap.remove(topic);
                String[] labelValues = this.labelValues(topic);
                this.offloadError.remove(labelValues);
                this.offloadRate.remove(labelValues);
                this.readLedgerLatency.remove(labelValues);
                this.writeStorageError.remove(labelValues);
                this.readOffloadError.remove(labelValues);
                this.readOffloadRate.remove(labelValues);
                this.readOffloadIndexLatency.remove(labelValues);
                this.readOffloadDataLatency.remove(labelValues);
                labelValues = this.labelValues(topic, SUCCEED);
                this.deleteOffloadOps.remove(labelValues);
                labelValues = this.labelValues(topic, FAILED);
                this.deleteOffloadOps.remove(labelValues);
                return true;
            }
            return false;
        });
    }

    @Override
    public void run() {
        this.cleanExpiredTopicMetrics();
        this.offloadAndReadOffloadBytesMap.forEach((topic, pair) -> {
            String[] labelValues = this.labelValues((String)topic);
            double interval = this.interval;
            long offloadBytes = ((LongAdder)pair.getLeft()).sumThenReset();
            long readOffloadBytes = ((LongAdder)pair.getRight()).sumThenReset();
            ((Gauge.Child)this.offloadRate.labels(labelValues)).set((double)offloadBytes / interval);
            ((Gauge.Child)this.readOffloadRate.labels(labelValues)).set((double)readOffloadBytes / interval);
        });
    }

    @Override
    public void close() throws Exception {
        if (instance == this && this.closed.compareAndSet(false, true)) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.offloadError);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.offloadRate);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.readLedgerLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.writeStorageError);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.readOffloadError);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.readOffloadRate);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.readOffloadIndexLatency);
            CollectorRegistry.defaultRegistry.unregister((Collector)this.readOffloadDataLatency);
            this.topic2Namespace.clear();
            this.offloadAndReadOffloadBytesMap.clear();
        }
    }

    @VisibleForTesting
    public long getOffloadBytes(String topic) {
        if (this.exposeTopicLevelMetrics) {
            Pair<LongAdder, LongAdder> pair = this.offloadAndReadOffloadBytesMap.get(topic);
            return ((LongAdder)pair.getLeft()).sum();
        }
        String namespace = this.topic2Namespace.get(topic);
        List topics = this.offloadAndReadOffloadBytesMap.keySet().stream().filter(topicName -> topicName.contains(namespace)).collect(Collectors.toList());
        long totalBytes = 0L;
        for (String key : topics) {
            totalBytes += ((LongAdder)this.offloadAndReadOffloadBytesMap.get(key).getLeft()).sum();
        }
        return totalBytes;
    }

    @VisibleForTesting
    public long getOffloadError(String topic) {
        String[] labels = this.labelValues(topic);
        return (long)((Counter.Child)this.offloadError.labels(labels)).get();
    }

    @VisibleForTesting
    public long getWriteStorageError(String topic) {
        String[] labels = this.labelValues(topic);
        return (long)((Counter.Child)this.writeStorageError.labels(labels)).get();
    }

    @VisibleForTesting
    public long getReadOffloadError(String topic) {
        String[] labels = this.labelValues(topic);
        return (long)((Counter.Child)this.readOffloadError.labels(labels)).get();
    }

    @VisibleForTesting
    public long getReadOffloadBytes(String topic) {
        if (this.exposeTopicLevelMetrics) {
            Pair<LongAdder, LongAdder> pair = this.offloadAndReadOffloadBytesMap.get(topic);
            return ((LongAdder)pair.getRight()).sum();
        }
        String namespace = this.topic2Namespace.get(topic);
        List topics = this.offloadAndReadOffloadBytesMap.keySet().stream().filter(topicName -> topicName.contains(namespace)).collect(Collectors.toList());
        long totalBytes = 0L;
        for (String key : topics) {
            totalBytes += ((LongAdder)this.offloadAndReadOffloadBytesMap.get(key).getRight()).sum();
        }
        return totalBytes;
    }

    @VisibleForTesting
    public Summary.Child.Value getReadLedgerLatency(String topic) {
        String[] labels = this.labelValues(topic);
        return ((Summary.Child)this.readLedgerLatency.labels(labels)).get();
    }

    @VisibleForTesting
    public Summary.Child.Value getReadOffloadIndexLatency(String topic) {
        String[] labels = this.labelValues(topic);
        return ((Summary.Child)this.readOffloadIndexLatency.labels(labels)).get();
    }

    @VisibleForTesting
    public Summary.Child.Value getReadOffloadDataLatency(String topic) {
        String[] labels = this.labelValues(topic);
        return ((Summary.Child)this.readOffloadDataLatency.labels(labels)).get();
    }
}

