/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonBinder;
import io.prestosql.decoder.DecoderModule;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.pulsar.sql.presto.PulsarConnector;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarConnectorId;
import org.apache.pulsar.sql.presto.PulsarDispatchingRowDecoderFactory;
import org.apache.pulsar.sql.presto.PulsarMetadata;
import org.apache.pulsar.sql.presto.PulsarRecordSetProvider;
import org.apache.pulsar.sql.presto.PulsarSplitManager;

public class PulsarConnectorModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;

    public PulsarConnectorModule(String connectorId, TypeManager typeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(PulsarConnector.class).in(Scopes.SINGLETON);
        binder.bind(PulsarConnectorId.class).toInstance((Object)new PulsarConnectorId(this.connectorId));
        binder.bind(PulsarMetadata.class).in(Scopes.SINGLETON);
        binder.bind(PulsarSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(PulsarRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(PulsarDispatchingRowDecoderFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PulsarConnectorConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        binder.install((Module)new DecoderModule());
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeId.of((String)value));
        }
    }
}

