/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

public class PositionImpl
implements Position,
Comparable<PositionImpl> {
    protected long ledgerId;
    protected long entryId;
    protected long[] ackSet;
    public static final PositionImpl EARLIEST = new PositionImpl(-1L, -1L);
    public static final PositionImpl LATEST = new PositionImpl(Long.MAX_VALUE, Long.MAX_VALUE);

    public PositionImpl(MLDataFormats.PositionInfo pi) {
        this.ledgerId = pi.getLedgerId();
        this.entryId = pi.getEntryId();
    }

    public PositionImpl(MLDataFormats.NestedPositionInfo npi) {
        this.ledgerId = npi.getLedgerId();
        this.entryId = npi.getEntryId();
    }

    public PositionImpl(long ledgerId, long entryId) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
    }

    public PositionImpl(long ledgerId, long entryId, long[] ackSet) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.ackSet = ackSet;
    }

    public PositionImpl(PositionImpl other) {
        this.ledgerId = other.ledgerId;
        this.entryId = other.entryId;
    }

    public static PositionImpl get(long ledgerId, long entryId) {
        return new PositionImpl(ledgerId, entryId);
    }

    public static PositionImpl get(long ledgerId, long entryId, long[] ackSet) {
        return new PositionImpl(ledgerId, entryId, ackSet);
    }

    public static PositionImpl get(PositionImpl other) {
        return new PositionImpl(other);
    }

    public long[] getAckSet() {
        return this.ackSet;
    }

    public void setAckSet(long[] ackSet) {
        this.ackSet = ackSet;
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public PositionImpl getNext() {
        if (this.entryId < 0L) {
            return PositionImpl.get(this.ledgerId, 0L);
        }
        return PositionImpl.get(this.ledgerId, this.entryId + 1L);
    }

    public String toString() {
        return this.ledgerId + ":" + this.entryId;
    }

    @Override
    public int compareTo(PositionImpl that) {
        if (this.ledgerId != that.ledgerId) {
            return this.ledgerId < that.ledgerId ? -1 : 1;
        }
        if (this.entryId != that.entryId) {
            return this.entryId < that.entryId ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = (int)(this.ledgerId ^ this.ledgerId >>> 32);
        result = 31 * result + (int)(this.entryId ^ this.entryId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PositionImpl) {
            PositionImpl other = (PositionImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId;
        }
        return false;
    }

    public boolean hasAckSet() {
        return this.ackSet != null;
    }

    public MLDataFormats.PositionInfo getPositionInfo() {
        return MLDataFormats.PositionInfo.newBuilder().setLedgerId(this.ledgerId).setEntryId(this.entryId).build();
    }
}

