/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.TableViewBuilder;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.api.transaction.TransactionBuilder;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.impl.BinaryProtoLookupService;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.ConnectionPool;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerBuilderImpl;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.HttpLookupService;
import org.apache.pulsar.client.impl.LookupService;
import org.apache.pulsar.client.impl.MemoryLimitController;
import org.apache.pulsar.client.impl.MultiTopicsConsumerImpl;
import org.apache.pulsar.client.impl.MultiTopicsReaderImpl;
import org.apache.pulsar.client.impl.PartitionedProducerImpl;
import org.apache.pulsar.client.impl.PatternMultiTopicsConsumerImpl;
import org.apache.pulsar.client.impl.ProducerBase;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.ProducerInterceptors;
import org.apache.pulsar.client.impl.ReaderBuilderImpl;
import org.apache.pulsar.client.impl.ReaderImpl;
import org.apache.pulsar.client.impl.TableViewBuilderImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.client.impl.schema.AutoProduceBytesSchema;
import org.apache.pulsar.client.impl.schema.generic.MultiVersionSchemaInfoProvider;
import org.apache.pulsar.client.impl.transaction.TransactionBuilderImpl;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClientImpl
implements PulsarClient {
    private static final Logger log = LoggerFactory.getLogger(PulsarClientImpl.class);
    private static final int CLOSE_TIMEOUT_SECONDS = 60;
    protected final ClientConfigurationData conf;
    private final boolean createdExecutorProviders;
    private LookupService lookup;
    private final ConnectionPool cnxPool;
    private final Timer timer;
    private boolean needStopTimer;
    private final ExecutorProvider externalExecutorProvider;
    private final ExecutorProvider internalExecutorProvider;
    private final boolean createdEventLoopGroup;
    private final boolean createdCnxPool;
    private final AtomicReference<State> state = new AtomicReference();
    private final Set<ProducerBase<?>> producers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<ConsumerBase<?>> consumers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicLong producerIdGenerator = new AtomicLong();
    private final AtomicLong consumerIdGenerator = new AtomicLong();
    private final AtomicLong requestIdGenerator = new AtomicLong(ThreadLocalRandom.current().nextLong(0L, 0x3FFFFFFFFFFFFFFFL));
    protected final EventLoopGroup eventLoopGroup;
    private final MemoryLimitController memoryLimitController;
    private final LoadingCache<String, SchemaInfoProvider> schemaProviderLoadingCache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, SchemaInfoProvider>(){

        public SchemaInfoProvider load(String topicName) {
            return PulsarClientImpl.this.newSchemaProvider(topicName);
        }
    });
    private final Clock clientClock;
    private TransactionCoordinatorClientImpl tcClient;

    public PulsarClientImpl(ClientConfigurationData conf) throws PulsarClientException {
        this(conf, null, null, null, null, null);
    }

    public PulsarClientImpl(ClientConfigurationData conf, EventLoopGroup eventLoopGroup) throws PulsarClientException {
        this(conf, eventLoopGroup, null, null, null, null);
    }

    public PulsarClientImpl(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, ConnectionPool cnxPool) throws PulsarClientException {
        this(conf, eventLoopGroup, cnxPool, null, null, null);
    }

    public PulsarClientImpl(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, ConnectionPool cnxPool, Timer timer) throws PulsarClientException {
        this(conf, eventLoopGroup, cnxPool, timer, null, null);
    }

    private PulsarClientImpl(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, ConnectionPool connectionPool, Timer timer, ExecutorProvider externalExecutorProvider, ExecutorProvider internalExecutorProvider) throws PulsarClientException {
        EventLoopGroup eventLoopGroupReference = null;
        ConnectionPool connectionPoolReference = null;
        try {
            this.createdEventLoopGroup = eventLoopGroup == null;
            this.createdCnxPool = connectionPool == null;
            if (externalExecutorProvider == null != (internalExecutorProvider == null)) {
                throw new IllegalArgumentException("Both externalExecutorProvider and internalExecutorProvider must be specified or unspecified.");
            }
            this.createdExecutorProviders = externalExecutorProvider == null;
            this.eventLoopGroup = eventLoopGroupReference = eventLoopGroup != null ? eventLoopGroup : PulsarClientImpl.getEventLoopGroup(conf);
            if (conf == null || StringUtils.isBlank((CharSequence)conf.getServiceUrl()) || this.eventLoopGroup == null) {
                throw new PulsarClientException.InvalidConfigurationException("Invalid client configuration");
            }
            this.setAuth(conf);
            this.conf = conf;
            this.clientClock = conf.getClock();
            conf.getAuthentication().start();
            this.cnxPool = connectionPoolReference = connectionPool != null ? connectionPool : new ConnectionPool(conf, this.eventLoopGroup);
            this.externalExecutorProvider = externalExecutorProvider != null ? externalExecutorProvider : new ExecutorProvider(conf.getNumListenerThreads(), "pulsar-external-listener");
            this.internalExecutorProvider = internalExecutorProvider != null ? internalExecutorProvider : new ExecutorProvider(conf.getNumIoThreads(), "pulsar-client-internal");
            this.lookup = conf.getServiceUrl().startsWith("http") ? new HttpLookupService(conf, this.eventLoopGroup) : new BinaryProtoLookupService(this, conf.getServiceUrl(), conf.getListenerName(), conf.isUseTls(), this.externalExecutorProvider.getExecutor());
            if (timer == null) {
                this.timer = new HashedWheelTimer(PulsarClientImpl.getThreadFactory("pulsar-timer"), 1L, TimeUnit.MILLISECONDS);
                this.needStopTimer = true;
            } else {
                this.timer = timer;
            }
            if (conf.isEnableTransaction()) {
                this.tcClient = new TransactionCoordinatorClientImpl(this);
                try {
                    this.tcClient.start();
                }
                catch (Throwable e) {
                    log.error("Start transactionCoordinatorClient error.", e);
                    throw new PulsarClientException(e);
                }
            }
            this.memoryLimitController = new MemoryLimitController(conf.getMemoryLimitBytes());
            this.state.set(State.Open);
        }
        catch (Throwable t) {
            this.shutdown();
            this.shutdownEventLoopGroup(eventLoopGroupReference);
            this.closeCnxPool(connectionPoolReference);
            throw t;
        }
    }

    private void setAuth(ClientConfigurationData conf) throws PulsarClientException {
        if (StringUtils.isBlank((CharSequence)conf.getAuthPluginClassName()) || StringUtils.isBlank((CharSequence)conf.getAuthParams()) && conf.getAuthParamMap() == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)conf.getAuthParams())) {
            conf.setAuthentication(AuthenticationFactory.create((String)conf.getAuthPluginClassName(), (String)conf.getAuthParams()));
        } else if (conf.getAuthParamMap() != null) {
            conf.setAuthentication(AuthenticationFactory.create((String)conf.getAuthPluginClassName(), conf.getAuthParamMap()));
        }
    }

    public ClientConfigurationData getConfiguration() {
        return this.conf;
    }

    public Clock getClientClock() {
        return this.clientClock;
    }

    public AtomicReference<State> getState() {
        return this.state;
    }

    public ProducerBuilder<byte[]> newProducer() {
        return new ProducerBuilderImpl<byte[]>(this, Schema.BYTES);
    }

    public <T> ProducerBuilder<T> newProducer(Schema<T> schema) {
        return new ProducerBuilderImpl<T>(this, schema);
    }

    public ConsumerBuilder<byte[]> newConsumer() {
        return new ConsumerBuilderImpl<byte[]>(this, Schema.BYTES);
    }

    public <T> ConsumerBuilder<T> newConsumer(Schema<T> schema) {
        return new ConsumerBuilderImpl<T>(this, schema);
    }

    public ReaderBuilder<byte[]> newReader() {
        return new ReaderBuilderImpl<byte[]>(this, Schema.BYTES);
    }

    public <T> ReaderBuilder<T> newReader(Schema<T> schema) {
        return new ReaderBuilderImpl<T>(this, schema);
    }

    public <T> TableViewBuilder<T> newTableViewBuilder(Schema<T> schema) {
        return new TableViewBuilderImpl<T>(this, schema);
    }

    public CompletableFuture<Producer<byte[]>> createProducerAsync(ProducerConfigurationData conf) {
        return this.createProducerAsync(conf, Schema.BYTES, null);
    }

    public <T> CompletableFuture<Producer<T>> createProducerAsync(ProducerConfigurationData conf, Schema<T> schema) {
        return this.createProducerAsync(conf, schema, null);
    }

    public <T> CompletableFuture<Producer<T>> createProducerAsync(ProducerConfigurationData conf, Schema<T> schema, ProducerInterceptors interceptors) {
        if (conf == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Producer configuration undefined"));
        }
        if (schema instanceof AutoConsumeSchema) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("AutoConsumeSchema is only used by consumers to detect schemas automatically"));
        }
        if (this.state.get() != State.Open) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Client already closed : state = " + (Object)((Object)this.state.get())));
        }
        String topic = conf.getTopicName();
        if (!TopicName.isValid((String)topic)) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidTopicNameException("Invalid topic name: '" + topic + "'"));
        }
        if (schema instanceof AutoProduceBytesSchema) {
            AutoProduceBytesSchema autoProduceBytesSchema = (AutoProduceBytesSchema)schema;
            if (autoProduceBytesSchema.schemaInitialized()) {
                return this.createProducerAsync(topic, conf, schema, interceptors);
            }
            return this.lookup.getSchema(TopicName.get((String)conf.getTopicName())).thenCompose(schemaInfoOptional -> {
                if (schemaInfoOptional.isPresent()) {
                    autoProduceBytesSchema.setSchema(Schema.getSchema((SchemaInfo)((SchemaInfo)schemaInfoOptional.get())));
                } else {
                    autoProduceBytesSchema.setSchema(Schema.BYTES);
                }
                return this.createProducerAsync(topic, conf, schema, interceptors);
            });
        }
        return this.createProducerAsync(topic, conf, schema, interceptors);
    }

    private <T> CompletableFuture<Producer<T>> createProducerAsync(String topic, ProducerConfigurationData conf, Schema<T> schema, ProducerInterceptors interceptors) {
        CompletableFuture producerCreatedFuture = new CompletableFuture();
        ((CompletableFuture)this.getPartitionedTopicMetadata(topic).thenAccept(metadata -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received topic metadata. partitions: {}", (Object)topic, (Object)metadata.partitions);
            }
            ProducerBase producer = metadata.partitions > 0 ? this.newPartitionedProducerImpl(topic, conf, schema, interceptors, producerCreatedFuture, (PartitionedTopicMetadata)metadata) : this.newProducerImpl(topic, -1, conf, schema, interceptors, producerCreatedFuture, Optional.empty());
            this.producers.add(producer);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to get partitioned topic metadata: {}", (Object)topic, (Object)ex.getMessage());
            producerCreatedFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return producerCreatedFuture;
    }

    protected <T> PartitionedProducerImpl<T> newPartitionedProducerImpl(String topic, ProducerConfigurationData conf, Schema<T> schema, ProducerInterceptors interceptors, CompletableFuture<Producer<T>> producerCreatedFuture, PartitionedTopicMetadata metadata) {
        return new PartitionedProducerImpl<T>(this, topic, conf, metadata.partitions, producerCreatedFuture, schema, interceptors);
    }

    protected <T> ProducerImpl<T> newProducerImpl(String topic, int partitionIndex, ProducerConfigurationData conf, Schema<T> schema, ProducerInterceptors interceptors, CompletableFuture<Producer<T>> producerCreatedFuture, Optional<String> overrideProducerName) {
        return new ProducerImpl<T>(this, topic, conf, producerCreatedFuture, partitionIndex, schema, interceptors, overrideProducerName);
    }

    public CompletableFuture<Consumer<byte[]>> subscribeAsync(ConsumerConfigurationData<byte[]> conf) {
        return this.subscribeAsync(conf, Schema.BYTES, null);
    }

    public <T> CompletableFuture<Consumer<T>> subscribeAsync(ConsumerConfigurationData<T> conf, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        if (this.state.get() != State.Open) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Client already closed"));
        }
        if (conf == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Consumer configuration undefined"));
        }
        for (String topic2 : conf.getTopicNames()) {
            if (TopicName.isValid((String)topic2)) continue;
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidTopicNameException("Invalid topic name: '" + topic2 + "'"));
        }
        if (StringUtils.isBlank((CharSequence)conf.getSubscriptionName())) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Empty subscription name"));
        }
        if (conf.isReadCompacted() && (!conf.getTopicNames().stream().allMatch(topic -> TopicName.get((String)topic).getDomain() == TopicDomain.persistent) || conf.getSubscriptionType() != SubscriptionType.Exclusive && conf.getSubscriptionType() != SubscriptionType.Failover)) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Read compacted can only be used with exclusive or failover persistent subscriptions"));
        }
        if (conf.getConsumerEventListener() != null && conf.getSubscriptionType() != SubscriptionType.Failover) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Active consumer listener is only supported for failover subscription"));
        }
        if (conf.getTopicsPattern() != null) {
            if (!conf.getTopicNames().isEmpty()) {
                return FutureUtil.failedFuture((Throwable)new IllegalArgumentException("Topic names list must be null when use topicsPattern"));
            }
            return this.patternTopicSubscribeAsync(conf, schema, interceptors);
        }
        if (conf.getTopicNames().size() == 1) {
            return this.singleTopicSubscribeAsync(conf, schema, interceptors);
        }
        return this.multiTopicSubscribeAsync(conf, schema, interceptors);
    }

    private <T> CompletableFuture<Consumer<T>> singleTopicSubscribeAsync(ConsumerConfigurationData<T> conf, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        return this.preProcessSchemaBeforeSubscribe(this, schema, conf.getSingleTopic()).thenCompose(schemaClone -> this.doSingleTopicSubscribeAsync(conf, (Schema)schemaClone, interceptors));
    }

    private <T> CompletableFuture<Consumer<T>> doSingleTopicSubscribeAsync(ConsumerConfigurationData<T> conf, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        CompletableFuture consumerSubscribedFuture = new CompletableFuture();
        String topic = conf.getSingleTopic();
        ((CompletableFuture)this.getPartitionedTopicMetadata(topic).thenAccept(metadata -> {
            ConsumerBase consumer;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received topic metadata. partitions: {}", (Object)topic, (Object)metadata.partitions);
            }
            if (metadata.partitions > 0) {
                consumer = MultiTopicsConsumerImpl.createPartitionedConsumer(this, conf, this.externalExecutorProvider, consumerSubscribedFuture, metadata.partitions, schema, interceptors);
            } else {
                int partitionIndex = TopicName.getPartitionIndex((String)topic);
                consumer = ConsumerImpl.newConsumerImpl(this, topic, conf, this.externalExecutorProvider, partitionIndex, false, consumerSubscribedFuture, null, schema, interceptors, true);
            }
            this.consumers.add(consumer);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to get partitioned topic metadata", (Object)topic, ex);
            consumerSubscribedFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return consumerSubscribedFuture;
    }

    private <T> CompletableFuture<Consumer<T>> multiTopicSubscribeAsync(ConsumerConfigurationData<T> conf, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        CompletableFuture consumerSubscribedFuture = new CompletableFuture();
        MultiTopicsConsumerImpl<T> consumer = new MultiTopicsConsumerImpl<T>(this, conf, this.externalExecutorProvider, consumerSubscribedFuture, schema, interceptors, true);
        this.consumers.add(consumer);
        return consumerSubscribedFuture;
    }

    public CompletableFuture<Consumer<byte[]>> patternTopicSubscribeAsync(ConsumerConfigurationData<byte[]> conf) {
        return this.patternTopicSubscribeAsync(conf, Schema.BYTES, null);
    }

    private <T> CompletableFuture<Consumer<T>> patternTopicSubscribeAsync(ConsumerConfigurationData<T> conf, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        String regex = conf.getTopicsPattern().pattern();
        CommandGetTopicsOfNamespace.Mode subscriptionMode = PulsarClientImpl.convertRegexSubscriptionMode(conf.getRegexSubscriptionMode());
        TopicName destination = TopicName.get((String)regex);
        NamespaceName namespaceName = destination.getNamespaceObject();
        CompletableFuture consumerSubscribedFuture = new CompletableFuture();
        ((CompletableFuture)this.lookup.getTopicsUnderNamespace(namespaceName, subscriptionMode).thenAccept(topics -> {
            if (log.isDebugEnabled()) {
                log.debug("Get topics under namespace {}, topics.size: {}", (Object)namespaceName, (Object)topics.size());
                topics.forEach(topicName -> log.debug("Get topics under namespace {}, topic: {}", (Object)namespaceName, topicName));
            }
            List<String> topicsList = PulsarClientImpl.topicsPatternFilter(topics, conf.getTopicsPattern());
            conf.getTopicNames().addAll(topicsList);
            PatternMultiTopicsConsumerImpl consumer = new PatternMultiTopicsConsumerImpl(conf.getTopicsPattern(), this, conf, this.externalExecutorProvider, consumerSubscribedFuture, schema, subscriptionMode, interceptors);
            this.consumers.add(consumer);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to get topics under namespace", (Object)namespaceName);
            consumerSubscribedFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return consumerSubscribedFuture;
    }

    public static List<String> topicsPatternFilter(List<String> original, Pattern topicsPattern) {
        Pattern shortenedTopicsPattern = topicsPattern.toString().contains("://") ? Pattern.compile(topicsPattern.toString().split("\\:\\/\\/")[1]) : topicsPattern;
        return original.stream().map(TopicName::get).map(TopicName::toString).filter(topic -> shortenedTopicsPattern.matcher(topic.split("\\:\\/\\/")[1]).matches()).collect(Collectors.toList());
    }

    public CompletableFuture<Reader<byte[]>> createReaderAsync(ReaderConfigurationData<byte[]> conf) {
        return this.createReaderAsync(conf, Schema.BYTES);
    }

    public <T> CompletableFuture<Reader<T>> createReaderAsync(ReaderConfigurationData<T> conf, Schema<T> schema) {
        if (this.state.get() != State.Open) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Client already closed"));
        }
        if (conf == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Consumer configuration undefined"));
        }
        for (String topic : conf.getTopicNames()) {
            if (TopicName.isValid((String)topic)) continue;
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidTopicNameException("Invalid topic name: '" + topic + "'"));
        }
        if (conf.getStartMessageId() == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException("Invalid startMessageId"));
        }
        if (conf.getTopicNames().size() == 1) {
            return this.preProcessSchemaBeforeSubscribe(this, schema, conf.getTopicName()).thenCompose(schemaClone -> this.createSingleTopicReaderAsync(conf, (Schema)schemaClone));
        }
        return this.createMultiTopicReaderAsync(conf, schema);
    }

    protected <T> CompletableFuture<Reader<T>> createMultiTopicReaderAsync(ReaderConfigurationData<T> conf, Schema<T> schema) {
        CompletableFuture readerFuture = new CompletableFuture();
        CompletableFuture consumerSubscribedFuture = new CompletableFuture();
        MultiTopicsReaderImpl reader = new MultiTopicsReaderImpl(this, conf, this.externalExecutorProvider, consumerSubscribedFuture, schema);
        MultiTopicsConsumerImpl<T> consumer = reader.getMultiTopicsConsumer();
        this.consumers.add(consumer);
        ((CompletableFuture)consumerSubscribedFuture.thenRun(() -> readerFuture.complete(reader))).exceptionally(ex -> {
            log.warn("Failed to create multiTopicReader", ex);
            readerFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return readerFuture;
    }

    protected <T> CompletableFuture<Reader<T>> createSingleTopicReaderAsync(ReaderConfigurationData<T> conf, Schema<T> schema) {
        String topic = conf.getTopicName();
        CompletableFuture readerFuture = new CompletableFuture();
        ((CompletableFuture)this.getPartitionedTopicMetadata(topic).thenAccept(metadata -> {
            ConsumerBase consumer;
            Object reader;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received topic metadata. partitions: {}", (Object)topic, (Object)metadata.partitions);
            }
            if (metadata.partitions > 0 && MultiTopicsConsumerImpl.isIllegalMultiTopicsMessageId(conf.getStartMessageId())) {
                readerFuture.completeExceptionally(new PulsarClientException("The partitioned topic startMessageId is illegal"));
                return;
            }
            CompletableFuture consumerSubscribedFuture = new CompletableFuture();
            if (metadata.partitions > 0) {
                reader = new MultiTopicsReaderImpl(this, conf, this.externalExecutorProvider, consumerSubscribedFuture, schema);
                consumer = ((MultiTopicsReaderImpl)reader).getMultiTopicsConsumer();
            } else {
                reader = new ReaderImpl(this, conf, this.externalExecutorProvider, consumerSubscribedFuture, schema);
                consumer = ((ReaderImpl)reader).getConsumer();
            }
            this.consumers.add(consumer);
            ((CompletableFuture)consumerSubscribedFuture.thenRun(() -> PulsarClientImpl.lambda$null$14(readerFuture, (Reader)reader))).exceptionally(ex -> {
                log.warn("[{}] Failed to get create topic reader", (Object)topic, ex);
                readerFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to get partitioned topic metadata", (Object)topic, ex);
            readerFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return readerFuture;
    }

    public CompletableFuture<Optional<SchemaInfo>> getSchema(String topic) {
        TopicName topicName;
        try {
            topicName = TopicName.get((String)topic);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidTopicNameException("Invalid topic name: '" + topic + "'"));
        }
        return this.lookup.getSchema(topicName);
    }

    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw PulsarClientException.unwrap((Throwable)e);
        }
        catch (ExecutionException e) {
            PulsarClientException unwrapped = PulsarClientException.unwrap((Throwable)e);
            if (unwrapped instanceof PulsarClientException.AlreadyClosedException) {
                return;
            }
            throw unwrapped;
        }
    }

    public CompletableFuture<Void> closeAsync() {
        log.info("Client closing. URL: {}", (Object)this.lookup.getServiceUrl());
        if (!this.state.compareAndSet(State.Open, State.Closing)) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Client already closed"));
        }
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        ArrayList futures = new ArrayList();
        this.producers.forEach(p -> futures.add(p.closeAsync().handle((__, t) -> {
            if (t != null) {
                log.error("Error closing producer {}", p, t);
            }
            return null;
        })));
        this.consumers.forEach(c -> futures.add(c.closeAsync().handle((__, t) -> {
            if (t != null) {
                log.error("Error closing consumer {}", c, t);
            }
            return null;
        })));
        CompletableFuture combinedFuture = FutureUtil.waitForAll(futures);
        ScheduledExecutorService shutdownExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-client-shutdown-timeout-scheduler"));
        FutureUtil.addTimeoutHandling((CompletableFuture)combinedFuture, (Duration)Duration.ofSeconds(60L), (ScheduledExecutorService)shutdownExecutor, () -> FutureUtil.createTimeoutException((String)"Closing producers and consumers timed out.", PulsarClientImpl.class, (String)"closeAsync"));
        ((CompletableFuture)combinedFuture.whenComplete((__, t) -> new Thread(() -> {
            if (t != null) {
                log.error("Closing producers and consumers failed. Continuing with shutdown.", t);
            }
            shutdownExecutor.shutdownNow();
            try {
                this.shutdown();
                closeFuture.complete(null);
                this.state.set(State.Closed);
            }
            catch (PulsarClientException e) {
                closeFuture.completeExceptionally(e);
            }
        }, "pulsar-client-shutdown-thread").start())).exceptionally(exception -> {
            closeFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return closeFuture;
    }

    public void shutdown() throws PulsarClientException {
        try {
            Throwable throwable = null;
            if (this.lookup != null) {
                try {
                    this.lookup.close();
                }
                catch (Throwable t) {
                    log.warn("Failed to shutdown lookup", t);
                    throwable = t;
                }
            }
            if (this.tcClient != null) {
                try {
                    this.tcClient.close();
                }
                catch (Throwable t) {
                    log.warn("Failed to close tcClient");
                    throwable = t;
                }
            }
            if (this.conf != null && this.conf.getServiceUrlProvider() != null) {
                this.conf.getServiceUrlProvider().close();
            }
            try {
                this.shutdownEventLoopGroup(this.eventLoopGroup);
            }
            catch (PulsarClientException e) {
                log.warn("Failed to shutdown eventLoopGroup", (Throwable)e);
                throwable = e;
            }
            try {
                this.closeCnxPool(this.cnxPool);
            }
            catch (PulsarClientException e) {
                log.warn("Failed to shutdown cnxPool", (Throwable)e);
                throwable = e;
            }
            if (this.timer != null && this.needStopTimer) {
                try {
                    this.timer.stop();
                }
                catch (Throwable t) {
                    log.warn("Failed to shutdown timer", t);
                    throwable = t;
                }
            }
            try {
                this.shutdownExecutors();
            }
            catch (PulsarClientException e) {
                throwable = e;
            }
            if (this.conf != null && this.conf.getAuthentication() != null) {
                try {
                    this.conf.getAuthentication().close();
                }
                catch (Throwable t) {
                    log.warn("Failed to close authentication", t);
                    throwable = t;
                }
            }
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (Throwable t) {
            log.warn("Failed to shutdown Pulsar client", t);
            throw PulsarClientException.unwrap((Throwable)t);
        }
    }

    private void closeCnxPool(ConnectionPool cnxPool) throws PulsarClientException {
        if (this.createdCnxPool && cnxPool != null) {
            try {
                cnxPool.close();
            }
            catch (Throwable t) {
                throw PulsarClientException.unwrap((Throwable)t);
            }
        }
    }

    private void shutdownEventLoopGroup(EventLoopGroup eventLoopGroup) throws PulsarClientException {
        if (this.createdEventLoopGroup && eventLoopGroup != null && !eventLoopGroup.isShutdown()) {
            try {
                eventLoopGroup.shutdownGracefully().get(60L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                throw PulsarClientException.unwrap((Throwable)t);
            }
        }
    }

    private void shutdownExecutors() throws PulsarClientException {
        if (this.createdExecutorProviders) {
            PulsarClientException pulsarClientException = null;
            if (this.externalExecutorProvider != null && !this.externalExecutorProvider.isShutdown()) {
                try {
                    this.externalExecutorProvider.shutdownNow();
                }
                catch (Throwable t) {
                    log.warn("Failed to shutdown externalExecutorProvider", t);
                    pulsarClientException = PulsarClientException.unwrap((Throwable)t);
                }
            }
            if (this.internalExecutorProvider != null && !this.internalExecutorProvider.isShutdown()) {
                try {
                    this.internalExecutorProvider.shutdownNow();
                }
                catch (Throwable t) {
                    log.warn("Failed to shutdown internalExecutorService", t);
                    pulsarClientException = PulsarClientException.unwrap((Throwable)t);
                }
            }
            if (pulsarClientException != null) {
                throw pulsarClientException;
            }
        }
    }

    public boolean isClosed() {
        State currentState = this.state.get();
        return currentState == State.Closed || currentState == State.Closing;
    }

    public synchronized void updateServiceUrl(String serviceUrl) throws PulsarClientException {
        log.info("Updating service URL to {}", (Object)serviceUrl);
        this.conf.setServiceUrl(serviceUrl);
        this.lookup.updateServiceUrl(serviceUrl);
        this.cnxPool.closeAllConnections();
    }

    public void updateAuthentication(Authentication authentication) throws IOException {
        log.info("Updating authentication to {}", (Object)authentication);
        if (this.conf.getAuthentication() != null) {
            this.conf.getAuthentication().close();
        }
        this.conf.setAuthentication(authentication);
        this.conf.getAuthentication().start();
    }

    public void updateTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        log.info("Updating tlsTrustCertsFilePath to {}", (Object)tlsTrustCertsFilePath);
        this.conf.setTlsTrustCertsFilePath(tlsTrustCertsFilePath);
    }

    public void updateTlsTrustStorePathAndPassword(String tlsTrustStorePath, String tlsTrustStorePassword) {
        log.info("Updating tlsTrustStorePath to {}, tlsTrustStorePassword to *****", (Object)tlsTrustStorePath);
        this.conf.setTlsTrustStorePath(tlsTrustStorePath);
        this.conf.setTlsTrustStorePassword(tlsTrustStorePassword);
    }

    public CompletableFuture<ClientCnx> getConnection(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        return this.lookup.getBroker(topicName).thenCompose(pair -> this.cnxPool.getConnection((InetSocketAddress)pair.getLeft(), (InetSocketAddress)pair.getRight()));
    }

    public Timer timer() {
        return this.timer;
    }

    public ExecutorProvider externalExecutorProvider() {
        return this.externalExecutorProvider;
    }

    long newProducerId() {
        return this.producerIdGenerator.getAndIncrement();
    }

    long newConsumerId() {
        return this.consumerIdGenerator.getAndIncrement();
    }

    public long newRequestId() {
        return this.requestIdGenerator.getAndIncrement();
    }

    public ConnectionPool getCnxPool() {
        return this.cnxPool;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public LookupService getLookup() {
        return this.lookup;
    }

    public void reloadLookUp() throws PulsarClientException {
        this.lookup = this.conf.getServiceUrl().startsWith("http") ? new HttpLookupService(this.conf, this.eventLoopGroup) : new BinaryProtoLookupService(this, this.conf.getServiceUrl(), this.conf.getListenerName(), this.conf.isUseTls(), this.externalExecutorProvider.getExecutor());
    }

    public CompletableFuture<Integer> getNumberOfPartitions(String topic) {
        return this.getPartitionedTopicMetadata(topic).thenApply(metadata -> metadata.partitions);
    }

    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(String topic) {
        CompletableFuture<PartitionedTopicMetadata> metadataFuture = new CompletableFuture<PartitionedTopicMetadata>();
        try {
            TopicName topicName = TopicName.get((String)topic);
            AtomicLong opTimeoutMs = new AtomicLong(this.conf.getLookupTimeoutMs());
            Backoff backoff = new BackoffBuilder().setInitialTime(this.conf.getInitialBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMandatoryStop(opTimeoutMs.get() * 2L, TimeUnit.MILLISECONDS).setMax(this.conf.getMaxBackoffIntervalNanos(), TimeUnit.NANOSECONDS).create();
            this.getPartitionedTopicMetadata(topicName, backoff, opTimeoutMs, metadataFuture, new ArrayList<Throwable>());
        }
        catch (IllegalArgumentException e) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidConfigurationException(e.getMessage()));
        }
        return metadataFuture;
    }

    private void getPartitionedTopicMetadata(TopicName topicName, Backoff backoff, AtomicLong remainingTime, CompletableFuture<PartitionedTopicMetadata> future, List<Throwable> previousExceptions) {
        long startTime = System.nanoTime();
        ((CompletableFuture)this.lookup.getPartitionedTopicMetadata(topicName).thenAccept(future::complete)).exceptionally(e -> {
            boolean isLookupThrottling;
            remainingTime.addAndGet(-1L * TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            long nextDelay = Math.min(backoff.next(), remainingTime.get());
            boolean bl = isLookupThrottling = !PulsarClientException.isRetriableError((Throwable)e.getCause()) || e.getCause() instanceof PulsarClientException.AuthenticationException;
            if (nextDelay <= 0L || isLookupThrottling) {
                PulsarClientException.setPreviousExceptions((Throwable)e, (Collection)previousExceptions);
                future.completeExceptionally((Throwable)e);
                return null;
            }
            previousExceptions.add((Throwable)e);
            ((ScheduledExecutorService)this.externalExecutorProvider.getExecutor()).schedule(() -> {
                log.warn("[topic: {}] Could not get connection while getPartitionedTopicMetadata -- Will try again in {} ms", (Object)topicName, (Object)nextDelay);
                remainingTime.addAndGet(-nextDelay);
                this.getPartitionedTopicMetadata(topicName, backoff, remainingTime, future, previousExceptions);
            }, nextDelay, TimeUnit.MILLISECONDS);
            return null;
        });
    }

    public CompletableFuture<List<String>> getPartitionsForTopic(String topic) {
        return this.getPartitionedTopicMetadata(topic).thenApply(metadata -> {
            if (metadata.partitions > 0) {
                TopicName topicName = TopicName.get((String)topic);
                ArrayList<String> partitions = new ArrayList<String>(metadata.partitions);
                for (int i = 0; i < metadata.partitions; ++i) {
                    partitions.add(topicName.getPartition(i).toString());
                }
                return partitions;
            }
            return Collections.singletonList(topic);
        });
    }

    private static EventLoopGroup getEventLoopGroup(ClientConfigurationData conf) {
        ThreadFactory threadFactory = PulsarClientImpl.getThreadFactory("pulsar-client-io");
        return EventLoopUtil.newEventLoopGroup((int)conf.getNumIoThreads(), (boolean)conf.isEnableBusyWait(), (ThreadFactory)threadFactory);
    }

    private static ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName, Thread.currentThread().isDaemon());
    }

    void cleanupProducer(ProducerBase<?> producer) {
        this.producers.remove(producer);
    }

    void cleanupConsumer(ConsumerBase<?> consumer) {
        this.consumers.remove(consumer);
    }

    @VisibleForTesting
    int producersCount() {
        return this.producers.size();
    }

    @VisibleForTesting
    int consumersCount() {
        return this.consumers.size();
    }

    private static CommandGetTopicsOfNamespace.Mode convertRegexSubscriptionMode(RegexSubscriptionMode regexSubscriptionMode) {
        switch (regexSubscriptionMode) {
            case PersistentOnly: {
                return CommandGetTopicsOfNamespace.Mode.PERSISTENT;
            }
            case NonPersistentOnly: {
                return CommandGetTopicsOfNamespace.Mode.NON_PERSISTENT;
            }
            case AllTopics: {
                return CommandGetTopicsOfNamespace.Mode.ALL;
            }
        }
        return null;
    }

    private SchemaInfoProvider newSchemaProvider(String topicName) {
        return new MultiVersionSchemaInfoProvider(TopicName.get((String)topicName), this);
    }

    public LoadingCache<String, SchemaInfoProvider> getSchemaProviderLoadingCache() {
        return this.schemaProviderLoadingCache;
    }

    public MemoryLimitController getMemoryLimitController() {
        return this.memoryLimitController;
    }

    protected <T> CompletableFuture<Schema<T>> preProcessSchemaBeforeSubscribe(PulsarClientImpl pulsarClientImpl, Schema<T> schema, String topicName) {
        if (schema != null && schema.supportSchemaVersioning()) {
            SchemaInfoProvider schemaInfoProvider;
            try {
                schemaInfoProvider = (SchemaInfoProvider)pulsarClientImpl.getSchemaProviderLoadingCache().get((Object)topicName);
            }
            catch (ExecutionException e) {
                log.error("Failed to load schema info provider for topic {}", (Object)topicName, (Object)e);
                return FutureUtil.failedFuture((Throwable)e.getCause());
            }
            schema = schema.clone();
            if (schema.requireFetchingSchemaInfo()) {
                Schema finalSchema = schema;
                return schemaInfoProvider.getLatestSchema().thenCompose(schemaInfo -> {
                    if (null == schemaInfo && !(finalSchema instanceof AutoConsumeSchema) && !(finalSchema instanceof KeyValueSchema)) {
                        return FutureUtil.failedFuture((Throwable)new PulsarClientException.NotFoundException("No latest schema found for topic " + topicName));
                    }
                    try {
                        log.info("Configuring schema for topic {} : {}", (Object)topicName, schemaInfo);
                        finalSchema.configureSchemaInfo(topicName, "topic", schemaInfo);
                    }
                    catch (RuntimeException re) {
                        return FutureUtil.failedFuture((Throwable)re);
                    }
                    finalSchema.setSchemaInfoProvider(schemaInfoProvider);
                    return CompletableFuture.completedFuture(finalSchema);
                });
            }
            schema.setSchemaInfoProvider(schemaInfoProvider);
        }
        return CompletableFuture.completedFuture(schema);
    }

    public ExecutorService getInternalExecutorService() {
        return this.internalExecutorProvider.getExecutor();
    }

    public TransactionBuilder newTransaction() throws PulsarClientException {
        if (!this.conf.isEnableTransaction()) {
            throw new PulsarClientException.InvalidConfigurationException("Transactions are not enabled");
        }
        return new TransactionBuilderImpl(this, this.tcClient);
    }

    public static PulsarClientImplBuilder builder() {
        return new PulsarClientImplBuilder();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public TransactionCoordinatorClientImpl getTcClient() {
        return this.tcClient;
    }

    private static /* synthetic */ void lambda$null$14(CompletableFuture readerFuture, Reader reader) {
        readerFuture.complete(reader);
    }

    public static class PulsarClientImplBuilder {
        private ClientConfigurationData conf;
        private EventLoopGroup eventLoopGroup;
        private ConnectionPool connectionPool;
        private Timer timer;
        private ExecutorProvider externalExecutorProvider;
        private ExecutorProvider internalExecutorProvider;

        PulsarClientImplBuilder() {
        }

        public PulsarClientImplBuilder conf(ClientConfigurationData conf) {
            this.conf = conf;
            return this;
        }

        public PulsarClientImplBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public PulsarClientImplBuilder connectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public PulsarClientImplBuilder timer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public PulsarClientImplBuilder externalExecutorProvider(ExecutorProvider externalExecutorProvider) {
            this.externalExecutorProvider = externalExecutorProvider;
            return this;
        }

        public PulsarClientImplBuilder internalExecutorProvider(ExecutorProvider internalExecutorProvider) {
            this.internalExecutorProvider = internalExecutorProvider;
            return this;
        }

        public PulsarClientImpl build() throws PulsarClientException {
            return new PulsarClientImpl(this.conf, this.eventLoopGroup, this.connectionPool, this.timer, this.externalExecutorProvider, this.internalExecutorProvider);
        }

        public String toString() {
            return "PulsarClientImpl.PulsarClientImplBuilder(conf=" + this.conf + ", eventLoopGroup=" + this.eventLoopGroup + ", connectionPool=" + this.connectionPool + ", timer=" + this.timer + ", externalExecutorProvider=" + this.externalExecutorProvider + ", internalExecutorProvider=" + this.internalExecutorProvider + ")";
        }
    }

    public static enum State {
        Open,
        Closing,
        Closed;

    }
}

