/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.NotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;

public class TableNotFoundException
extends NotFoundException {
    private final SchemaTableName tableName;

    public TableNotFoundException(SchemaTableName tableName) {
        this(tableName, String.format("Table '%s' not found", tableName));
    }

    public TableNotFoundException(SchemaTableName tableName, String message) {
        super(message);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public TableNotFoundException(SchemaTableName tableName, Throwable cause) {
        this(tableName, String.format("Table '%s' not found", tableName), cause);
    }

    public TableNotFoundException(SchemaTableName tableName, String message, Throwable cause) {
        super(message, cause);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

