/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessagePayload;
import org.apache.pulsar.client.api.MessagePayloadContext;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.AcknowledgmentsGroupingTracker;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ChunkMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.ConnectionHandler;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.ConsumerStatsDisabled;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.MessagePayloadContextImpl;
import org.apache.pulsar.client.impl.MessagePayloadImpl;
import org.apache.pulsar.client.impl.MessagesImpl;
import org.apache.pulsar.client.impl.NegativeAcksTracker;
import org.apache.pulsar.client.impl.NonPersistentAcknowledgmentGroupingTracker;
import org.apache.pulsar.client.impl.PersistentAcknowledgmentsGroupingTracker;
import org.apache.pulsar.client.impl.ProducerBuilderImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.client.impl.UnAckedMessageRedeliveryTracker;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.ZeroQueueConsumerImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.crypto.MessageCryptoBc;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.CommandMessage;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.EncryptionKeys;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.ProtocolVersion;
import org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.CompletableFutureCancellationHandler;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.common.util.SafeCollectionUtils;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerImpl<T>
extends ConsumerBase<T>
implements ConnectionHandler.Connection {
    private static final int MAX_REDELIVER_UNACKNOWLEDGED = 1000;
    final long consumerId;
    private static final AtomicIntegerFieldUpdater<ConsumerImpl> AVAILABLE_PERMITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConsumerImpl.class, "availablePermits");
    private volatile int availablePermits = 0;
    protected volatile MessageId lastDequeuedMessageId = MessageId.earliest;
    private volatile MessageId lastMessageIdInBroker = MessageId.earliest;
    private final long lookupDeadline;
    private static final AtomicLongFieldUpdater<ConsumerImpl> SUBSCRIBE_DEADLINE_UPDATER = AtomicLongFieldUpdater.newUpdater(ConsumerImpl.class, "subscribeDeadline");
    private volatile long subscribeDeadline = 0L;
    private final int partitionIndex;
    private final boolean hasParentConsumer;
    private final int receiverQueueRefillThreshold;
    private final UnAckedMessageTracker unAckedMessageTracker;
    private final AcknowledgmentsGroupingTracker acknowledgmentsGroupingTracker;
    private final NegativeAcksTracker negativeAcksTracker;
    protected final ConsumerStatsRecorder stats;
    private final int priorityLevel;
    private final SubscriptionMode subscriptionMode;
    private volatile BatchMessageIdImpl startMessageId;
    private volatile BatchMessageIdImpl seekMessageId;
    private final AtomicBoolean duringSeek;
    private final BatchMessageIdImpl initialStartMessageId;
    private final long startMessageRollbackDurationInSec;
    private volatile boolean hasReachedEndOfTopic;
    private final MessageCrypto msgCrypto;
    private final Map<String, String> metadata;
    private final boolean readCompacted;
    private final boolean resetIncludeHead;
    private final SubscriptionInitialPosition subscriptionInitialPosition;
    private final ConnectionHandler connectionHandler;
    private final TopicName topicName;
    private final String topicNameWithoutPartition;
    private final Map<MessageIdImpl, List<MessageImpl<T>>> possibleSendToDeadLetterTopicMessages;
    private final DeadLetterPolicy deadLetterPolicy;
    private volatile CompletableFuture<Producer<byte[]>> deadLetterProducer;
    private volatile Producer<T> retryLetterProducer;
    private final ReadWriteLock createProducerLock = new ReentrantReadWriteLock();
    protected volatile boolean paused;
    protected ConcurrentOpenHashMap<String, ChunkedMessageCtx> chunkedMessagesMap = new ConcurrentOpenHashMap();
    private int pendingChunkedMessageCount = 0;
    protected long expireTimeOfIncompleteChunkedMessageMillis = 0L;
    private boolean expireChunkMessageTaskScheduled = false;
    private final int maxPendingChunkedMessage;
    private final boolean autoAckOldestChunkedMessageOnQueueFull;
    private final BlockingQueue<String> pendingChunkedMessageUuidQueue;
    private final boolean createTopicIfDoesNotExist;
    private final boolean poolMessages;
    private final AtomicReference<ClientCnx> clientCnxUsedForConsumerRegistration = new AtomicReference();
    private final List<Throwable> previousExceptions = new CopyOnWriteArrayList<Throwable>();
    private static final Logger log = LoggerFactory.getLogger(ConsumerImpl.class);

    static <T> ConsumerImpl<T> newConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, int partitionIndex, boolean hasParentConsumer, CompletableFuture<Consumer<T>> subscribeFuture, MessageId startMessageId, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        return ConsumerImpl.newConsumerImpl(client, topic, conf, executorProvider, partitionIndex, hasParentConsumer, subscribeFuture, startMessageId, schema, interceptors, createTopicIfDoesNotExist, 0L);
    }

    static <T> ConsumerImpl<T> newConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, int partitionIndex, boolean hasParentConsumer, CompletableFuture<Consumer<T>> subscribeFuture, MessageId startMessageId, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist, long startMessageRollbackDurationInSec) {
        if (conf.getReceiverQueueSize() == 0) {
            return new ZeroQueueConsumerImpl<T>(client, topic, conf, executorProvider, partitionIndex, hasParentConsumer, subscribeFuture, startMessageId, schema, interceptors, createTopicIfDoesNotExist);
        }
        return new ConsumerImpl<T>(client, topic, conf, executorProvider, partitionIndex, hasParentConsumer, subscribeFuture, startMessageId, startMessageRollbackDurationInSec, schema, interceptors, createTopicIfDoesNotExist);
    }

    protected ConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorProvider executorProvider, int partitionIndex, boolean hasParentConsumer, CompletableFuture<Consumer<T>> subscribeFuture, MessageId startMessageId, long startMessageRollbackDurationInSec, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        super(client, topic, conf, conf.getReceiverQueueSize(), executorProvider, subscribeFuture, schema, interceptors);
        this.consumerId = client.newConsumerId();
        this.subscriptionMode = conf.getSubscriptionMode();
        this.initialStartMessageId = this.startMessageId = startMessageId != null ? new BatchMessageIdImpl((MessageIdImpl)startMessageId) : null;
        this.startMessageRollbackDurationInSec = startMessageRollbackDurationInSec;
        AVAILABLE_PERMITS_UPDATER.set(this, 0);
        this.lookupDeadline = System.currentTimeMillis() + client.getConfiguration().getLookupTimeoutMs();
        this.partitionIndex = partitionIndex;
        this.hasParentConsumer = hasParentConsumer;
        this.receiverQueueRefillThreshold = conf.getReceiverQueueSize() / 2;
        this.priorityLevel = conf.getPriorityLevel();
        this.readCompacted = conf.isReadCompacted();
        this.subscriptionInitialPosition = conf.getSubscriptionInitialPosition();
        this.negativeAcksTracker = new NegativeAcksTracker(this, conf);
        this.resetIncludeHead = conf.isResetIncludeHead();
        this.createTopicIfDoesNotExist = createTopicIfDoesNotExist;
        this.maxPendingChunkedMessage = conf.getMaxPendingChunkedMessage();
        this.pendingChunkedMessageUuidQueue = new GrowableArrayBlockingQueue();
        this.expireTimeOfIncompleteChunkedMessageMillis = conf.getExpireTimeOfIncompleteChunkedMessageMillis();
        this.autoAckOldestChunkedMessageOnQueueFull = conf.isAutoAckOldestChunkedMessageOnQueueFull();
        this.poolMessages = conf.isPoolMessages();
        this.paused = conf.isStartPaused();
        this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl(client, conf, this) : ConsumerStatsDisabled.INSTANCE;
        this.duringSeek = new AtomicBoolean(false);
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? (conf.getAckTimeoutRedeliveryBackoff() != null ? new UnAckedMessageRedeliveryTracker(client, this, conf) : new UnAckedMessageTracker(client, this, conf)) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        if (conf.getCryptoKeyReader() != null) {
            if (conf.getMessageCrypto() != null) {
                this.msgCrypto = conf.getMessageCrypto();
            } else {
                MessageCryptoBc msgCryptoBc;
                try {
                    msgCryptoBc = new MessageCryptoBc(String.format("[%s] [%s]", topic, this.subscription), false);
                }
                catch (Exception e) {
                    log.error("MessageCryptoBc may not included in the jar. e:", (Throwable)e);
                    msgCryptoBc = null;
                }
                this.msgCrypto = msgCryptoBc;
            }
        } else {
            this.msgCrypto = null;
        }
        this.metadata = conf.getProperties().isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(conf.getProperties()));
        this.connectionHandler = new ConnectionHandler(this, new BackoffBuilder().setInitialTime(client.getConfiguration().getInitialBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMax(client.getConfiguration().getMaxBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMandatoryStop(0L, TimeUnit.MILLISECONDS).create(), this);
        this.topicName = TopicName.get((String)topic);
        this.acknowledgmentsGroupingTracker = this.topicName.isPersistent() ? new PersistentAcknowledgmentsGroupingTracker(this, conf, client.eventLoopGroup()) : NonPersistentAcknowledgmentGroupingTracker.of();
        if (conf.getDeadLetterPolicy() != null) {
            this.possibleSendToDeadLetterTopicMessages = new ConcurrentHashMap<MessageIdImpl, List<MessageImpl<T>>>();
            this.deadLetterPolicy = StringUtils.isNotBlank((CharSequence)conf.getDeadLetterPolicy().getDeadLetterTopic()) ? DeadLetterPolicy.builder().maxRedeliverCount(conf.getDeadLetterPolicy().getMaxRedeliverCount()).deadLetterTopic(conf.getDeadLetterPolicy().getDeadLetterTopic()).build() : DeadLetterPolicy.builder().maxRedeliverCount(conf.getDeadLetterPolicy().getMaxRedeliverCount()).deadLetterTopic(String.format("%s-%s-DLQ", topic, this.subscription)).build();
            if (StringUtils.isNotBlank((CharSequence)conf.getDeadLetterPolicy().getRetryLetterTopic())) {
                this.deadLetterPolicy.setRetryLetterTopic(conf.getDeadLetterPolicy().getRetryLetterTopic());
            } else {
                this.deadLetterPolicy.setRetryLetterTopic(String.format("%s-%s-RETRY", topic, this.subscription));
            }
            if (StringUtils.isNotBlank((CharSequence)conf.getDeadLetterPolicy().getInitialSubscriptionName())) {
                this.deadLetterPolicy.setInitialSubscriptionName(conf.getDeadLetterPolicy().getInitialSubscriptionName());
            }
        } else {
            this.deadLetterPolicy = null;
            this.possibleSendToDeadLetterTopicMessages = null;
        }
        this.topicNameWithoutPartition = this.topicName.getPartitionedTopicName();
        this.grabCnx();
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    @Override
    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        if (this.isConnected()) {
            this.setState(HandlerState.State.Closing);
            long requestId = this.client.newRequestId();
            ByteBuf unsubscribe = Commands.newUnsubscribe((long)this.consumerId, (long)requestId);
            ClientCnx cnx = this.cnx();
            ((CompletableFuture)cnx.sendRequestWithId(unsubscribe, requestId).thenRun(() -> {
                this.closeConsumerTasks();
                this.deregisterFromClientCnx();
                this.client.cleanupConsumer(this);
                log.info("[{}][{}] Successfully unsubscribed from topic", (Object)this.topic, (Object)this.subscription);
                this.setState(HandlerState.State.Closed);
                unsubscribeFuture.complete(null);
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed to unsubscribe: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
                this.setState(HandlerState.State.Ready);
                unsubscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("Failed to unsubscribe the subscription %s of topic %s", this.topicName.toString(), this.subscription)));
                return null;
            });
        } else {
            unsubscribeFuture.completeExceptionally(new PulsarClientException(String.format("The client is not connected to the broker when unsubscribing the subscription %s of the topic %s", this.subscription, this.topicName.toString())));
        }
        return unsubscribeFuture;
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.take();
            this.messageProcessed(message);
            if (!this.isValidConsumerEpoch(message)) {
                return this.internalReceive();
            }
            return this.beforeConsume(message);
        }
        catch (InterruptedException e) {
            this.stats.incrementNumReceiveFailed();
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    @Override
    private boolean isValidConsumerEpoch(Message<T> message) {
        return ((ConsumerBase)this).isValidConsumerEpoch((MessageImpl)message);
    }

    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        this.internalPinnedExecutor.execute(() -> {
            Message message = (Message)this.incomingMessages.poll();
            if (message == null) {
                this.pendingReceives.add(result);
                cancellationHandler.setCancelAction(() -> this.pendingReceives.remove(result));
            } else {
                this.messageProcessed(message);
                if (!this.isValidConsumerEpoch(message)) {
                    this.pendingReceives.add(result);
                    cancellationHandler.setCancelAction(() -> this.pendingReceives.remove(result));
                    return;
                }
                result.complete(this.beforeConsume(message));
            }
        });
        return result;
    }

    @Override
    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        long callTime = System.nanoTime();
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            if (message == null) {
                return null;
            }
            this.messageProcessed(message);
            if (!this.isValidConsumerEpoch(message)) {
                long executionTime = System.nanoTime() - callTime;
                if (executionTime >= unit.toNanos(timeout)) {
                    return null;
                }
                return this.internalReceive((int)((long)timeout - executionTime), TimeUnit.NANOSECONDS);
            }
            return this.beforeConsume(message);
        }
        catch (InterruptedException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Messages<T> internalBatchReceive() throws PulsarClientException {
        try {
            return this.internalBatchReceiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumBatchReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected CompletableFuture<Messages<T>> internalBatchReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        this.internalPinnedExecutor.execute(() -> {
            if (this.hasEnoughMessagesForBatchReceive()) {
                MessagesImpl messages = this.getNewMessagesImpl();
                Message msgPeeked = (Message)this.incomingMessages.peek();
                while (msgPeeked != null && messages.canAdd(msgPeeked)) {
                    Message msg = (Message)this.incomingMessages.poll();
                    if (msg != null) {
                        this.messageProcessed(msg);
                        if (!this.isValidConsumerEpoch(msg)) {
                            msgPeeked = (Message)this.incomingMessages.peek();
                            continue;
                        }
                        Message interceptMsg = this.beforeConsume(msg);
                        messages.add(interceptMsg);
                    }
                    msgPeeked = (Message)this.incomingMessages.peek();
                }
                result.complete(messages);
            } else {
                ConsumerBase.OpBatchReceive opBatchReceive = ConsumerBase.OpBatchReceive.of(result);
                this.pendingBatchReceives.add(opBatchReceive);
                cancellationHandler.setCancelAction(() -> this.pendingBatchReceives.remove(opBatchReceive));
            }
        });
        return result;
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txn) {
        Preconditions.checkArgument((boolean)(messageId instanceof MessageIdImpl));
        if (this.getState() != HandlerState.State.Ready && this.getState() != HandlerState.State.Connecting) {
            this.stats.incrementNumAcksFailed();
            PulsarClientException exception = new PulsarClientException("Consumer not ready. State: " + (Object)((Object)this.getState()));
            if (CommandAck.AckType.Individual.equals((Object)ackType)) {
                this.onAcknowledge(messageId, exception);
            } else if (CommandAck.AckType.Cumulative.equals((Object)ackType)) {
                this.onAcknowledgeCumulative(messageId, exception);
            }
            return FutureUtil.failedFuture((Throwable)exception);
        }
        if (txn != null) {
            return this.doTransactionAcknowledgeForResponse(messageId, ackType, null, properties, new TxnID(txn.getTxnIdMostBits(), txn.getTxnIdLeastBits()));
        }
        return this.acknowledgmentsGroupingTracker.addAcknowledgment((MessageIdImpl)messageId, ackType, properties);
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(List<MessageId> messageIdList, CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txn) {
        return this.acknowledgmentsGroupingTracker.addListAcknowledgment(messageIdList, ackType, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Void> doReconsumeLater(Message<?> message, CommandAck.AckType ackType, Map<String, String> customProperties, long delayTime, TimeUnit unit) {
        MessageId messageId = message.getMessageId();
        if (messageId == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.InvalidMessageException("Cannot handle message with null messageId"));
        }
        if (messageId instanceof TopicMessageIdImpl) {
            messageId = ((TopicMessageIdImpl)messageId).getInnerMessageId();
        }
        Preconditions.checkArgument((boolean)(messageId instanceof MessageIdImpl));
        if (this.getState() != HandlerState.State.Ready && this.getState() != HandlerState.State.Connecting) {
            this.stats.incrementNumAcksFailed();
            PulsarClientException exception = new PulsarClientException("Consumer not ready. State: " + (Object)((Object)this.getState()));
            if (CommandAck.AckType.Individual.equals((Object)ackType)) {
                this.onAcknowledge(messageId, exception);
            } else if (CommandAck.AckType.Cumulative.equals((Object)ackType)) {
                this.onAcknowledgeCumulative(messageId, exception);
            }
            return FutureUtil.failedFuture((Throwable)exception);
        }
        if (delayTime < 0L) {
            delayTime = 0L;
        }
        if (this.retryLetterProducer == null) {
            this.createProducerLock.writeLock().lock();
            try {
                if (this.retryLetterProducer == null) {
                    this.retryLetterProducer = this.client.newProducer(this.schema).topic(this.deadLetterPolicy.getRetryLetterTopic()).enableBatching(false).blockIfQueueFull(false).create();
                }
            }
            catch (Exception e) {
                log.error("Create retry letter producer exception with topic: {}", (Object)this.deadLetterPolicy.getRetryLetterTopic(), (Object)e);
            }
            finally {
                this.createProducerLock.writeLock().unlock();
            }
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (this.retryLetterProducer != null) {
            try {
                MessageImpl<?> retryMessage = this.getMessageImpl(message);
                String originMessageIdStr = this.getOriginMessageIdStr(message);
                String originTopicNameStr = this.getOriginTopicNameStr(message);
                SortedMap<String, String> propertiesMap = this.getPropertiesMap(message, originMessageIdStr, originTopicNameStr);
                if (customProperties != null) {
                    propertiesMap.putAll(customProperties);
                }
                int reconsumetimes = 1;
                if (propertiesMap.containsKey("RECONSUMETIMES")) {
                    reconsumetimes = Integer.parseInt((String)propertiesMap.get("RECONSUMETIMES"));
                    ++reconsumetimes;
                }
                propertiesMap.put("RECONSUMETIMES", String.valueOf(reconsumetimes));
                propertiesMap.put("DELAY_TIME", String.valueOf(unit.toMillis(delayTime)));
                MessageId finalMessageId = messageId;
                if (reconsumetimes > this.deadLetterPolicy.getMaxRedeliverCount() && StringUtils.isNotBlank((CharSequence)this.deadLetterPolicy.getDeadLetterTopic())) {
                    this.initDeadLetterProducerIfNeeded();
                    ((CompletableFuture)this.deadLetterProducer.thenAccept(dlqProducer -> {
                        TypedMessageBuilder typedMessageBuilderNew = dlqProducer.newMessage(Schema.AUTO_PRODUCE_BYTES(retryMessage.getReaderSchema().get())).value((Object)retryMessage.getData()).properties((Map)propertiesMap);
                        ((CompletableFuture)typedMessageBuilderNew.sendAsync().thenAccept(msgId -> ((CompletableFuture)this.doAcknowledge(finalMessageId, ackType, Collections.emptyMap(), null).thenAccept(v -> result.complete(null))).exceptionally(ex -> {
                            result.completeExceptionally((Throwable)ex);
                            return null;
                        }))).exceptionally(ex -> {
                            result.completeExceptionally((Throwable)ex);
                            return null;
                        });
                    })).exceptionally(ex -> {
                        result.completeExceptionally((Throwable)ex);
                        this.deadLetterProducer = null;
                        return null;
                    });
                } else {
                    TypedMessageBuilder typedMessageBuilderNew = this.retryLetterProducer.newMessage().value(retryMessage.getValue()).properties(propertiesMap);
                    if (delayTime > 0L) {
                        typedMessageBuilderNew.deliverAfter(delayTime, unit);
                    }
                    if (message.hasKey()) {
                        typedMessageBuilderNew.key(message.getKey());
                    }
                    ((CompletableFuture)typedMessageBuilderNew.sendAsync().thenAccept(__ -> this.doAcknowledge(finalMessageId, ackType, Collections.emptyMap(), null).thenAccept(v -> result.complete(null)))).exceptionally(ex -> {
                        result.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
            catch (Exception e) {
                log.error("Send to retry letter topic exception with topic: {}, messageId: {}", new Object[]{this.retryLetterProducer.getTopic(), messageId, e});
                Set<MessageId> messageIds = Collections.singleton(messageId);
                this.unAckedMessageTracker.remove(messageId);
                this.redeliverUnacknowledgedMessages(messageIds);
            }
        }
        MessageId finalMessageId = messageId;
        result.exceptionally(ex -> {
            Set<MessageId> messageIds = Collections.singleton(finalMessageId);
            this.unAckedMessageTracker.remove(finalMessageId);
            this.redeliverUnacknowledgedMessages(messageIds);
            return null;
        });
        return result;
    }

    private SortedMap<String, String> getPropertiesMap(Message<?> message, String originMessageIdStr, String originTopicNameStr) {
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        if (message.getProperties() != null) {
            propertiesMap.putAll(message.getProperties());
        }
        propertiesMap.putIfAbsent("REAL_TOPIC", originTopicNameStr);
        propertiesMap.putIfAbsent("ORIGIN_MESSAGE_IDY_TIME", originMessageIdStr);
        propertiesMap.putIfAbsent("ORIGIN_MESSAGE_ID", originMessageIdStr);
        return propertiesMap;
    }

    private String getOriginMessageIdStr(Message<?> message) {
        if (message instanceof TopicMessageImpl) {
            return ((TopicMessageIdImpl)message.getMessageId()).getInnerMessageId().toString();
        }
        if (message instanceof MessageImpl) {
            return message.getMessageId().toString();
        }
        return null;
    }

    private String getOriginTopicNameStr(Message<?> message) {
        if (message instanceof TopicMessageImpl) {
            return ((TopicMessageIdImpl)message.getMessageId()).getTopicName();
        }
        if (message instanceof MessageImpl) {
            return message.getTopicName();
        }
        return null;
    }

    private MessageImpl<?> getMessageImpl(Message<?> message) {
        if (message instanceof TopicMessageImpl) {
            return (MessageImpl)((TopicMessageImpl)message).getMessage();
        }
        if (message instanceof MessageImpl) {
            return (MessageImpl)message;
        }
        return null;
    }

    public void negativeAcknowledge(MessageId messageId) {
        this.negativeAcksTracker.add(messageId);
        this.unAckedMessageTracker.remove(messageId);
    }

    @Override
    public void negativeAcknowledge(Message<?> message) {
        this.negativeAcksTracker.add(message);
        this.unAckedMessageTracker.remove(message.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(ClientCnx cnx) {
        int currentSize;
        this.previousExceptions.clear();
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.setState(HandlerState.State.Closed);
            this.closeConsumerTasks();
            this.deregisterFromClientCnx();
            this.client.cleanupConsumer(this);
            this.clearReceiverQueue();
            return;
        }
        log.info("[{}][{}] Subscribing to topic on cnx {}, consumerId {}", new Object[]{this.topic, this.subscription, cnx.ctx().channel(), this.consumerId});
        long requestId = this.client.newRequestId();
        if (this.duringSeek.get()) {
            this.acknowledgmentsGroupingTracker.flushAndClean();
        }
        SUBSCRIBE_DEADLINE_UPDATER.compareAndSet(this, 0L, System.currentTimeMillis() + this.client.getConfiguration().getOperationTimeoutMs());
        ConsumerImpl consumerImpl = this;
        synchronized (consumerImpl) {
            currentSize = this.incomingMessages.size();
            this.startMessageId = this.clearReceiverQueue();
            if (this.possibleSendToDeadLetterTopicMessages != null) {
                this.possibleSendToDeadLetterTopicMessages.clear();
            }
        }
        boolean isDurable = this.subscriptionMode == SubscriptionMode.Durable;
        MessageIdData startMessageIdData = !isDurable && this.startMessageId != null ? new MessageIdData().setLedgerId(this.startMessageId.getLedgerId()).setEntryId(this.startMessageId.getEntryId()).setBatchIndex(this.startMessageId.getBatchIndex()) : null;
        SchemaInfo si = this.schema.getSchemaInfo();
        if (si != null && (SchemaType.BYTES == si.getType() || SchemaType.NONE == si.getType())) {
            si = null;
        }
        long startMessageRollbackDuration = this.startMessageRollbackDurationInSec > 0L && this.startMessageId != null && this.startMessageId.equals(this.initialStartMessageId) ? this.startMessageRollbackDurationInSec : 0L;
        ConsumerImpl consumerImpl2 = this;
        synchronized (consumerImpl2) {
            this.setClientCnx(cnx);
            ByteBuf request = Commands.newSubscribe((String)this.topic, (String)this.subscription, (long)this.consumerId, (long)requestId, (CommandSubscribe.SubType)this.getSubType(), (int)this.priorityLevel, (String)this.consumerName, (boolean)isDurable, (MessageIdData)startMessageIdData, this.metadata, (boolean)this.readCompacted, (boolean)this.conf.isReplicateSubscriptionState(), (CommandSubscribe.InitialPosition)CommandSubscribe.InitialPosition.valueOf((int)this.subscriptionInitialPosition.getValue()), (long)startMessageRollbackDuration, (SchemaInfo)si, (boolean)this.createTopicIfDoesNotExist, (KeySharedPolicy)this.conf.getKeySharedPolicy(), this.conf.getSubscriptionProperties(), (long)CONSUMER_EPOCH.get(this));
            ((CompletableFuture)cnx.sendRequestWithId(request, requestId).thenRun(() -> {
                ConsumerImpl consumerImpl = this;
                synchronized (consumerImpl) {
                    if (!this.changeToReadyState()) {
                        this.setState(HandlerState.State.Closed);
                        this.deregisterFromClientCnx();
                        this.client.cleanupConsumer(this);
                        cnx.channel().close();
                        return;
                    }
                    this.consumerIsReconnectedToBroker(cnx, currentSize);
                }
                this.resetBackoff();
                boolean firstTimeConnect = this.subscribeFuture.complete(this);
                if (!(firstTimeConnect && this.hasParentConsumer || this.conf.getReceiverQueueSize() == 0)) {
                    this.increaseAvailablePermits(cnx, this.conf.getReceiverQueueSize());
                }
            })).exceptionally(e -> {
                this.deregisterFromClientCnx();
                if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
                    cnx.channel().close();
                    return null;
                }
                log.warn("[{}][{}] Failed to subscribe to topic on {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress()});
                if (e.getCause() instanceof PulsarClientException && PulsarClientException.isRetriableError((Throwable)e.getCause()) && System.currentTimeMillis() < SUBSCRIBE_DEADLINE_UPDATER.get(this)) {
                    this.reconnectLater(e.getCause());
                } else if (!this.subscribeFuture.isDone()) {
                    this.setState(HandlerState.State.Failed);
                    this.closeConsumerTasks();
                    this.subscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e, (String)String.format("Failed to subscribe the topic %s with subscription name %s when connecting to the broker", this.topicName.toString(), this.subscription)));
                    this.client.cleanupConsumer(this);
                } else if (e.getCause() instanceof PulsarClientException.TopicDoesNotExistException) {
                    this.setState(HandlerState.State.Failed);
                    this.closeConsumerTasks();
                    this.client.cleanupConsumer(this);
                    log.warn("[{}][{}] Closed consumer because topic does not exist anymore {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress()});
                } else {
                    this.reconnectLater(e.getCause());
                }
                return null;
            });
        }
    }

    protected void consumerIsReconnectedToBroker(ClientCnx cnx, int currentQueueSize) {
        log.info("[{}][{}] Subscribed to topic on {} -- consumer: {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress(), this.consumerId});
        AVAILABLE_PERMITS_UPDATER.set(this, 0);
    }

    private BatchMessageIdImpl clearReceiverQueue() {
        ArrayList currentMessageQueue = new ArrayList(this.incomingMessages.size());
        this.incomingMessages.drainTo(currentMessageQueue);
        this.resetIncomingMessageSize();
        if (this.duringSeek.compareAndSet(true, false)) {
            return this.seekMessageId;
        }
        if (this.subscriptionMode == SubscriptionMode.Durable) {
            return this.startMessageId;
        }
        if (!currentMessageQueue.isEmpty()) {
            MessageIdImpl nextMessageInQueue = (MessageIdImpl)((Message)currentMessageQueue.get(0)).getMessageId();
            BatchMessageIdImpl previousMessage = nextMessageInQueue instanceof BatchMessageIdImpl ? new BatchMessageIdImpl(nextMessageInQueue.getLedgerId(), nextMessageInQueue.getEntryId(), nextMessageInQueue.getPartitionIndex(), ((BatchMessageIdImpl)nextMessageInQueue).getBatchIndex() - 1) : new BatchMessageIdImpl(nextMessageInQueue.getLedgerId(), nextMessageInQueue.getEntryId() - 1L, nextMessageInQueue.getPartitionIndex(), -1);
            currentMessageQueue.forEach(Message::release);
            return previousMessage;
        }
        if (!this.lastDequeuedMessageId.equals(MessageId.earliest)) {
            return new BatchMessageIdImpl((MessageIdImpl)this.lastDequeuedMessageId);
        }
        return this.startMessageId;
    }

    private void sendFlowPermitsToBroker(ClientCnx cnx, int numMessages) {
        if (cnx != null && numMessages > 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Adding {} additional permits", new Object[]{this.topic, this.subscription, numMessages});
            }
            if (log.isDebugEnabled()) {
                cnx.ctx().writeAndFlush((Object)Commands.newFlow((long)this.consumerId, (int)numMessages)).addListener(writeFuture -> {
                    if (!writeFuture.isSuccess()) {
                        log.debug("Consumer {} failed to send {} permits to broker: {}", new Object[]{this.consumerId, numMessages, writeFuture.cause().getMessage()});
                    } else {
                        log.debug("Consumer {} sent {} permits to broker", (Object)this.consumerId, (Object)numMessages);
                    }
                });
            } else {
                cnx.ctx().writeAndFlush((Object)Commands.newFlow((long)this.consumerId, (int)numMessages), cnx.ctx().voidPromise());
            }
        }
    }

    @Override
    public void connectionFailed(PulsarClientException exception) {
        boolean timeout;
        boolean nonRetriableError = !PulsarClientException.isRetriableError((Throwable)exception);
        boolean bl = timeout = System.currentTimeMillis() > this.lookupDeadline;
        if (nonRetriableError || timeout) {
            exception.setPreviousExceptions(this.previousExceptions);
            if (this.subscribeFuture.completeExceptionally(exception)) {
                this.setState(HandlerState.State.Failed);
                if (nonRetriableError) {
                    log.info("[{}] Consumer creation failed for consumer {} with unretriableError {}", new Object[]{this.topic, this.consumerId, exception});
                } else {
                    log.info("[{}] Consumer creation failed for consumer {} after timeout", (Object)this.topic, (Object)this.consumerId);
                }
                this.closeConsumerTasks();
                this.deregisterFromClientCnx();
                this.client.cleanupConsumer(this);
            }
        } else {
            this.previousExceptions.add(exception);
        }
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.closeConsumerTasks();
            this.failPendingReceive().whenComplete((r, t) -> closeFuture.complete(null));
            return closeFuture;
        }
        if (!this.isConnected()) {
            log.info("[{}] [{}] Closed Consumer (not connected)", (Object)this.topic, (Object)this.subscription);
            this.setState(HandlerState.State.Closed);
            this.closeConsumerTasks();
            this.deregisterFromClientCnx();
            this.client.cleanupConsumer(this);
            this.failPendingReceive().whenComplete((r, t) -> closeFuture.complete(null));
            return closeFuture;
        }
        this.stats.getStatTimeout().ifPresent(Timeout::cancel);
        this.setState(HandlerState.State.Closing);
        this.closeConsumerTasks();
        long requestId = this.client.newRequestId();
        ClientCnx cnx = this.cnx();
        if (null == cnx) {
            this.cleanupAtClose(closeFuture, null);
        } else {
            ByteBuf cmd = Commands.newCloseConsumer((long)this.consumerId, (long)requestId);
            cnx.sendRequestWithId(cmd, requestId).handle((v, exception) -> {
                boolean ignoreException;
                ChannelHandlerContext ctx = cnx.ctx();
                boolean bl = ignoreException = ctx == null || !ctx.channel().isActive();
                if (ignoreException && exception != null) {
                    log.debug("Exception ignored in closing consumer", exception);
                }
                this.cleanupAtClose(closeFuture, ignoreException ? null : exception);
                return null;
            });
        }
        return closeFuture;
    }

    private void cleanupAtClose(CompletableFuture<Void> closeFuture, Throwable exception) {
        log.info("[{}] [{}] Closed consumer", (Object)this.topic, (Object)this.subscription);
        this.setState(HandlerState.State.Closed);
        this.closeConsumerTasks();
        this.deregisterFromClientCnx();
        this.client.cleanupConsumer(this);
        this.failPendingReceive().whenComplete((r, t) -> {
            if (exception != null) {
                closeFuture.completeExceptionally(exception);
            } else {
                closeFuture.complete(null);
            }
        });
    }

    private void closeConsumerTasks() {
        this.unAckedMessageTracker.close();
        if (this.possibleSendToDeadLetterTopicMessages != null) {
            this.possibleSendToDeadLetterTopicMessages.clear();
        }
        this.acknowledgmentsGroupingTracker.close();
        if (this.batchReceiveTimeout != null) {
            this.batchReceiveTimeout.cancel();
        }
        this.negativeAcksTracker.close();
        this.stats.getStatTimeout().ifPresent(Timeout::cancel);
    }

    void activeConsumerChanged(boolean isActive) {
        if (this.consumerEventListener == null) {
            return;
        }
        this.externalPinnedExecutor.execute(() -> {
            if (isActive) {
                this.consumerEventListener.becameActive((Consumer)this, this.partitionIndex);
            } else {
                this.consumerEventListener.becameInactive((Consumer)this, this.partitionIndex);
            }
        });
    }

    protected boolean isBatch(MessageMetadata messageMetadata) {
        return !this.isMessageUndecryptable(messageMetadata) && (messageMetadata.hasNumMessagesInBatch() || messageMetadata.getNumMessagesInBatch() != 1);
    }

    protected <V> MessageImpl<V> newSingleMessage(int index, int numMessages, BrokerEntryMetadata brokerEntryMetadata, MessageMetadata msgMetadata, SingleMessageMetadata singleMessageMetadata, ByteBuf payload, MessageIdImpl messageId, Schema<V> schema, boolean containMetadata, BitSetRecyclable ackBitSet, BatchMessageAcker acker, int redeliveryCount, long consumerEpoch) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] processing message num - {} in batch", new Object[]{this.subscription, this.consumerName, index});
        }
        ByteBuf singleMessagePayload = null;
        try {
            if (containMetadata) {
                singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)payload, (SingleMessageMetadata)singleMessageMetadata, (int)index, (int)numMessages);
            }
            if (this.topicName.isPersistent() && this.isSameEntry(messageId) && this.isPriorBatchIndex(index)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Ignoring message from before the startMessageId: {}", new Object[]{this.subscription, this.consumerName, this.startMessageId});
                }
                MessageImpl<V> messageImpl = null;
                return messageImpl;
            }
            if (singleMessageMetadata != null && singleMessageMetadata.isCompactedOut()) {
                MessageImpl<V> messageImpl = null;
                return messageImpl;
            }
            if (ackBitSet != null && !ackBitSet.get(index)) {
                MessageImpl<V> messageImpl = null;
                return messageImpl;
            }
            BatchMessageIdImpl batchMessageIdImpl = new BatchMessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex(), index, numMessages, acker);
            ByteBuf payloadBuffer = singleMessagePayload != null ? singleMessagePayload : payload;
            MessageImpl<V> message = MessageImpl.create(this.topicName.toString(), batchMessageIdImpl, msgMetadata, singleMessageMetadata, payloadBuffer, this.createEncryptionContext(msgMetadata), this.cnx(), schema, redeliveryCount, this.poolMessages, consumerEpoch);
            message.setBrokerEntryMetadata(brokerEntryMetadata);
            MessageImpl<V> messageImpl = message;
            return messageImpl;
        }
        catch (IOException | IllegalStateException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (singleMessagePayload != null) {
                singleMessagePayload.release();
            }
        }
    }

    protected <V> MessageImpl<V> newMessage(MessageIdImpl messageId, BrokerEntryMetadata brokerEntryMetadata, MessageMetadata messageMetadata, ByteBuf payload, Schema<V> schema, int redeliveryCount, long consumerEpoch) {
        MessageImpl<V> message = MessageImpl.create(this.topicName.toString(), messageId, messageMetadata, payload, this.createEncryptionContext(messageMetadata), this.cnx(), schema, redeliveryCount, this.poolMessages, consumerEpoch);
        message.setBrokerEntryMetadata(brokerEntryMetadata);
        return message;
    }

    private void executeNotifyCallback(MessageImpl<T> message) {
        this.internalPinnedExecutor.execute(() -> {
            if (this.hasNextPendingReceive()) {
                this.notifyPendingReceivedCallback(message, null);
            } else if (this.enqueueMessageAndCheckBatchReceive(message) && this.hasPendingBatchReceive()) {
                this.notifyPendingBatchReceivedCallBack();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPayloadByProcessor(BrokerEntryMetadata brokerEntryMetadata, MessageMetadata messageMetadata, ByteBuf byteBuf, MessageIdImpl messageId, Schema<T> schema, int redeliveryCount, List<Long> ackSet, long consumerEpoch) {
        MessagePayloadImpl payload = MessagePayloadImpl.create(byteBuf);
        MessagePayloadContextImpl entryContext = MessagePayloadContextImpl.get(brokerEntryMetadata, messageMetadata, messageId, this, redeliveryCount, ackSet, consumerEpoch);
        AtomicInteger skippedMessages = new AtomicInteger(0);
        try {
            this.conf.getPayloadProcessor().process((MessagePayload)payload, (MessagePayloadContext)entryContext, schema, message -> {
                if (message != null) {
                    this.executeNotifyCallback((MessageImpl)message);
                } else {
                    skippedMessages.incrementAndGet();
                }
            });
        }
        catch (Throwable throwable) {
            log.warn("[{}] [{}] unable to obtain message in batch", new Object[]{this.subscription, this.consumerName, throwable});
            this.discardCorruptedMessage(messageId, this.cnx(), CommandAck.ValidationError.BatchDeSerializeError);
        }
        finally {
            entryContext.recycle();
            payload.release();
        }
        if (skippedMessages.get() > 0) {
            this.increaseAvailablePermits(this.cnx(), skippedMessages.get());
        }
        this.tryTriggerListener();
    }

    void messageReceived(CommandMessage cmdMessage, ByteBuf headersAndPayload, ClientCnx cnx) {
        MessageMetadata msgMetadata;
        BrokerEntryMetadata brokerEntryMetadata;
        List<Long> ackSet = Collections.emptyList();
        if (cmdMessage.getAckSetsCount() > 0) {
            ackSet = new ArrayList(cmdMessage.getAckSetsCount());
            for (int i = 0; i < cmdMessage.getAckSetsCount(); ++i) {
                ackSet.add(cmdMessage.getAckSetAt(i));
            }
        }
        int redeliveryCount = cmdMessage.getRedeliveryCount();
        MessageIdData messageId = cmdMessage.getMessageId();
        long consumerEpoch = -1L;
        if (cmdMessage.hasConsumerEpoch()) {
            consumerEpoch = cmdMessage.getConsumerEpoch();
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Received message: {}/{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        }
        if (!this.verifyChecksum(headersAndPayload, messageId)) {
            this.discardCorruptedMessage(messageId, cnx, CommandAck.ValidationError.ChecksumMismatch);
            return;
        }
        try {
            brokerEntryMetadata = Commands.parseBrokerEntryMetadataIfExist((ByteBuf)headersAndPayload);
            msgMetadata = Commands.parseMessageMetadata((ByteBuf)headersAndPayload);
        }
        catch (Throwable t) {
            this.discardCorruptedMessage(messageId, cnx, CommandAck.ValidationError.ChecksumMismatch);
            return;
        }
        int numMessages = msgMetadata.getNumMessagesInBatch();
        int numChunks = msgMetadata.hasNumChunksFromMsg() ? msgMetadata.getNumChunksFromMsg() : 0;
        boolean isChunkedMessage = numChunks > 1 && this.conf.getSubscriptionType() != SubscriptionType.Shared;
        MessageIdImpl msgId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        if (this.acknowledgmentsGroupingTracker.isDuplicate(msgId)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Ignoring message as it was already being acked earlier by same consumer {}/{}", new Object[]{this.topic, this.subscription, this.consumerName, msgId});
            }
            this.increaseAvailablePermits(cnx, numMessages);
            return;
        }
        ByteBuf decryptedPayload = this.decryptPayloadIfNeeded(messageId, redeliveryCount, msgMetadata, headersAndPayload, cnx);
        boolean isMessageUndecryptable = this.isMessageUndecryptable(msgMetadata);
        if (decryptedPayload == null) {
            return;
        }
        ByteBuf uncompressedPayload = isMessageUndecryptable || isChunkedMessage ? decryptedPayload.retain() : this.uncompressPayloadIfNeeded(messageId, msgMetadata, decryptedPayload, cnx, true);
        decryptedPayload.release();
        if (uncompressedPayload == null) {
            return;
        }
        if (this.conf.getPayloadProcessor() != null) {
            this.processPayloadByProcessor(brokerEntryMetadata, msgMetadata, uncompressedPayload, msgId, this.schema, redeliveryCount, ackSet, consumerEpoch);
            return;
        }
        if (isMessageUndecryptable || numMessages == 1 && !msgMetadata.hasNumMessagesInBatch()) {
            if (isChunkedMessage) {
                if ((uncompressedPayload = this.processMessageChunk(uncompressedPayload, msgMetadata, msgId, messageId, cnx)) == null) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Chunked message completed chunkId {}, total-chunks {}, msgId {} sequenceId {}", new Object[]{msgMetadata.getChunkId(), msgMetadata.getNumChunksFromMsg(), msgId, msgMetadata.getSequenceId()});
                }
                ChunkedMessageCtx chunkedMsgCtx = (ChunkedMessageCtx)this.chunkedMessagesMap.remove((Object)msgMetadata.getUuid());
                if (chunkedMsgCtx.chunkedMessageIds.length > 0) {
                    msgId = new ChunkMessageIdImpl(chunkedMsgCtx.chunkedMessageIds[0], chunkedMsgCtx.chunkedMessageIds[chunkedMsgCtx.chunkedMessageIds.length - 1]);
                }
                this.unAckedChunkedMessageIdSequenceMap.put((Object)msgId, (Object)chunkedMsgCtx.chunkedMessageIds);
                --this.pendingChunkedMessageCount;
                chunkedMsgCtx.recycle();
            }
            if (this.topicName.isPersistent() && this.isSameEntry(msgId) && this.isPriorEntryIndex(messageId.getEntryId())) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Ignoring message from before the startMessageId: {}", new Object[]{this.subscription, this.consumerName, this.startMessageId});
                }
                uncompressedPayload.release();
                return;
            }
            MessageImpl message = this.newMessage(msgId, brokerEntryMetadata, msgMetadata, uncompressedPayload, this.schema, redeliveryCount, consumerEpoch);
            uncompressedPayload.release();
            if (this.deadLetterPolicy != null && this.possibleSendToDeadLetterTopicMessages != null && redeliveryCount >= this.deadLetterPolicy.getMaxRedeliverCount()) {
                this.possibleSendToDeadLetterTopicMessages.put((MessageIdImpl)message.getMessageId(), Collections.singletonList(message));
            }
            this.executeNotifyCallback(message);
        } else {
            this.receiveIndividualMessagesFromBatch(brokerEntryMetadata, msgMetadata, redeliveryCount, ackSet, uncompressedPayload, messageId, cnx, consumerEpoch);
            uncompressedPayload.release();
        }
        this.tryTriggerListener();
    }

    private void tryTriggerListener() {
        if (this.listener != null) {
            this.triggerListener();
        }
    }

    private ByteBuf processMessageChunk(ByteBuf compressedPayload, MessageMetadata msgMetadata, MessageIdImpl msgId, MessageIdData messageId, ClientCnx cnx) {
        ChunkedMessageCtx chunkedMsgCtx;
        if (!this.expireChunkMessageTaskScheduled && this.expireTimeOfIncompleteChunkedMessageMillis > 0L) {
            this.internalPinnedExecutor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::removeExpireIncompleteChunkedMessages), this.expireTimeOfIncompleteChunkedMessageMillis, this.expireTimeOfIncompleteChunkedMessageMillis, TimeUnit.MILLISECONDS);
            this.expireChunkMessageTaskScheduled = true;
        }
        if (msgMetadata.getChunkId() == 0) {
            ByteBuf chunkedMsgBuffer = PulsarByteBufAllocator.DEFAULT.buffer(msgMetadata.getTotalChunkMsgSize(), msgMetadata.getTotalChunkMsgSize());
            int totalChunks = msgMetadata.getNumChunksFromMsg();
            this.chunkedMessagesMap.computeIfAbsent((Object)msgMetadata.getUuid(), key -> ChunkedMessageCtx.get(totalChunks, chunkedMsgBuffer));
            ++this.pendingChunkedMessageCount;
            if (this.maxPendingChunkedMessage > 0 && this.pendingChunkedMessageCount > this.maxPendingChunkedMessage) {
                this.removeOldestPendingChunkedMessage();
            }
            this.pendingChunkedMessageUuidQueue.add(msgMetadata.getUuid());
        }
        if ((chunkedMsgCtx = (ChunkedMessageCtx)this.chunkedMessagesMap.get((Object)msgMetadata.getUuid())) == null || chunkedMsgCtx.chunkedMsgBuffer == null || msgMetadata.getChunkId() != chunkedMsgCtx.lastChunkedMessageId + 1 || msgMetadata.getChunkId() >= msgMetadata.getTotalChunkMsgSize()) {
            log.info("Received unexpected chunk messageId {}, last-chunk-id{}, chunkId = {}, total-chunks {}", new Object[]{msgId, chunkedMsgCtx != null ? Integer.valueOf(chunkedMsgCtx.lastChunkedMessageId) : null, msgMetadata.getChunkId(), msgMetadata.getTotalChunkMsgSize()});
            if (chunkedMsgCtx != null) {
                if (chunkedMsgCtx.chunkedMsgBuffer != null) {
                    ReferenceCountUtil.safeRelease((Object)chunkedMsgCtx.chunkedMsgBuffer);
                }
                chunkedMsgCtx.recycle();
            }
            this.chunkedMessagesMap.remove((Object)msgMetadata.getUuid());
            compressedPayload.release();
            this.increaseAvailablePermits(cnx);
            if (this.expireTimeOfIncompleteChunkedMessageMillis > 0L && System.currentTimeMillis() > msgMetadata.getPublishTime() + this.expireTimeOfIncompleteChunkedMessageMillis) {
                this.doAcknowledge(msgId, CommandAck.AckType.Individual, Collections.emptyMap(), null);
            } else {
                this.trackMessage(msgId);
            }
            return null;
        }
        chunkedMsgCtx.chunkedMessageIds[msgMetadata.getChunkId()] = msgId;
        chunkedMsgCtx.chunkedMsgBuffer.writeBytes(compressedPayload);
        chunkedMsgCtx.lastChunkedMessageId = msgMetadata.getChunkId();
        if (msgMetadata.getChunkId() != msgMetadata.getNumChunksFromMsg() - 1) {
            compressedPayload.release();
            this.increaseAvailablePermits(cnx);
            return null;
        }
        compressedPayload.release();
        compressedPayload = chunkedMsgCtx.chunkedMsgBuffer;
        ByteBuf uncompressedPayload = this.uncompressPayloadIfNeeded(messageId, msgMetadata, compressedPayload, cnx, false);
        compressedPayload.release();
        return uncompressedPayload;
    }

    void notifyPendingReceivedCallback(Message<T> message, Exception exception) {
        if (this.pendingReceives.isEmpty()) {
            return;
        }
        CompletableFuture receivedFuture = this.nextPendingReceive();
        if (receivedFuture == null) {
            return;
        }
        if (exception != null) {
            this.internalPinnedExecutor.execute(() -> receivedFuture.completeExceptionally(exception));
            return;
        }
        if (message == null) {
            IllegalStateException e = new IllegalStateException("received message can't be null");
            this.internalPinnedExecutor.execute(() -> receivedFuture.completeExceptionally(e));
            return;
        }
        if (this.conf.getReceiverQueueSize() == 0) {
            this.trackMessage(message);
            this.interceptAndComplete(message, receivedFuture);
            return;
        }
        this.messageProcessed(message);
        this.interceptAndComplete(message, receivedFuture);
    }

    private void interceptAndComplete(Message<T> message, CompletableFuture<Message<T>> receivedFuture) {
        Message<T> interceptMessage = this.beforeConsume(message);
        this.completePendingReceive(receivedFuture, interceptMessage);
    }

    void receiveIndividualMessagesFromBatch(BrokerEntryMetadata brokerEntryMetadata, MessageMetadata msgMetadata, int redeliveryCount, List<Long> ackSet, ByteBuf uncompressedPayload, MessageIdData messageId, ClientCnx cnx, long consumerEpoch) {
        int batchSize = msgMetadata.getNumMessagesInBatch();
        MessageIdImpl batchMessage = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        ArrayList possibleToDeadLetter = null;
        if (this.deadLetterPolicy != null && redeliveryCount >= this.deadLetterPolicy.getMaxRedeliverCount()) {
            possibleToDeadLetter = new ArrayList();
        }
        BatchMessageAcker acker = BatchMessageAcker.newAcker(batchSize);
        BitSetRecyclable ackBitSet = null;
        if (ackSet != null && ackSet.size() > 0) {
            ackBitSet = BitSetRecyclable.valueOf((long[])SafeCollectionUtils.longListToArray(ackSet));
        }
        SingleMessageMetadata singleMessageMetadata = new SingleMessageMetadata();
        int skippedMessages = 0;
        try {
            for (int i = 0; i < batchSize; ++i) {
                MessageImpl message = this.newSingleMessage(i, batchSize, brokerEntryMetadata, msgMetadata, singleMessageMetadata, uncompressedPayload, batchMessage, this.schema, true, ackBitSet, acker, redeliveryCount, consumerEpoch);
                if (message == null) {
                    ++skippedMessages;
                    continue;
                }
                if (possibleToDeadLetter != null) {
                    possibleToDeadLetter.add(message);
                }
                this.executeNotifyCallback(message);
            }
            if (ackBitSet != null) {
                ackBitSet.recycle();
            }
        }
        catch (IllegalStateException e) {
            log.warn("[{}] [{}] unable to obtain message in batch", new Object[]{this.subscription, this.consumerName, e});
            this.discardCorruptedMessage(messageId, cnx, CommandAck.ValidationError.BatchDeSerializeError);
        }
        if (possibleToDeadLetter != null && this.possibleSendToDeadLetterTopicMessages != null) {
            this.possibleSendToDeadLetterTopicMessages.put(batchMessage, possibleToDeadLetter);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] enqueued messages in batch. queue size - {}, available queue size - {}", new Object[]{this.subscription, this.consumerName, this.incomingMessages.size(), this.incomingMessages.remainingCapacity()});
        }
        if (skippedMessages > 0) {
            this.increaseAvailablePermits(cnx, skippedMessages);
        }
    }

    private boolean isPriorEntryIndex(long idx) {
        return this.resetIncludeHead ? idx < this.startMessageId.getEntryId() : idx <= this.startMessageId.getEntryId();
    }

    private boolean isPriorBatchIndex(long idx) {
        return this.resetIncludeHead ? idx < (long)this.startMessageId.getBatchIndex() : idx <= (long)this.startMessageId.getBatchIndex();
    }

    private boolean isSameEntry(MessageIdImpl messageId) {
        return this.startMessageId != null && messageId.getLedgerId() == this.startMessageId.getLedgerId() && messageId.getEntryId() == this.startMessageId.getEntryId();
    }

    @Override
    protected synchronized void messageProcessed(Message<?> msg) {
        ClientCnx currentCnx = this.cnx();
        ClientCnx msgCnx = ((MessageImpl)msg).getCnx();
        this.lastDequeuedMessageId = msg.getMessageId();
        if (msgCnx == currentCnx) {
            this.increaseAvailablePermits(currentCnx);
            this.stats.updateNumMsgsReceived(msg);
            this.trackMessage(msg);
        }
        this.decreaseIncomingMessageSize(msg);
    }

    protected void trackMessage(Message<?> msg) {
        if (msg != null) {
            this.trackMessage(msg.getMessageId(), msg.getRedeliveryCount());
        }
    }

    protected void trackMessage(MessageId messageId) {
        this.trackMessage(messageId, 0);
    }

    protected void trackMessage(MessageId messageId, int redeliveryCount) {
        if (this.conf.getAckTimeoutMillis() > 0L && messageId instanceof MessageIdImpl) {
            MessageIdImpl id = (MessageIdImpl)messageId;
            if (id instanceof BatchMessageIdImpl) {
                id = new MessageIdImpl(id.getLedgerId(), id.getEntryId(), this.getPartitionIndex());
            }
            if (this.hasParentConsumer) {
                this.unAckedMessageTracker.remove(id);
            } else {
                this.unAckedMessageTracker.add(id, redeliveryCount);
            }
        }
    }

    void increaseAvailablePermits(ClientCnx currentCnx) {
        this.increaseAvailablePermits(currentCnx, 1);
    }

    protected void increaseAvailablePermits(ClientCnx currentCnx, int delta) {
        int available = AVAILABLE_PERMITS_UPDATER.addAndGet(this, delta);
        while (available >= this.receiverQueueRefillThreshold && !this.paused) {
            if (AVAILABLE_PERMITS_UPDATER.compareAndSet(this, available, 0)) {
                this.sendFlowPermitsToBroker(currentCnx, available);
                break;
            }
            available = AVAILABLE_PERMITS_UPDATER.get(this);
        }
    }

    public void increaseAvailablePermits(int delta) {
        this.increaseAvailablePermits(this.cnx(), delta);
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.increaseAvailablePermits(this.cnx(), 0);
        }
    }

    public long getLastDisconnectedTimestamp() {
        return this.connectionHandler.lastConnectionClosedTimestamp;
    }

    private ByteBuf decryptPayloadIfNeeded(MessageIdData messageId, int redeliveryCount, MessageMetadata msgMetadata, ByteBuf payload, ClientCnx currentCnx) {
        if (msgMetadata.getEncryptionKeysCount() == 0) {
            return payload.retain();
        }
        if (this.conf.getCryptoKeyReader() == null) {
            switch (this.conf.getCryptoFailureAction()) {
                case CONSUME: {
                    log.warn("[{}][{}][{}] CryptoKeyReader interface is not implemented. Consuming encrypted message.", new Object[]{this.topic, this.subscription, this.consumerName});
                    return payload.retain();
                }
                case DISCARD: {
                    log.warn("[{}][{}][{}] Skipping decryption since CryptoKeyReader interface is not implemented and config is set to discard", new Object[]{this.topic, this.subscription, this.consumerName});
                    this.discardMessage(messageId, currentCnx, CommandAck.ValidationError.DecryptionError);
                    return null;
                }
                case FAIL: {
                    MessageIdImpl m = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.partitionIndex);
                    log.error("[{}][{}][{}][{}] Message delivery failed since CryptoKeyReader interface is not implemented to consume encrypted message", new Object[]{this.topic, this.subscription, this.consumerName, m});
                    this.unAckedMessageTracker.add(m, redeliveryCount);
                    return null;
                }
            }
        }
        int maxDecryptedSize = this.msgCrypto.getMaxOutputSize(payload.readableBytes());
        ByteBuf decryptedData = PulsarByteBufAllocator.DEFAULT.buffer(maxDecryptedSize);
        ByteBuffer nioDecryptedData = decryptedData.nioBuffer(0, maxDecryptedSize);
        if (this.msgCrypto.decrypt(() -> msgMetadata, payload.nioBuffer(), nioDecryptedData, this.conf.getCryptoKeyReader())) {
            decryptedData.writerIndex(nioDecryptedData.limit());
            return decryptedData;
        }
        decryptedData.release();
        switch (this.conf.getCryptoFailureAction()) {
            case CONSUME: {
                log.warn("[{}][{}][{}][{}] Decryption failed. Consuming encrypted message since config is set to consume.", new Object[]{this.topic, this.subscription, this.consumerName, messageId});
                return payload.retain();
            }
            case DISCARD: {
                log.warn("[{}][{}][{}][{}] Discarding message since decryption failed and config is set to discard", new Object[]{this.topic, this.subscription, this.consumerName, messageId});
                this.discardMessage(messageId, currentCnx, CommandAck.ValidationError.DecryptionError);
                return null;
            }
            case FAIL: {
                MessageIdImpl m = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.partitionIndex);
                log.error("[{}][{}][{}][{}] Message delivery failed since unable to decrypt incoming message", new Object[]{this.topic, this.subscription, this.consumerName, m});
                this.unAckedMessageTracker.add(m, redeliveryCount);
                return null;
            }
        }
        return null;
    }

    private ByteBuf uncompressPayloadIfNeeded(MessageIdData messageId, MessageMetadata msgMetadata, ByteBuf payload, ClientCnx currentCnx, boolean checkMaxMessageSize) {
        CompressionType compressionType = msgMetadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((CompressionType)compressionType);
        int uncompressedSize = msgMetadata.getUncompressedSize();
        int payloadSize = payload.readableBytes();
        if (checkMaxMessageSize && payloadSize > ClientCnx.getMaxMessageSize()) {
            log.error("[{}][{}] Got corrupted payload message size {} at {}", new Object[]{this.topic, this.subscription, payloadSize, messageId});
            this.discardCorruptedMessage(messageId, currentCnx, CommandAck.ValidationError.UncompressedSizeCorruption);
            return null;
        }
        try {
            ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
            return uncompressedPayload;
        }
        catch (IOException e) {
            log.error("[{}][{}] Failed to decompress message with {} at {}: {}", new Object[]{this.topic, this.subscription, compressionType, messageId, e.getMessage(), e});
            this.discardCorruptedMessage(messageId, currentCnx, CommandAck.ValidationError.DecompressionError);
            return null;
        }
    }

    private boolean verifyChecksum(ByteBuf headersAndPayload, MessageIdData messageId) {
        int computedChecksum;
        int checksum;
        if (Commands.hasChecksum((ByteBuf)headersAndPayload) && (checksum = Commands.readChecksum((ByteBuf)headersAndPayload)) != (computedChecksum = Crc32cIntChecksum.computeChecksum((ByteBuf)headersAndPayload))) {
            log.error("[{}][{}] Checksum mismatch for message at {}:{}. Received checksum: 0x{}, Computed checksum: 0x{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId(), Long.toHexString(checksum), Integer.toHexString(computedChecksum)});
            return false;
        }
        return true;
    }

    private void discardCorruptedMessage(MessageIdImpl messageId, ClientCnx currentCnx, CommandAck.ValidationError validationError) {
        log.error("[{}][{}] Discarding corrupted message at {}:{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        ByteBuf cmd = Commands.newAck((long)this.consumerId, (long)messageId.getLedgerId(), (long)messageId.getEntryId(), null, (CommandAck.AckType)CommandAck.AckType.Individual, (CommandAck.ValidationError)validationError, Collections.emptyMap(), (long)-1L);
        currentCnx.ctx().writeAndFlush((Object)cmd, currentCnx.ctx().voidPromise());
        this.increaseAvailablePermits(currentCnx);
        this.stats.incrementNumReceiveFailed();
    }

    private void discardCorruptedMessage(MessageIdData messageId, ClientCnx currentCnx, CommandAck.ValidationError validationError) {
        log.error("[{}][{}] Discarding corrupted message at {}:{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        this.discardMessage(messageId, currentCnx, validationError);
    }

    private void discardMessage(MessageIdData messageId, ClientCnx currentCnx, CommandAck.ValidationError validationError) {
        ByteBuf cmd = Commands.newAck((long)this.consumerId, (long)messageId.getLedgerId(), (long)messageId.getEntryId(), null, (CommandAck.AckType)CommandAck.AckType.Individual, (CommandAck.ValidationError)validationError, Collections.emptyMap(), (long)-1L);
        currentCnx.ctx().writeAndFlush((Object)cmd, currentCnx.ctx().voidPromise());
        this.increaseAvailablePermits(currentCnx);
        this.stats.incrementNumReceiveFailed();
    }

    @Override
    String getHandlerName() {
        return this.subscription;
    }

    public boolean isConnected() {
        return this.getClientCnx() != null && this.getState() == HandlerState.State.Ready;
    }

    public boolean isConnected(ClientCnx cnx) {
        return cnx != null && this.getState() == HandlerState.State.Ready;
    }

    int getPartitionIndex() {
        return this.partitionIndex;
    }

    @Override
    public int getAvailablePermits() {
        return AVAILABLE_PERMITS_UPDATER.get(this);
    }

    @Override
    public int numMessagesInQueue() {
        return this.incomingMessages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeliverUnacknowledgedMessages() {
        ConsumerImpl consumerImpl = this;
        synchronized (consumerImpl) {
            ClientCnx cnx = this.cnx();
            if (cnx != null && cnx.getRemoteEndpointProtocolVersion() < ProtocolVersion.v2.getValue()) {
                if (this.getState() == HandlerState.State.Connecting) {
                    log.warn("[{}] Client Connection needs to be established for redelivery of unacknowledged messages", (Object)this);
                } else {
                    log.warn("[{}] Reconnecting the client to redeliver the messages.", (Object)this);
                    cnx.ctx().close();
                }
                return;
            }
            int currentSize = 0;
            currentSize = this.incomingMessages.size();
            this.clearIncomingMessages();
            this.unAckedMessageTracker.clear();
            if (this.conf.getSubscriptionType() == SubscriptionType.Failover || this.conf.getSubscriptionType() == SubscriptionType.Exclusive) {
                CONSUMER_EPOCH.incrementAndGet(this);
            }
            if (cnx != null && this.isConnected(cnx)) {
                cnx.ctx().writeAndFlush((Object)Commands.newRedeliverUnacknowledgedMessages((long)this.consumerId, (long)CONSUMER_EPOCH.get(this)), cnx.ctx().voidPromise());
                if (currentSize > 0) {
                    this.increaseAvailablePermits(cnx, currentSize);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] [{}] Redeliver unacked messages and send {} permits", new Object[]{this.subscription, this.topic, this.consumerName, currentSize});
                }
            } else {
                log.warn("[{}] Send redeliver messages command but the client is reconnect or close, so don't need to send redeliver command to broker", (Object)this);
            }
        }
    }

    public int clearIncomingMessagesAndGetMessageNumber() {
        int messagesNumber = this.incomingMessages.size();
        this.incomingMessages.forEach(Message::release);
        this.clearIncomingMessages();
        this.unAckedMessageTracker.clear();
        return messagesNumber;
    }

    @Override
    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        if (messageIds.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((boolean)(messageIds.stream().findFirst().get() instanceof MessageIdImpl));
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared && this.conf.getSubscriptionType() != SubscriptionType.Key_Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx.getRemoteEndpointProtocolVersion() >= ProtocolVersion.v2.getValue()) {
            int messagesFromQueue = this.removeExpiredMessagesFromQueue(messageIds);
            Iterable batches = Iterables.partition((Iterable)messageIds.stream().map(messageId -> (MessageIdImpl)messageId).collect(Collectors.toSet()), (int)1000);
            batches.forEach(ids -> this.getRedeliveryMessageIdData((List<MessageIdImpl>)ids).thenAccept(messageIdData -> {
                if (!messageIdData.isEmpty()) {
                    ByteBuf cmd = Commands.newRedeliverUnacknowledgedMessages((long)this.consumerId, (List)messageIdData);
                    cnx.ctx().writeAndFlush((Object)cmd, cnx.ctx().voidPromise());
                }
            }));
            if (messagesFromQueue > 0) {
                this.increaseAvailablePermits(cnx, messagesFromQueue);
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Redeliver unacked messages and increase {} permits", new Object[]{this.subscription, this.topic, this.consumerName, messagesFromQueue});
            }
            return;
        }
        if (cnx == null || this.getState() == HandlerState.State.Connecting) {
            log.warn("[{}] Client Connection needs to be established for redelivery of unacknowledged messages", (Object)this);
        } else {
            log.warn("[{}] Reconnecting the client to redeliver the messages.", (Object)this);
            cnx.ctx().close();
        }
    }

    @Override
    protected void completeOpBatchReceive(ConsumerBase.OpBatchReceive<T> op) {
        this.notifyPendingBatchReceivedCallBack(op);
    }

    private CompletableFuture<List<MessageIdData>> getRedeliveryMessageIdData(List<MessageIdImpl> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList data = new ArrayList(messageIds.size());
        ArrayList futures = new ArrayList(messageIds.size());
        messageIds.forEach(messageId -> {
            CompletableFuture<Boolean> future = this.processPossibleToDLQ((MessageIdImpl)messageId);
            futures.add(future.thenAccept(sendToDLQ -> {
                if (!sendToDLQ.booleanValue()) {
                    data.add(new MessageIdData().setPartition(messageId.getPartitionIndex()).setLedgerId(messageId.getLedgerId()).setEntryId(messageId.getEntryId()));
                }
            }));
        });
        return FutureUtil.waitForAll(futures).thenCompose(v -> CompletableFuture.completedFuture(data));
    }

    private CompletableFuture<Boolean> processPossibleToDLQ(MessageIdImpl messageId) {
        List<MessageImpl<T>> deadLetterMessages = null;
        if (this.possibleSendToDeadLetterTopicMessages != null) {
            if (messageId instanceof BatchMessageIdImpl) {
                messageId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
            }
            deadLetterMessages = this.possibleSendToDeadLetterTopicMessages.get(messageId);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (deadLetterMessages != null) {
            this.initDeadLetterProducerIfNeeded();
            List<MessageImpl<T>> finalDeadLetterMessages = deadLetterMessages;
            MessageIdImpl finalMessageId = messageId;
            ((CompletableFuture)this.deadLetterProducer.thenAcceptAsync(producerDLQ -> {
                for (MessageImpl message : finalDeadLetterMessages) {
                    String originMessageIdStr = this.getOriginMessageIdStr(message);
                    String originTopicNameStr = this.getOriginTopicNameStr(message);
                    ((CompletableFuture)producerDLQ.newMessage(Schema.AUTO_PRODUCE_BYTES(message.getReaderSchema().get())).value((Object)message.getData()).properties(this.getPropertiesMap(message, originMessageIdStr, originTopicNameStr)).sendAsync().thenAccept(messageIdInDLQ -> {
                        this.possibleSendToDeadLetterTopicMessages.remove(finalMessageId);
                        this.acknowledgeAsync(finalMessageId).whenComplete((v, ex) -> {
                            if (ex != null) {
                                log.warn("[{}] [{}] [{}] Failed to acknowledge the message {} of the original topic but send to the DLQ successfully.", new Object[]{this.topicName, this.subscription, this.consumerName, finalMessageId, ex});
                            } else {
                                result.complete(true);
                            }
                        });
                    })).exceptionally(ex -> {
                        log.warn("[{}] [{}] [{}] Failed to send DLQ message to {} for message id {}", new Object[]{this.topicName, this.subscription, this.consumerName, finalMessageId, ex});
                        result.complete(false);
                        return null;
                    });
                }
            })).exceptionally(ex -> {
                log.error("Dead letter producer exception with topic: {}", (Object)this.deadLetterPolicy.getDeadLetterTopic(), ex);
                this.deadLetterProducer = null;
                result.complete(false);
                return null;
            });
        } else {
            result.complete(false);
        }
        return result;
    }

    private void initDeadLetterProducerIfNeeded() {
        if (this.deadLetterProducer == null) {
            this.createProducerLock.writeLock().lock();
            try {
                if (this.deadLetterProducer == null) {
                    this.deadLetterProducer = ((ProducerBuilderImpl)this.client.newProducer(Schema.AUTO_PRODUCE_BYTES((Schema)this.schema))).initialSubscriptionName(this.deadLetterPolicy.getInitialSubscriptionName()).topic(this.deadLetterPolicy.getDeadLetterTopic()).blockIfQueueFull(false).createAsync();
                }
            }
            finally {
                this.createProducerLock.writeLock().unlock();
            }
        }
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(long timestamp) throws PulsarClientException {
        try {
            this.seekAsync(timestamp).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(Function<String, Object> function) throws PulsarClientException {
        try {
            this.seekAsync(function).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        if (function == null) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException("Function must be set"));
        }
        Object seekPosition = function.apply(this.topic);
        if (seekPosition == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (seekPosition instanceof MessageId) {
            return this.seekAsync((MessageId)seekPosition);
        }
        if (seekPosition.getClass().getTypeName().equals(Long.class.getTypeName())) {
            return this.seekAsync((Long)seekPosition);
        }
        return FutureUtil.failedFuture((Throwable)new PulsarClientException("Only support seek by messageId or timestamp"));
    }

    private Optional<CompletableFuture<Void>> seekAsyncCheckState(String seekBy) {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return Optional.of(FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer %s was already closed when seeking the subscription %s of the topic %s to %s", this.consumerName, this.subscription, this.topicName.toString(), seekBy))));
        }
        if (!this.isConnected()) {
            return Optional.of(FutureUtil.failedFuture((Throwable)new PulsarClientException(String.format("The client is not connected to the broker when seeking the subscription %s of the topic %s to %s", this.subscription, this.topicName.toString(), seekBy))));
        }
        return Optional.empty();
    }

    private CompletableFuture<Void> seekAsyncInternal(long requestId, ByteBuf seek, MessageId seekId, String seekBy) {
        CompletableFuture<Void> seekFuture = new CompletableFuture<Void>();
        ClientCnx cnx = this.cnx();
        BatchMessageIdImpl originSeekMessageId = this.seekMessageId;
        this.seekMessageId = new BatchMessageIdImpl((MessageIdImpl)seekId);
        this.duringSeek.set(true);
        log.info("[{}][{}] Seeking subscription to {}", new Object[]{this.topic, this.subscription, seekBy});
        ((CompletableFuture)cnx.sendRequestWithId(seek, requestId).thenRun(() -> {
            log.info("[{}][{}] Successfully reset subscription to {}", new Object[]{this.topic, this.subscription, seekBy});
            this.acknowledgmentsGroupingTracker.flushAndClean();
            this.lastDequeuedMessageId = MessageId.earliest;
            this.clearIncomingMessages();
            seekFuture.complete(null);
        })).exceptionally(e -> {
            this.seekMessageId = originSeekMessageId;
            this.duringSeek.set(false);
            log.error("[{}][{}] Failed to reset subscription: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
            seekFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("Failed to seek the subscription %s of the topic %s to %s", this.subscription, this.topicName.toString(), seekBy)));
            return null;
        });
        return seekFuture;
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        String seekBy = String.format("the timestamp %d", timestamp);
        return this.seekAsyncCheckState(seekBy).orElseGet(() -> {
            long requestId = this.client.newRequestId();
            return this.seekAsyncInternal(requestId, Commands.newSeek((long)this.consumerId, (long)requestId, (long)timestamp), MessageId.earliest, seekBy);
        });
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        String seekBy = String.format("the message %s", messageId.toString());
        return this.seekAsyncCheckState(seekBy).orElseGet(() -> {
            long requestId = this.client.newRequestId();
            ByteBuf seek = null;
            if (messageId instanceof BatchMessageIdImpl) {
                BatchMessageIdImpl msgId = (BatchMessageIdImpl)messageId;
                BitSetRecyclable ackSet = BitSetRecyclable.create();
                ackSet.set(0, msgId.getBatchSize());
                ackSet.clear(0, Math.max(msgId.getBatchIndex(), 0));
                long[] ackSetArr = ackSet.toLongArray();
                ackSet.recycle();
                seek = Commands.newSeek((long)this.consumerId, (long)requestId, (long)msgId.getLedgerId(), (long)msgId.getEntryId(), (long[])ackSetArr);
            } else if (messageId instanceof ChunkMessageIdImpl) {
                ChunkMessageIdImpl msgId = (ChunkMessageIdImpl)messageId;
                seek = Commands.newSeek((long)this.consumerId, (long)requestId, (long)msgId.getFirstChunkMessageId().getLedgerId(), (long)msgId.getFirstChunkMessageId().getEntryId(), (long[])new long[0]);
            } else {
                MessageIdImpl msgId = (MessageIdImpl)messageId;
                seek = Commands.newSeek((long)this.consumerId, (long)requestId, (long)msgId.getLedgerId(), (long)msgId.getEntryId(), (long[])new long[0]);
            }
            return this.seekAsyncInternal(requestId, seek, messageId, seekBy);
        });
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        try {
            return this.hasMessageAvailableAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        CompletableFuture<Boolean> booleanFuture = new CompletableFuture<Boolean>();
        if (this.lastDequeuedMessageId == MessageId.earliest) {
            if (MessageId.latest.equals(this.startMessageId)) {
                CompletionStage<GetLastMessageIdResponse> future = this.internalGetLastMessageIdAsync();
                if (this.resetIncludeHead) {
                    future = future.thenCompose(lastMessageIdResponse -> this.seekAsync(lastMessageIdResponse.lastMessageId).thenApply(ignore -> lastMessageIdResponse));
                }
                ((CompletableFuture)future.thenAccept(response -> {
                    MessageIdImpl lastMessageId = MessageIdImpl.convertToMessageIdImpl(response.lastMessageId);
                    MessageIdImpl markDeletePosition = MessageIdImpl.convertToMessageIdImpl(response.markDeletePosition);
                    if (markDeletePosition != null) {
                        int result = ComparisonChain.start().compare(markDeletePosition.getLedgerId(), lastMessageId.getLedgerId()).compare(markDeletePosition.getEntryId(), lastMessageId.getEntryId()).result();
                        if (lastMessageId.getEntryId() < 0L) {
                            this.completehasMessageAvailableWithValue(booleanFuture, false);
                        } else {
                            this.completehasMessageAvailableWithValue(booleanFuture, this.resetIncludeHead ? result <= 0 : result < 0);
                        }
                    } else if (lastMessageId == null || lastMessageId.getEntryId() < 0L) {
                        this.completehasMessageAvailableWithValue(booleanFuture, false);
                    } else {
                        this.completehasMessageAvailableWithValue(booleanFuture, this.resetIncludeHead);
                    }
                })).exceptionally(ex -> {
                    log.error("[{}][{}] Failed getLastMessageId command", new Object[]{this.topic, this.subscription, ex});
                    booleanFuture.completeExceptionally(ex.getCause());
                    return null;
                });
                return booleanFuture;
            }
            if (this.hasMoreMessages(this.lastMessageIdInBroker, this.startMessageId, this.resetIncludeHead)) {
                this.completehasMessageAvailableWithValue(booleanFuture, true);
                return booleanFuture;
            }
            ((CompletableFuture)this.getLastMessageIdAsync().thenAccept(messageId -> {
                this.lastMessageIdInBroker = messageId;
                if (this.hasMoreMessages(this.lastMessageIdInBroker, this.startMessageId, this.resetIncludeHead)) {
                    this.completehasMessageAvailableWithValue(booleanFuture, true);
                } else {
                    this.completehasMessageAvailableWithValue(booleanFuture, false);
                }
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                booleanFuture.completeExceptionally(e.getCause());
                return null;
            });
        } else {
            if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessageId, false)) {
                this.completehasMessageAvailableWithValue(booleanFuture, true);
                return booleanFuture;
            }
            ((CompletableFuture)this.getLastMessageIdAsync().thenAccept(messageId -> {
                this.lastMessageIdInBroker = messageId;
                if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessageId, false)) {
                    this.completehasMessageAvailableWithValue(booleanFuture, true);
                } else {
                    this.completehasMessageAvailableWithValue(booleanFuture, false);
                }
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                booleanFuture.completeExceptionally(e.getCause());
                return null;
            });
        }
        return booleanFuture;
    }

    private void completehasMessageAvailableWithValue(CompletableFuture<Boolean> future, boolean value) {
        this.internalPinnedExecutor.execute(() -> future.complete(value));
    }

    private boolean hasMoreMessages(MessageId lastMessageIdInBroker, MessageId messageId, boolean inclusive) {
        if (inclusive && lastMessageIdInBroker.compareTo((Object)messageId) >= 0 && ((MessageIdImpl)lastMessageIdInBroker).getEntryId() != -1L) {
            return true;
        }
        return !inclusive && lastMessageIdInBroker.compareTo((Object)messageId) > 0 && ((MessageIdImpl)lastMessageIdInBroker).getEntryId() != -1L;
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageIdAsync() {
        return this.internalGetLastMessageIdAsync().thenApply(r -> r.lastMessageId);
    }

    public CompletableFuture<GetLastMessageIdResponse> internalGetLastMessageIdAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer %s was already closed when the subscription %s of the topic %s getting the last message id", this.consumerName, this.subscription, this.topicName.toString())));
        }
        AtomicLong opTimeoutMs = new AtomicLong(this.client.getConfiguration().getOperationTimeoutMs());
        Backoff backoff = new BackoffBuilder().setInitialTime(100L, TimeUnit.MILLISECONDS).setMax(opTimeoutMs.get() * 2L, TimeUnit.MILLISECONDS).setMandatoryStop(0L, TimeUnit.MILLISECONDS).create();
        CompletableFuture<GetLastMessageIdResponse> getLastMessageIdFuture = new CompletableFuture<GetLastMessageIdResponse>();
        this.internalGetLastMessageIdAsync(backoff, opTimeoutMs, getLastMessageIdFuture);
        return getLastMessageIdFuture;
    }

    private void internalGetLastMessageIdAsync(Backoff backoff, AtomicLong remainingTime, CompletableFuture<GetLastMessageIdResponse> future) {
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx != null) {
            if (!Commands.peerSupportsGetLastMessageId((int)cnx.getRemoteEndpointProtocolVersion())) {
                future.completeExceptionally((Throwable)new PulsarClientException.NotSupportedException(String.format("The command `GetLastMessageId` is not supported for the protocol version %d. The consumer is %s, topic %s, subscription %s", cnx.getRemoteEndpointProtocolVersion(), this.consumerName, this.topicName.toString(), this.subscription)));
                return;
            }
            long requestId = this.client.newRequestId();
            ByteBuf getLastIdCmd = Commands.newGetLastMessageId((long)this.consumerId, (long)requestId);
            log.info("[{}][{}] Get topic last message Id", (Object)this.topic, (Object)this.subscription);
            ((CompletableFuture)cnx.sendGetLastMessageId(getLastIdCmd, requestId).thenAccept(cmd -> {
                MessageIdData lastMessageId = cmd.getLastMessageId();
                MessageIdImpl markDeletePosition = null;
                if (cmd.hasConsumerMarkDeletePosition()) {
                    markDeletePosition = new MessageIdImpl(cmd.getConsumerMarkDeletePosition().getLedgerId(), cmd.getConsumerMarkDeletePosition().getEntryId(), -1);
                }
                log.info("[{}][{}] Successfully getLastMessageId {}:{}", new Object[]{this.topic, this.subscription, lastMessageId.getLedgerId(), lastMessageId.getEntryId()});
                MessageIdImpl lastMsgId = lastMessageId.getBatchIndex() <= 0 ? new MessageIdImpl(lastMessageId.getLedgerId(), lastMessageId.getEntryId(), lastMessageId.getPartition()) : new BatchMessageIdImpl(lastMessageId.getLedgerId(), lastMessageId.getEntryId(), lastMessageId.getPartition(), lastMessageId.getBatchIndex());
                future.complete(new GetLastMessageIdResponse(lastMsgId, markDeletePosition));
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                future.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("The subscription %s of the topic %s gets the last message id was failed", this.subscription, this.topicName.toString())));
                return null;
            });
        } else {
            long nextDelay = Math.min(backoff.next(), remainingTime.get());
            if (nextDelay <= 0L) {
                future.completeExceptionally((Throwable)new PulsarClientException.TimeoutException(String.format("The subscription %s of the topic %s could not get the last message id withing configured timeout", this.subscription, this.topicName.toString())));
                return;
            }
            this.internalPinnedExecutor.schedule(() -> {
                log.warn("[{}] [{}] Could not get connection while getLastMessageId -- Will try again in {} ms", new Object[]{this.topic, this.getHandlerName(), nextDelay});
                remainingTime.addAndGet(-nextDelay);
                this.internalGetLastMessageIdAsync(backoff, remainingTime, future);
            }, nextDelay, TimeUnit.MILLISECONDS);
        }
    }

    private MessageIdImpl getMessageIdImpl(Message<?> msg) {
        MessageIdImpl messageId = (MessageIdImpl)msg.getMessageId();
        if (messageId instanceof BatchMessageIdImpl) {
            messageId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        }
        return messageId;
    }

    private boolean isMessageUndecryptable(MessageMetadata msgMetadata) {
        return msgMetadata.getEncryptionKeysCount() > 0 && this.conf.getCryptoKeyReader() == null && this.conf.getCryptoFailureAction() == ConsumerCryptoFailureAction.CONSUME;
    }

    private Optional<EncryptionContext> createEncryptionContext(MessageMetadata msgMetadata) {
        EncryptionContext encryptionCtx = null;
        if (msgMetadata.getEncryptionKeysCount() > 0) {
            encryptionCtx = new EncryptionContext();
            Map<String, EncryptionContext.EncryptionKey> keys = msgMetadata.getEncryptionKeysList().stream().collect(Collectors.toMap(EncryptionKeys::getKey, e -> new EncryptionContext.EncryptionKey(e.getValue(), e.getMetadatasList().stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue)))));
            byte[] encParam = msgMetadata.getEncryptionParam();
            Optional<Object> batchSize = Optional.ofNullable(msgMetadata.hasNumMessagesInBatch() ? Integer.valueOf(msgMetadata.getNumMessagesInBatch()) : null);
            encryptionCtx.setKeys(keys);
            encryptionCtx.setParam(encParam);
            if (msgMetadata.hasEncryptionAlgo()) {
                encryptionCtx.setAlgorithm(msgMetadata.getEncryptionAlgo());
            }
            encryptionCtx.setCompressionType(CompressionCodecProvider.convertFromWireProtocol((CompressionType)msgMetadata.getCompression()));
            encryptionCtx.setUncompressedMessageSize(msgMetadata.getUncompressedSize());
            encryptionCtx.setBatchSize(batchSize);
        }
        return Optional.ofNullable(encryptionCtx);
    }

    private int removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        int messagesFromQueue = 0;
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            MessageIdImpl messageId = this.getMessageIdImpl(peek);
            if (!messageIds.contains(messageId)) {
                return 0;
            }
            Message message = (Message)this.incomingMessages.poll();
            while (message != null) {
                this.decreaseIncomingMessageSize(message);
                ++messagesFromQueue;
                MessageIdImpl id = this.getMessageIdImpl(message);
                if (!messageIds.contains(id)) {
                    messageIds.add(id);
                    break;
                }
                message.release();
                message = (Message)this.incomingMessages.poll();
            }
        }
        return messagesFromQueue;
    }

    public ConsumerStatsRecorder getStats() {
        return this.stats;
    }

    void setTerminated() {
        log.info("[{}] [{}] [{}] Consumer has reached the end of topic", new Object[]{this.subscription, this.topic, this.consumerName});
        this.hasReachedEndOfTopic = true;
        if (this.listener != null) {
            this.listener.reachedEndOfTopic((Consumer)this);
        }
    }

    public boolean hasReachedEndOfTopic() {
        return this.hasReachedEndOfTopic;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.subscription, this.consumerName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsumerImpl)) {
            return false;
        }
        ConsumerImpl consumer = (ConsumerImpl)o;
        return this.consumerId == consumer.consumerId;
    }

    ClientCnx cnx() {
        return this.connectionHandler.cnx();
    }

    void resetBackoff() {
        this.connectionHandler.resetBackoff();
    }

    void connectionClosed(ClientCnx cnx) {
        this.connectionHandler.connectionClosed(cnx);
    }

    public ClientCnx getClientCnx() {
        return this.connectionHandler.cnx();
    }

    void setClientCnx(ClientCnx clientCnx) {
        ClientCnx previousClientCnx;
        if (clientCnx != null) {
            this.connectionHandler.setClientCnx(clientCnx);
            clientCnx.registerConsumer(this.consumerId, this);
            if (this.conf.isAckReceiptEnabled() && !Commands.peerSupportsAckReceipt((int)clientCnx.getRemoteEndpointProtocolVersion())) {
                log.warn("Server don't support ack for receipt! ProtoVersion >=17 support! nowVersion : {}", (Object)clientCnx.getRemoteEndpointProtocolVersion());
            }
        }
        if ((previousClientCnx = this.clientCnxUsedForConsumerRegistration.getAndSet(clientCnx)) != null && previousClientCnx != clientCnx) {
            previousClientCnx.removeConsumer(this.consumerId);
        }
    }

    void deregisterFromClientCnx() {
        this.setClientCnx(null);
    }

    void reconnectLater(Throwable exception) {
        this.connectionHandler.reconnectLater(exception);
    }

    void grabCnx() {
        this.connectionHandler.grabCnx();
    }

    public String getTopicNameWithoutPartition() {
        return this.topicNameWithoutPartition;
    }

    private void removeOldestPendingChunkedMessage() {
        ChunkedMessageCtx chunkedMsgCtx = null;
        String firstPendingMsgUuid = null;
        while (chunkedMsgCtx == null && !this.pendingChunkedMessageUuidQueue.isEmpty()) {
            firstPendingMsgUuid = (String)this.pendingChunkedMessageUuidQueue.poll();
            chunkedMsgCtx = StringUtils.isNotBlank((CharSequence)firstPendingMsgUuid) ? (ChunkedMessageCtx)this.chunkedMessagesMap.get((Object)firstPendingMsgUuid) : null;
        }
        this.removeChunkMessage(firstPendingMsgUuid, chunkedMsgCtx, this.autoAckOldestChunkedMessageOnQueueFull);
    }

    protected void removeExpireIncompleteChunkedMessages() {
        String messageUUID;
        if (this.expireTimeOfIncompleteChunkedMessageMillis <= 0L) {
            return;
        }
        ChunkedMessageCtx chunkedMsgCtx = null;
        while ((messageUUID = (String)this.pendingChunkedMessageUuidQueue.peek()) != null) {
            ChunkedMessageCtx chunkedMessageCtx = chunkedMsgCtx = StringUtils.isNotBlank((CharSequence)messageUUID) ? (ChunkedMessageCtx)this.chunkedMessagesMap.get((Object)messageUUID) : null;
            if (chunkedMsgCtx != null && System.currentTimeMillis() > chunkedMsgCtx.receivedTime + this.expireTimeOfIncompleteChunkedMessageMillis) {
                this.pendingChunkedMessageUuidQueue.remove(messageUUID);
                this.removeChunkMessage(messageUUID, chunkedMsgCtx, true);
                continue;
            }
            return;
        }
    }

    private void removeChunkMessage(String msgUUID, ChunkedMessageCtx chunkedMsgCtx, boolean autoAck) {
        if (chunkedMsgCtx == null) {
            return;
        }
        this.chunkedMessagesMap.remove((Object)msgUUID);
        if (chunkedMsgCtx.chunkedMessageIds != null) {
            for (MessageIdImpl msgId : chunkedMsgCtx.chunkedMessageIds) {
                if (msgId == null) continue;
                if (autoAck) {
                    log.info("Removing chunk message-id {}", (Object)msgId);
                    this.doAcknowledge(msgId, CommandAck.AckType.Individual, Collections.emptyMap(), null);
                    continue;
                }
                this.trackMessage(msgId);
            }
        }
        if (chunkedMsgCtx.chunkedMsgBuffer != null) {
            chunkedMsgCtx.chunkedMsgBuffer.release();
        }
        chunkedMsgCtx.recycle();
        --this.pendingChunkedMessageCount;
    }

    private CompletableFuture<Void> doTransactionAcknowledgeForResponse(MessageId messageId, CommandAck.AckType ackType, CommandAck.ValidationError validationError, Map<String, Long> properties, TxnID txnID) {
        ByteBuf cmd;
        BitSetRecyclable bitSetRecyclable = null;
        long requestId = this.client.newRequestId();
        if (messageId instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)messageId;
            bitSetRecyclable = BitSetRecyclable.create();
            long ledgerId = batchMessageId.getLedgerId();
            long entryId = batchMessageId.getEntryId();
            if (ackType == CommandAck.AckType.Cumulative) {
                batchMessageId.ackCumulative();
                bitSetRecyclable.set(0, batchMessageId.getBatchSize());
                bitSetRecyclable.clear(0, batchMessageId.getBatchIndex() + 1);
            } else {
                bitSetRecyclable.set(0, batchMessageId.getBatchSize());
                bitSetRecyclable.clear(batchMessageId.getBatchIndex());
            }
            cmd = Commands.newAck((long)this.consumerId, (long)ledgerId, (long)entryId, (BitSetRecyclable)bitSetRecyclable, (CommandAck.AckType)ackType, (CommandAck.ValidationError)validationError, properties, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (long)requestId, (int)batchMessageId.getBatchSize());
            bitSetRecyclable.recycle();
        } else {
            MessageIdImpl singleMessage = (MessageIdImpl)messageId;
            long ledgerId = singleMessage.getLedgerId();
            long entryId = singleMessage.getEntryId();
            cmd = Commands.newAck((long)this.consumerId, (long)ledgerId, (long)entryId, (BitSetRecyclable)bitSetRecyclable, (CommandAck.AckType)ackType, (CommandAck.ValidationError)validationError, properties, (long)txnID.getLeastSigBits(), (long)txnID.getMostSigBits(), (long)requestId);
        }
        if (ackType == CommandAck.AckType.Cumulative) {
            this.unAckedMessageTracker.removeMessagesTill(messageId);
        } else {
            this.unAckedMessageTracker.remove(messageId);
        }
        return this.cnx().newAckForReceipt(cmd, requestId);
    }

    public Map<MessageIdImpl, List<MessageImpl<T>>> getPossibleSendToDeadLetterTopicMessages() {
        return this.possibleSendToDeadLetterTopicMessages;
    }

    static class ChunkedMessageCtx {
        protected int totalChunks = -1;
        protected ByteBuf chunkedMsgBuffer;
        protected int lastChunkedMessageId = -1;
        protected MessageIdImpl[] chunkedMessageIds;
        protected long receivedTime = 0L;
        private final Recycler.Handle<ChunkedMessageCtx> recyclerHandle;
        private static final Recycler<ChunkedMessageCtx> RECYCLER = new Recycler<ChunkedMessageCtx>(){

            protected ChunkedMessageCtx newObject(Recycler.Handle<ChunkedMessageCtx> handle) {
                return new ChunkedMessageCtx(handle);
            }
        };

        static ChunkedMessageCtx get(int numChunksFromMsg, ByteBuf chunkedMsgBuffer) {
            ChunkedMessageCtx ctx = (ChunkedMessageCtx)RECYCLER.get();
            ctx.totalChunks = numChunksFromMsg;
            ctx.chunkedMsgBuffer = chunkedMsgBuffer;
            ctx.chunkedMessageIds = new MessageIdImpl[numChunksFromMsg];
            ctx.receivedTime = System.currentTimeMillis();
            return ctx;
        }

        private ChunkedMessageCtx(Recycler.Handle<ChunkedMessageCtx> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        public void recycle() {
            this.totalChunks = -1;
            this.chunkedMsgBuffer = null;
            this.lastChunkedMessageId = -1;
            this.recyclerHandle.recycle((Object)this);
        }
    }

    private static final class GetLastMessageIdResponse {
        final MessageId lastMessageId;
        final MessageId markDeletePosition;

        GetLastMessageIdResponse(MessageId lastMessageId, MessageId markDeletePosition) {
            this.lastMessageId = lastMessageId;
            this.markDeletePosition = markDeletePosition;
        }
    }
}

