/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.nio.ByteBuffer;

public class ZeroBuffer {
    private static final byte[] zeroBytes = new byte[65536];

    public static void put(ByteBuffer dst) {
        ZeroBuffer.put(dst, dst.remaining());
    }

    public static void put(ByteBuffer dst, int length) {
        while (length > zeroBytes.length) {
            dst.put(zeroBytes);
            length -= zeroBytes.length;
        }
        if (length > 0) {
            dst.put(zeroBytes, 0, length);
        }
    }

    public static ByteBuffer readOnlyBuffer(int length) {
        ByteBuffer buffer;
        if (length <= zeroBytes.length) {
            buffer = ByteBuffer.wrap(zeroBytes, 0, length);
        } else {
            buffer = ByteBuffer.allocate(length);
            ZeroBuffer.put(buffer);
            buffer.rewind();
        }
        return buffer.asReadOnlyBuffer();
    }
}

