/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;

public class TripleLongPriorityQueue
implements AutoCloseable {
    private static final int SIZE_OF_LONG = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int ITEMS_COUNT = 3;
    private static final int TUPLE_SIZE = 24;
    private final ByteBuf buffer;
    private int capacity;
    private int size;

    public TripleLongPriorityQueue() {
        this(16);
    }

    public TripleLongPriorityQueue(int initialCapacity) {
        this.capacity = initialCapacity;
        this.buffer = PooledByteBufAllocator.DEFAULT.directBuffer(initialCapacity * 3 * 8);
        this.size = 0;
    }

    @Override
    public void close() {
        this.buffer.release();
    }

    public void add(long n1, long n2, long n3) {
        if (this.size == this.capacity) {
            this.increaseCapacity();
        }
        this.put(this.size, n1, n2, n3);
        this.siftUp(this.size);
        ++this.size;
    }

    public long peekN1() {
        Preconditions.checkArgument((this.size != 0 ? 1 : 0) != 0);
        return this.buffer.getLong(0);
    }

    public long peekN2() {
        Preconditions.checkArgument((this.size != 0 ? 1 : 0) != 0);
        return this.buffer.getLong(8);
    }

    public long peekN3() {
        Preconditions.checkArgument((this.size != 0 ? 1 : 0) != 0);
        return this.buffer.getLong(16);
    }

    public void pop() {
        Preconditions.checkArgument((this.size != 0 ? 1 : 0) != 0);
        this.swap(0, this.size - 1);
        --this.size;
        this.siftDown(0);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.buffer.clear();
        this.size = 0;
    }

    private void increaseCapacity() {
        this.capacity += this.capacity <= 256 ? this.capacity : this.capacity / 2;
        this.buffer.capacity(this.capacity * 24);
    }

    private void siftUp(int idx) {
        int parentIdx;
        while (idx > 0 && this.compare(idx, parentIdx = (idx - 1) / 2) < 0) {
            this.swap(idx, parentIdx);
            idx = parentIdx;
        }
    }

    private void siftDown(int idx) {
        int half = this.size / 2;
        while (idx < half) {
            int left = 2 * idx + 1;
            int right = 2 * idx + 2;
            int swapIdx = idx;
            if (this.compare(idx, left) > 0) {
                swapIdx = left;
            }
            if (right < this.size && this.compare(swapIdx, right) > 0) {
                swapIdx = right;
            }
            if (swapIdx == idx) {
                return;
            }
            this.swap(idx, swapIdx);
            idx = swapIdx;
        }
    }

    private void put(int idx, long n1, long n2, long n3) {
        int i = idx * 24;
        this.buffer.setLong(i, n1);
        this.buffer.setLong(i + 8, n2);
        this.buffer.setLong(i + 16, n3);
    }

    private int compare(int idx1, int idx2) {
        int i1 = idx1 * 24;
        int i2 = idx2 * 24;
        int c1 = Long.compare(this.buffer.getLong(i1), this.buffer.getLong(i2));
        if (c1 != 0) {
            return c1;
        }
        int c2 = Long.compare(this.buffer.getLong(i1 + 8), this.buffer.getLong(i2 + 8));
        if (c2 != 0) {
            return c2;
        }
        return Long.compare(this.buffer.getLong(i1 + 16), this.buffer.getLong(i2 + 16));
    }

    private void swap(int idx1, int idx2) {
        int i1 = idx1 * 24;
        int i2 = idx2 * 24;
        long tmp1 = this.buffer.getLong(i1);
        long tmp2 = this.buffer.getLong(i1 + 8);
        long tmp3 = this.buffer.getLong(i1 + 16);
        this.buffer.setLong(i1, this.buffer.getLong(i2));
        this.buffer.setLong(i1 + 8, this.buffer.getLong(i2 + 8));
        this.buffer.setLong(i1 + 16, this.buffer.getLong(i2 + 16));
        this.buffer.setLong(i2, tmp1);
        this.buffer.setLong(i2 + 8, tmp2);
        this.buffer.setLong(i2 + 16, tmp3);
    }
}

