/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.batching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.apache.pulsar.metadata.impl.batching.MetadataOp;
import org.apache.pulsar.metadata.impl.batching.OpDelete;
import org.apache.pulsar.metadata.impl.batching.OpGet;
import org.apache.pulsar.metadata.impl.batching.OpGetChildren;
import org.apache.pulsar.metadata.impl.batching.OpPut;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchedMetadataStore
extends AbstractMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchedMetadataStore.class);
    private final ScheduledFuture<?> scheduledTask;
    private final MessagePassingQueue<MetadataOp> readOps;
    private final MessagePassingQueue<MetadataOp> writeOps;
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final boolean enabled;
    private final int maxDelayMillis;
    private final int maxOperations;
    private final int maxSize;

    protected AbstractBatchedMetadataStore(MetadataStoreConfig conf) {
        this.enabled = conf.isBatchingEnabled();
        this.maxDelayMillis = conf.getBatchingMaxDelayMillis();
        this.maxOperations = conf.getBatchingMaxOperations();
        this.maxSize = conf.getBatchingMaxSizeKb() * 1024;
        if (this.enabled) {
            this.readOps = new MpscUnboundedArrayQueue(10000);
            this.writeOps = new MpscUnboundedArrayQueue(10000);
            this.scheduledTask = this.executor.scheduleAtFixedRate(this::flush, this.maxDelayMillis, this.maxDelayMillis, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledTask = null;
            this.readOps = null;
            this.writeOps = null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.enabled) {
            IllegalStateException ex = new IllegalStateException("Metadata store is getting closed");
            this.readOps.drain(op -> op.getFuture().completeExceptionally(ex));
            this.writeOps.drain(op -> op.getFuture().completeExceptionally(ex));
            this.scheduledTask.cancel(true);
        }
        super.close();
    }

    private void flush() {
        while (!this.readOps.isEmpty()) {
            ArrayList<MetadataOp> ops = new ArrayList<MetadataOp>();
            this.readOps.drain(ops::add, this.maxOperations);
            this.batchOperation(ops);
        }
        while (!this.writeOps.isEmpty()) {
            MetadataOp op;
            int batchSize = 0;
            ArrayList<MetadataOp> ops = new ArrayList<MetadataOp>();
            for (int i = 0; i < this.maxOperations && (op = (MetadataOp)this.writeOps.peek()) != null && (i <= 0 || batchSize + op.size() <= this.maxSize); ++i) {
                batchSize += op.size();
                ops.add((MetadataOp)this.writeOps.poll());
            }
            this.batchOperation(ops);
        }
        this.flushInProgress.set(false);
    }

    @Override
    public final CompletableFuture<Optional<GetResult>> storeGet(String path) {
        OpGet op = new OpGet(path);
        this.enqueue(this.readOps, op);
        return op.getFuture();
    }

    @Override
    protected final CompletableFuture<List<String>> getChildrenFromStore(String path) {
        OpGetChildren op = new OpGetChildren(path);
        this.enqueue(this.readOps, op);
        return op.getFuture();
    }

    @Override
    protected final CompletableFuture<Void> storeDelete(String path, Optional<Long> expectedVersion) {
        OpDelete op = new OpDelete(path, expectedVersion);
        this.enqueue(this.writeOps, op);
        return op.getFuture();
    }

    @Override
    protected final CompletableFuture<Stat> storePut(String path, byte[] data, Optional<Long> optExpectedVersion, EnumSet<CreateOption> options) {
        OpPut op = new OpPut(path, data, optExpectedVersion, options);
        this.enqueue(this.writeOps, op);
        return op.getFuture();
    }

    private void enqueue(MessagePassingQueue queue, MetadataOp op) {
        if (this.enabled) {
            if (!queue.offer((Object)op)) {
                this.batchOperation(Collections.singletonList(op));
                return;
            }
            if (queue.size() > this.maxOperations && this.flushInProgress.compareAndSet(false, true)) {
                this.executor.execute(this::flush);
            }
        } else {
            this.batchOperation(Collections.singletonList(op));
        }
    }

    protected abstract void batchOperation(List<MetadataOp> var1);
}

