/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.twitter.data;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.twitter.data.TweetData;

public class TwitterRecord
implements Record<TweetData> {
    private final TweetData tweet;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
    private final boolean guestimateTweetTime;

    public TwitterRecord(TweetData tweet, boolean guestimateTweetTime) {
        this.tweet = tweet;
        this.guestimateTweetTime = guestimateTweetTime;
    }

    public Optional<String> getKey() {
        return Optional.empty();
    }

    public Optional<Long> getEventTime() {
        try {
            if (this.tweet.getCreatedAt() != null) {
                Date d = dateFormat.parse(this.tweet.getCreatedAt());
                return Optional.of(d.toInstant().toEpochMilli());
            }
            if (this.guestimateTweetTime) {
                return Optional.of(System.currentTimeMillis());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public TweetData getValue() {
        return this.tweet;
    }
}

